/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.Expression;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOIsNull;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PColFilterExtractor
extends LOVisitor {
    private List<String> partitionCols;
    private ArrayList<Expression> pColConditions = new ArrayList();
    private boolean sawKey;
    private boolean sawNonKeyCol;
    private Side replaceSide = Side.NONE;
    private boolean filterRemovable = false;

    @Override
    public void visit() throws VisitorException {
        try {
            ExpressionOperator leaf = (ExpressionOperator)((LogicalPlan)this.mPlan).getLeaves().get(0);
            if (leaf instanceof BinaryExpressionOperator) {
                this.visit((BinaryExpressionOperator)leaf);
                this.replaceChild(leaf);
                if (this.sawKey) {
                    this.pColConditions.add(PColFilterExtractor.getExpression(leaf));
                    this.filterRemovable = true;
                }
            }
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
    }

    public PColFilterExtractor(LogicalPlan plan, List<String> partitionCols) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
        this.partitionCols = new ArrayList<String>(partitionCols);
    }

    @Override
    protected void visit(LOProject project) throws VisitorException {
        try {
            String fieldName = project.getFieldSchema().alias;
            if (this.partitionCols.contains(fieldName)) {
                this.sawKey = true;
                ArrayList opsToCheckFor = new ArrayList();
                opsToCheckFor.add(LORegexp.class);
                int errCode = 1110;
                if (this.checkSuccessors(project, opsToCheckFor)) {
                    throw new FrontendException("Unsupported query: You have an partition column (" + fieldName + ") inside a regexp operator in the " + "filter condition.", errCode, 2);
                }
                opsToCheckFor.set(0, LOUserFunc.class);
                if (this.checkSuccessors(project, opsToCheckFor)) {
                    throw new FrontendException("Unsupported query: You have an partition column (" + fieldName + ") inside a function in the " + "filter condition.", errCode, 2);
                }
                opsToCheckFor.set(0, LOCast.class);
                if (this.checkSuccessors(project, opsToCheckFor)) {
                    throw new FrontendException("Unsupported query: You have an partition column (" + fieldName + ") inside a cast in the " + "filter condition.", errCode, 2);
                }
                opsToCheckFor.set(0, LOIsNull.class);
                if (this.checkSuccessors(project, opsToCheckFor)) {
                    throw new FrontendException("Unsupported query: You have an partition column (" + fieldName + ") inside a null check operator in the " + "filter condition.", errCode, 2);
                }
                opsToCheckFor.set(0, LOBinCond.class);
                if (this.checkSuccessors(project, opsToCheckFor)) {
                    throw new FrontendException("Unsupported query: You have an partition column (" + fieldName + ") inside a bincond operator in the " + "filter condition.", errCode, 2);
                }
                opsToCheckFor.set(0, LOAnd.class);
                opsToCheckFor.add(LOOr.class);
                if (this.checkSuccessors(project, opsToCheckFor)) {
                    errCode = 1112;
                    throw new FrontendException("Unsupported query: You have an partition column (" + fieldName + " ) in a construction like: " + "(pcond  and ...) or (pcond and ...) " + "where pcond is a condition on a partition column.", errCode, 2);
                }
            } else {
                this.sawNonKeyCol = true;
            }
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
    }

    @Override
    protected void visit(BinaryExpressionOperator binOp) throws VisitorException {
        try {
            boolean lhsSawKey = false;
            boolean rhsSawKey = false;
            boolean lhsSawNonKeyCol = false;
            boolean rhsSawNonKeyCol = false;
            this.sawKey = false;
            this.sawNonKeyCol = false;
            binOp.getLhsOperand().visit(this);
            this.replaceChild(binOp.getLhsOperand());
            lhsSawKey = this.sawKey;
            lhsSawNonKeyCol = this.sawNonKeyCol;
            this.sawKey = false;
            this.sawNonKeyCol = false;
            binOp.getRhsOperand().visit(this);
            this.replaceChild(binOp.getRhsOperand());
            rhsSawKey = this.sawKey;
            rhsSawNonKeyCol = this.sawNonKeyCol;
            if (binOp instanceof LOAnd) {
                if (lhsSawKey && rhsSawNonKeyCol) {
                    this.replaceSide = Side.LEFT;
                } else if (rhsSawKey && lhsSawNonKeyCol) {
                    this.replaceSide = Side.RIGHT;
                }
            } else if (lhsSawKey && rhsSawNonKeyCol || rhsSawKey && lhsSawNonKeyCol) {
                int errCode = 1111;
                String errMsg = "Use of partition column/condition with non partition column/condition in filter expression is not supported.";
                throw new FrontendException(errMsg, errCode, 2);
            }
            this.sawKey = lhsSawKey || rhsSawKey;
            this.sawNonKeyCol = lhsSawNonKeyCol || rhsSawNonKeyCol;
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
    }

    public Expression getPColCondition() {
        if (this.pColConditions.size() == 0) {
            return null;
        }
        Expression cond = this.pColConditions.get(0);
        for (int i = 1; i < this.pColConditions.size(); ++i) {
            cond = new Expression.BinaryExpression(cond, this.pColConditions.get(i), Expression.OpType.OP_AND);
        }
        return cond;
    }

    public boolean isFilterRemovable() {
        return this.filterRemovable;
    }

    private boolean checkSuccessors(LogicalOperator opToStartFrom, List<Class<?>> opsToCheckFor) throws FrontendException {
        boolean done = this.checkSuccessorsHelper(opToStartFrom, opsToCheckFor);
        if (!done && !opsToCheckFor.isEmpty()) {
            while (!done) {
                opToStartFrom = ((LogicalPlan)this.mPlan).getSuccessors(opToStartFrom).get(0);
                done = this.checkSuccessorsHelper(opToStartFrom, opsToCheckFor);
            }
        }
        return opsToCheckFor.isEmpty();
    }

    private boolean checkSuccessorsHelper(LogicalOperator opToStartFrom, List<Class<?>> opsToCheckFor) throws FrontendException {
        List<LogicalOperator> successors = ((LogicalPlan)this.mPlan).getSuccessors(opToStartFrom);
        if (successors == null || successors.size() == 0) {
            return true;
        }
        if (successors.size() == 1) {
            LogicalOperator suc = successors.get(0);
            if (suc.getClass().getCanonicalName().equals(opsToCheckFor.get(0).getCanonicalName())) {
                opsToCheckFor.remove(0);
                if (opsToCheckFor.isEmpty()) {
                    return true;
                }
            }
        } else {
            PColFilterExtractor.throwException();
        }
        return false;
    }

    private void replaceChild(ExpressionOperator childExpr) throws FrontendException {
        if (this.replaceSide == Side.NONE) {
            return;
        }
        if (!(childExpr instanceof BinaryExpressionOperator)) {
            PColFilterExtractor.throwException();
        }
        ExpressionOperator childLhs = ((BinaryExpressionOperator)childExpr).getLhsOperand();
        ExpressionOperator childRhs = ((BinaryExpressionOperator)childExpr).getRhsOperand();
        ((LogicalPlan)this.mPlan).disconnect(childLhs, childExpr);
        ((LogicalPlan)this.mPlan).disconnect(childRhs, childExpr);
        if (this.replaceSide == Side.LEFT) {
            this.remove(childLhs);
            ((LogicalPlan)this.mPlan).replace(childExpr, childRhs);
        } else if (this.replaceSide == Side.RIGHT) {
            this.remove(childRhs);
            ((LogicalPlan)this.mPlan).replace(childExpr, childLhs);
        } else {
            PColFilterExtractor.throwException();
        }
        this.replaceSide = Side.NONE;
        this.sawKey = false;
    }

    private void remove(ExpressionOperator op) throws FrontendException {
        this.pColConditions.add(PColFilterExtractor.getExpression(op));
        ((LogicalPlan)this.mPlan).trimAbove(op);
        ((LogicalPlan)this.mPlan).remove(op);
    }

    public static Expression getExpression(ExpressionOperator op) throws FrontendException {
        BinaryExpressionOperator binOp;
        if (op instanceof LOConst) {
            return new Expression.Const(((LOConst)op).getValue());
        }
        if (op instanceof LOProject) {
            String fieldName = ((LOProject)op).getFieldSchema().alias;
            return new Expression.Column(fieldName);
        }
        if (!(op instanceof BinaryExpressionOperator)) {
            PColFilterExtractor.throwException();
        }
        if ((binOp = (BinaryExpressionOperator)op) instanceof LOAdd) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_PLUS);
        }
        if (binOp instanceof LOSubtract) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_MINUS);
        }
        if (binOp instanceof LOMultiply) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_TIMES);
        }
        if (binOp instanceof LODivide) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_DIV);
        }
        if (binOp instanceof LOMod) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_MOD);
        }
        if (binOp instanceof LOAnd) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_AND);
        }
        if (binOp instanceof LOOr) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_OR);
        }
        if (binOp instanceof LOEqual) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_EQ);
        }
        if (binOp instanceof LONotEqual) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_NE);
        }
        if (binOp instanceof LOGreaterThan) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_GT);
        }
        if (binOp instanceof LOGreaterThanEqual) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_GE);
        }
        if (binOp instanceof LOLesserThan) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_LT);
        }
        if (binOp instanceof LOLesserThanEqual) {
            return PColFilterExtractor.getExpression(binOp, Expression.OpType.OP_LE);
        }
        PColFilterExtractor.throwException();
        return null;
    }

    private static Expression getExpression(BinaryExpressionOperator binOp, Expression.OpType opType) throws FrontendException {
        return new Expression.BinaryExpression(PColFilterExtractor.getExpression(binOp.getLhsOperand()), PColFilterExtractor.getExpression(binOp.getRhsOperand()), opType);
    }

    public static void throwException() throws FrontendException {
        int errCode = 2209;
        throw new FrontendException("Internal error while processing any partition filter conditions in the filter after the load", errCode, 4);
    }

    @Override
    public void visit(LOAdd op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOAnd op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LODivide op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOGreaterThan op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOGreaterThanEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOLesserThan op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOLesserThanEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOMod op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOMultiply op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LONotEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOOr op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOSubtract op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    protected void visit(ExpressionOperator op) throws VisitorException {
        if (op instanceof LOProject) {
            this.visit((LOProject)op);
        } else if (op instanceof BinaryExpressionOperator) {
            this.visit((BinaryExpressionOperator)op);
        } else if (op instanceof LOCast) {
            this.visit((LOCast)op);
        } else if (op instanceof LOBinCond) {
            this.visit((LOBinCond)op);
        } else if (op instanceof LOUserFunc) {
            this.visit((LOUserFunc)op);
        } else if (op instanceof LOIsNull) {
            this.visit((LOIsNull)op);
        }
    }

    @Override
    protected void visit(LOCast cast) throws VisitorException {
        this.visit(cast.getExpression());
    }

    @Override
    public void visit(LONot not) throws VisitorException {
        this.visit(not.getOperand());
    }

    @Override
    protected void visit(LORegexp regexp) throws VisitorException {
        this.visit((BinaryExpressionOperator)regexp);
    }

    @Override
    protected void visit(LOBinCond binCond) throws VisitorException {
        this.visit(binCond.getCond());
        this.visit(binCond.getLhsOp());
        this.visit(binCond.getRhsOp());
    }

    @Override
    protected void visit(LOUserFunc udf) throws VisitorException {
        for (ExpressionOperator op : udf.getArguments()) {
            this.visit(op);
        }
    }

    @Override
    public void visit(LOIsNull isNull) throws VisitorException {
        this.visit(isNull.getOperand());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Side {
        LEFT,
        RIGHT,
        NONE;

    }
}

