/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LONative;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpLimitOptimizer
extends LogicalTransformer {
    private static final Log log = LogFactory.getLog(OpLimitOptimizer.class);
    private ExecType mode = ExecType.MAPREDUCE;

    public OpLimitOptimizer(LogicalPlan plan) {
        super(plan);
    }

    public OpLimitOptimizer(LogicalPlan plan, ExecType mode) {
        super(plan);
        this.mode = mode;
    }

    @Override
    public boolean check(List<LogicalOperator> nodes) throws OptimizerException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        try {
            LogicalOperator lo = nodes.get(0);
            if (lo == null || !(lo instanceof LOLimit)) {
                int errCode = 2005;
                String msg = "Expected " + LOLimit.class.getSimpleName() + ", got " + (lo == null ? lo : lo.getClass().getSimpleName());
                throw new OptimizerException(msg, errCode, 4);
            }
            List<LogicalOperator> predecessors = ((LogicalPlan)this.mPlan).getPredecessors(lo);
            if (predecessors.size() != 1) {
                int errCode = 2008;
                String msg = "Limit cannot have more than one input. Found " + predecessors.size() + " inputs.";
                throw new OptimizerException(msg, errCode, 4);
            }
            LogicalOperator predecessor = predecessors.get(0);
            if (predecessor instanceof LOCogroup || predecessor instanceof LOFilter || predecessor instanceof LOLoad || predecessor instanceof LOSplit || predecessor instanceof LODistinct || predecessor instanceof LOJoin || predecessor instanceof LOStream || predecessor instanceof LONative) {
                return false;
            }
            if (predecessor instanceof LOForEach) {
                LOForEach loForEach = (LOForEach)predecessor;
                List<Boolean> mFlatten = loForEach.getFlatten();
                boolean hasFlatten = false;
                for (Boolean b : mFlatten) {
                    if (!b.equals(true)) continue;
                    hasFlatten = true;
                }
                if (hasFlatten) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            int errCode = 2049;
            String msg = "Error while performing checks to optimize limit operator.";
            throw new OptimizerException(msg, errCode, 4);
        }
        return true;
    }

    @Override
    public void transform(List<LogicalOperator> nodes) throws OptimizerException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        try {
            LogicalOperator lo = nodes.get(0);
            if (lo == null || !(lo instanceof LOLimit)) {
                int errCode = 2005;
                String msg = "Expected " + LOLimit.class.getSimpleName() + ", got " + (lo == null ? lo : lo.getClass().getSimpleName());
                throw new OptimizerException(msg, errCode, 4);
            }
            LOLimit limit = (LOLimit)lo;
            this.processNode(limit);
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2050;
            String msg = "Internal error. Unable to optimize limit operator.";
            throw new OptimizerException(msg, errCode, 4);
        }
    }

    public void processNode(LOLimit limit) throws OptimizerException {
        block27: {
            List<LOLimit> predecessors = ((LogicalPlan)this.mPlan).getPredecessors(limit);
            if (predecessors.size() != 1) {
                int errCode = 2008;
                String msg = "Limit cannot have more than one input. Found " + predecessors.size() + " inputs.";
                throw new OptimizerException(msg, errCode, 4);
            }
            LogicalOperator predecessor = predecessors.get(0);
            if (predecessor instanceof LOCogroup || predecessor instanceof LOFilter || predecessor instanceof LOLoad || predecessor instanceof LOSplit || predecessor instanceof LODistinct || predecessor instanceof LOJoin || predecessor instanceof LOStream || predecessor instanceof LONative) {
                return;
            }
            if (predecessor instanceof LOForEach) {
                LOForEach loForEach = (LOForEach)predecessor;
                List<Boolean> mFlatten = loForEach.getFlatten();
                boolean hasFlatten = false;
                for (Boolean b : mFlatten) {
                    if (!b.equals(true)) continue;
                    hasFlatten = true;
                }
                if (!hasFlatten) {
                    LogicalOperator prepredecessor = ((LogicalPlan)this.mPlan).getPredecessors(predecessor).get(0);
                    if (prepredecessor != null) {
                        try {
                            ((LogicalPlan)this.mPlan).removeAndReconnect(limit);
                            this.insertBetween(prepredecessor, limit, predecessor, null);
                        }
                        catch (Exception e) {
                            int errCode = 2009;
                            String msg = "Can not move LOLimit up";
                            throw new OptimizerException(msg, errCode, 4, e);
                        }
                    } else {
                        int errCode = 2010;
                        String msg = "LOForEach should have one input";
                        throw new OptimizerException(msg, errCode, 4);
                    }
                    this.processNode(limit);
                }
                break block27;
            }
            if (predecessor instanceof LOCross || predecessor instanceof LOUnion) {
                LOLimit newLimit = null;
                ArrayList<LogicalOperator> nodesToProcess = new ArrayList<LogicalOperator>();
                for (LogicalOperator prepredecessor : ((LogicalPlan)this.mPlan).getPredecessors(predecessor)) {
                    nodesToProcess.add(prepredecessor);
                }
                for (LogicalOperator prepredecessor : nodesToProcess) {
                    try {
                        newLimit = limit.duplicate();
                        this.insertBetween(prepredecessor, newLimit, predecessor, null);
                    }
                    catch (Exception e) {
                        int errCode = 2011;
                        String msg = "Can not insert LOLimit clone";
                        throw new OptimizerException(msg, errCode, 4, e);
                    }
                    this.processNode(newLimit);
                }
                break block27;
            }
            if (predecessor instanceof LOSort) {
                if (this.mode == ExecType.LOCAL) break block27;
                LOSort sort = (LOSort)predecessor;
                if (sort.getLimit() == -1L) {
                    sort.setLimit(limit.getLimit());
                } else {
                    sort.setLimit(sort.getLimit() < limit.getLimit() ? sort.getLimit() : limit.getLimit());
                }
                try {
                    ((LogicalPlan)this.mPlan).removeAndReconnect(limit);
                    break block27;
                }
                catch (Exception e) {
                    int errCode = 2012;
                    String msg = "Can not remove LOLimit after LOSort";
                    throw new OptimizerException(msg, errCode, 4, e);
                }
            }
            if (predecessor instanceof LOLimit) {
                LOLimit beforeLimit;
                beforeLimit.setLimit((beforeLimit = (LOLimit)predecessor).getLimit() < limit.getLimit() ? beforeLimit.getLimit() : limit.getLimit());
                try {
                    ((LogicalPlan)this.mPlan).removeAndReconnect(limit);
                    break block27;
                }
                catch (Exception e) {
                    int errCode = 2012;
                    String msg = "Can not remove LOLimit after LOLimit";
                    throw new OptimizerException(msg, errCode, 4, e);
                }
            }
            if (predecessor instanceof LOSplitOutput) {
                List<Operator> greatGrandparants;
                List<LogicalOperator> grandparants;
                if (this.mode == ExecType.LOCAL || (grandparants = ((LogicalPlan)this.mPlan).getPredecessors(predecessor)) == null || grandparants.size() == 0 || !(grandparants.get(0) instanceof LOSplit) || (greatGrandparants = ((LogicalPlan)this.mPlan).getPredecessors((Operator)grandparants.get(0))) == null || greatGrandparants.size() == 0 || !(greatGrandparants.get(0) instanceof LOSort)) break block27;
                LOSort sort = (LOSort)greatGrandparants.get(0);
                LOSort newSort = new LOSort(sort.getPlan(), new OperatorKey(sort.getOperatorKey().scope, NodeIdGenerator.getGenerator().getNextNodeId(sort.getOperatorKey().scope)), sort.getSortColPlans(), sort.getAscendingCols(), sort.getUserFunc());
                newSort.setLimit(limit.getLimit());
                try {
                    ((LogicalPlan)this.mPlan).replace(limit, newSort);
                    break block27;
                }
                catch (PlanException e) {
                    int errCode = 2012;
                    String msg = "Can not replace LOLimit with LOSort after splitter";
                    throw new OptimizerException(msg, errCode, 4, e);
                }
            }
            int errCode = 2013;
            String msg = "Moving LOLimit in front of " + predecessor.getClass().getSimpleName() + " is not implemented";
            throw new OptimizerException(msg, errCode, 4);
        }
    }
}

