/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadPushDown;
import org.apache.pig.impl.logicalLayer.ColumnPruner;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.logicalLayer.optimizer.RequiredInfo;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.MapKeysInfo;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PruneColumns
extends LogicalTransformer {
    private boolean safeToPrune = true;
    private static Log log = LogFactory.getLog(PruneColumns.class);
    Map<RelationalOperator, RequiredInfo> cachedRequiredInfo = new HashMap<RelationalOperator, RequiredInfo>();
    private Map<LOLoad, RequiredFields> prunedLoaderColumnsMap = new HashMap<LOLoad, RequiredFields>();
    ColumnPruner pruner;

    public PruneColumns(LogicalPlan plan) {
        super(plan);
        this.pruner = new ColumnPruner(plan);
    }

    @Override
    public boolean check(List<LogicalOperator> nodes) throws OptimizerException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2177;
            String msg = "Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        try {
            LogicalOperator lo = nodes.get(0);
            if (lo == null) {
                int errCode = 2178;
                String msg = "The matching node from the optimizor framework is null";
                throw new OptimizerException(msg, errCode, 4);
            }
            return (lo instanceof LOForEach || lo instanceof LOSplit) && lo.getSchema() != null;
        }
        catch (Exception e) {
            int errCode = 2179;
            String msg = "Error while performing checks to prune columns.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    @Override
    public void transform(List<LogicalOperator> nodes) throws OptimizerException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2177;
            String msg = "Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        try {
            LogicalOperator lo = nodes.get(0);
            if (lo == null || !(lo instanceof LOForEach) && !(lo instanceof LOSplit)) {
                int errCode = 2178;
                String msg = "Expected " + LOForEach.class.getSimpleName() + " or " + LOSplit.class.getSimpleName();
                throw new OptimizerException(msg, errCode, 4);
            }
            RequiredInfo requiredOutputInfo = this.cachedRequiredInfo.get(lo);
            if (requiredOutputInfo == null) {
                ArrayList<RequiredFields> requiredOutputFieldsList = new ArrayList<RequiredFields>();
                List<LogicalOperator> successors = ((LogicalPlan)this.mPlan).getSuccessors(lo);
                if (successors == null) {
                    requiredOutputFieldsList.add(new RequiredFields(true));
                } else {
                    for (int i = 0; i < successors.size(); ++i) {
                        requiredOutputFieldsList.add(new RequiredFields(true));
                    }
                }
                requiredOutputInfo = new RequiredInfo(requiredOutputFieldsList);
            }
            this.processNode(lo, requiredOutputInfo);
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2181;
            String msg = "Unable to prune columns.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    public void processNode(LogicalOperator lo, RequiredInfo requiredOutputInfo) throws OptimizerException {
        try {
            List<RequiredFields> requiredFieldsListOfLOOp;
            ArrayList<RelationalOperator> predecessors;
            if (!this.safeToPrune) {
                return;
            }
            if (!(lo instanceof RelationalOperator)) {
                int errCode = 2182;
                String msg = "Only relational operator can be used in column prune optimization.";
                throw new OptimizerException(msg, errCode, 4);
            }
            if (lo.getSchema() == null) {
                this.safeToPrune = false;
                return;
            }
            RelationalOperator rlo = (RelationalOperator)lo;
            ArrayList<RelationalOperator> arrayList = predecessors = ((LogicalPlan)this.mPlan).getPredecessors(rlo) == null ? null : new ArrayList<RelationalOperator>(((LogicalPlan)this.mPlan).getPredecessors(rlo));
            if (rlo instanceof LOLoad) {
                RequiredFields loaderRequiredFields = requiredOutputInfo.requiredFieldsList.get(0);
                this.prunedLoaderColumnsMap.put((LOLoad)rlo, loaderRequiredFields);
                return;
            }
            if (rlo instanceof LOStore || rlo instanceof LOStream || rlo instanceof LODistinct) {
                return;
            }
            if (rlo instanceof LOSplit) {
                ArrayList<RequiredFields> requiredInputFieldsList = new ArrayList<RequiredFields>();
                RequiredFields requiredFields = new RequiredFields(false);
                for (int i = 0; i < ((LogicalPlan)this.mPlan).getSuccessors(rlo).size(); ++i) {
                    RequiredFields rf = null;
                    try {
                        rf = requiredOutputInfo.requiredFieldsList.get(i);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (rf == null) {
                        ArrayList<Pair<Integer, Integer>> l = new ArrayList<Pair<Integer, Integer>>();
                        for (int j = 0; j < rlo.getSchema().size(); ++j) {
                            l.add(new Pair<Integer, Integer>(0, j));
                        }
                        rf = new RequiredFields(l);
                        requiredFields.merge(rf);
                        break;
                    }
                    rf.reIndex(0);
                    requiredFields.merge(rf);
                }
                requiredInputFieldsList.add(requiredFields);
                if (predecessors.get(0) instanceof LOForEach || predecessors.get(0) instanceof LOSplit) {
                    this.cachedRequiredInfo.put((RelationalOperator)predecessors.get(0), new RequiredInfo(requiredInputFieldsList));
                } else {
                    this.processNode((LogicalOperator)predecessors.get(0), new RequiredInfo(requiredInputFieldsList));
                }
                return;
            }
            ArrayList<RequiredFields> requiredInputFieldsList = new ArrayList<RequiredFields>();
            for (int i = 0; i < predecessors.size(); ++i) {
                requiredInputFieldsList.add(null);
            }
            RequiredFields requiredOutputFields = requiredOutputInfo.requiredFieldsList.get(0);
            if (requiredOutputFields.needAllFields()) {
                ArrayList<Pair<Integer, Integer>> outputList = new ArrayList<Pair<Integer, Integer>>();
                for (int j = 0; j < rlo.getSchema().size(); ++j) {
                    outputList.add(new Pair<Integer, Integer>(0, j));
                }
                requiredOutputFields = new RequiredFields(outputList);
                for (int i = 0; i < requiredOutputFields.size(); ++i) {
                    requiredOutputFields.setMapKeysInfo(i, new MapKeysInfo(true));
                }
            }
            if (requiredOutputFields.getFields() == null) {
                int errCode = 2184;
                String msg = "Fields list inside RequiredFields is null.";
                throw new OptimizerException(msg, errCode, 4);
            }
            for (int i = 0; i < requiredOutputFields.size(); ++i) {
                Pair<Integer, Integer> requiredOutputField = requiredOutputFields.getField(i);
                MapKeysInfo outputMapKeysInfo = requiredOutputFields.getMapKeysInfo(i);
                List<RequiredFields> relevantFieldsList = rlo.getRelevantInputs((Integer)requiredOutputField.first, (Integer)requiredOutputField.second);
                if (relevantFieldsList == null) continue;
                for (int j = 0; j < relevantFieldsList.size(); ++j) {
                    RequiredFields relevantFields = relevantFieldsList.get(j);
                    if (relevantFields != null && relevantFields.needAllFields()) {
                        requiredInputFieldsList.set(j, new RequiredFields(true));
                        continue;
                    }
                    if (rlo instanceof LOCogroup) {
                        if (j != 0 && relevantFields != null && !relevantFields.needAllFields()) {
                            for (Pair<Integer, Integer> pair : relevantFields.getFields()) {
                                relevantFields.setMapKeysInfo((Integer)pair.first, (Integer)pair.second, new MapKeysInfo(true));
                            }
                        }
                    } else if (rlo instanceof LOForEach) {
                        LogicalPlan forEachPlan = ((LOForEach)rlo).getRelevantPlan((Integer)requiredOutputField.second);
                        if (relevantFields.getFields() != null && relevantFields.getFields().size() != 0) {
                            LOProject loProj;
                            int index = ((LOForEach)rlo).getForEachPlans().indexOf(forEachPlan);
                            boolean nonflatten = false;
                            if (!((LOForEach)rlo).getFlatten().get(index).booleanValue()) {
                                nonflatten = true;
                            } else if (forEachPlan.getRoots().size() == 1 && forEachPlan.getRoots().get(0) instanceof LOProject && (loProj = (LOProject)forEachPlan.getRoots().get(0)).getExpression().getSchema() != null && loProj.getExpression().getSchema().getField((int)loProj.getCol()).type != 120) {
                                nonflatten = true;
                            }
                            if (nonflatten && outputMapKeysInfo != null && this.isSimpleProjectCast(forEachPlan)) {
                                Pair<Integer, Integer> inputColumn = relevantFields.getFields().get(0);
                                relevantFields.setMapKeysInfo((Integer)inputColumn.first, (Integer)inputColumn.second, outputMapKeysInfo);
                            }
                        }
                        for (Pair<Integer, Integer> relevantField : relevantFields.getFields()) {
                            MapKeysInfo mapKeysInfo = this.getMapKeysInPlan(forEachPlan, (Integer)relevantField.second);
                            relevantFields.mergeMapKeysInfo(0, (Integer)relevantField.second, mapKeysInfo);
                        }
                    } else if (relevantFields != null && relevantFields.getFields() != null && outputMapKeysInfo != null) {
                        for (Pair<Integer, Integer> pair : relevantFields.getFields()) {
                            relevantFields.setMapKeysInfo((Integer)pair.first, (Integer)pair.second, outputMapKeysInfo);
                        }
                    }
                    if (requiredInputFieldsList.get(j) == null) {
                        requiredInputFieldsList.set(j, relevantFields);
                        continue;
                    }
                    ((RequiredFields)requiredInputFieldsList.get(j)).merge(relevantFields);
                }
            }
            if (rlo instanceof LOForEach) {
                ArrayList<Pair<Integer, Integer>> flattenedInputs = new ArrayList<Pair<Integer, Integer>>();
                for (int i = 0; i < rlo.getSchema().size(); ++i) {
                    if (!((LOForEach)rlo).isInputFlattened(i)) continue;
                    flattenedInputs.add(new Pair<Integer, Integer>(0, i));
                }
                if (!flattenedInputs.isEmpty()) {
                    requiredFieldsListOfLOOp = new ArrayList<RequiredFields>();
                    requiredFieldsListOfLOOp.add(new RequiredFields(flattenedInputs));
                } else {
                    requiredFieldsListOfLOOp = null;
                }
            } else {
                requiredFieldsListOfLOOp = rlo instanceof LOCross || rlo instanceof LOUnion ? null : rlo.getRequiredFields();
            }
            if (requiredFieldsListOfLOOp != null) {
                int i;
                for (i = 0; i < requiredFieldsListOfLOOp.size(); ++i) {
                    RequiredFields requiredFieldsOfLOOp = requiredFieldsListOfLOOp.get(i);
                    if (requiredInputFieldsList.get(i) == null) {
                        requiredInputFieldsList.set(i, requiredFieldsOfLOOp);
                        continue;
                    }
                    ((RequiredFields)requiredInputFieldsList.get(i)).merge(requiredFieldsOfLOOp);
                }
                if (rlo instanceof LOFilter || rlo instanceof LOSplitOutput || rlo instanceof LOSort) {
                    ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>();
                    if (rlo instanceof LOFilter) {
                        innerPlans.add(((LOFilter)rlo).getComparisonPlan());
                    } else if (rlo instanceof LOSplitOutput) {
                        innerPlans.add(((LOSplitOutput)rlo).getConditionPlan());
                    } else if (rlo instanceof LOSort) {
                        innerPlans.addAll(((LOSort)rlo).getSortColPlans());
                    }
                    for (LogicalPlan p : innerPlans) {
                        for (RequiredFields rf : requiredFieldsListOfLOOp) {
                            if (rf.getFields() == null) continue;
                            for (Pair<Integer, Integer> pair : rf.getFields()) {
                                MapKeysInfo mapKeysInfo = this.getMapKeysInPlan(p, (Integer)pair.second);
                                if (mapKeysInfo == null || mapKeysInfo.needAllKeys() || mapKeysInfo.getKeys() == null) continue;
                                ((RequiredFields)requiredInputFieldsList.get(0)).mergeMapKeysInfo(0, (Integer)pair.second, mapKeysInfo);
                            }
                        }
                    }
                } else if (rlo instanceof LOJoin) {
                    for (i = 0; i < predecessors.size(); ++i) {
                        Collection<LogicalPlan> joinPlans = ((LOJoin)rlo).getJoinPlans().get((LogicalOperator)predecessors.get(i));
                        if (joinPlans == null) continue;
                        for (LogicalPlan p : joinPlans) {
                            RequiredFields rf;
                            rf = requiredFieldsListOfLOOp.get(i);
                            if (rf.getFields() == null) continue;
                            for (Pair<Integer, Integer> pair : rf.getFields()) {
                                MapKeysInfo mapKeysInfo = this.getMapKeysInPlan(p, (Integer)pair.second);
                                if (mapKeysInfo == null || mapKeysInfo.needAllKeys() || mapKeysInfo.getKeys() == null) continue;
                                ((RequiredFields)requiredInputFieldsList.get(i)).mergeMapKeysInfo(i, (Integer)pair.second, mapKeysInfo);
                            }
                        }
                    }
                }
            }
            for (int i = 0; i < predecessors.size(); ++i) {
                RelationalOperator predecessor = (RelationalOperator)predecessors.get(i);
                List<RequiredFields> newRequiredOutputFieldsList = new ArrayList<RequiredFields>();
                if (requiredInputFieldsList.get(i) == null || ((RequiredFields)requiredInputFieldsList.get(i)).getNeedNoFields()) {
                    ArrayList<Pair<Integer, Integer>> dummyFields = new ArrayList<Pair<Integer, Integer>>();
                    dummyFields.add(new Pair<Integer, Integer>(i, 0));
                    requiredInputFieldsList.set(i, new RequiredFields(dummyFields));
                }
                if (!(predecessor instanceof LOSplit)) {
                    if (requiredInputFieldsList.get(i) != null) {
                        ((RequiredFields)requiredInputFieldsList.get(i)).reIndex(0);
                    }
                    newRequiredOutputFieldsList.add((RequiredFields)requiredInputFieldsList.get(i));
                }
                if (predecessor instanceof LOForEach) {
                    this.cachedRequiredInfo.put(predecessor, new RequiredInfo(newRequiredOutputFieldsList));
                    continue;
                }
                if (predecessor instanceof LOSplit) {
                    int outputIndex = ((LogicalPlan)this.mPlan).getSuccessors(predecessor).indexOf(rlo);
                    if (outputIndex == -1) {
                        int errCode = 2186;
                        String msg = "Cannot locate node from successor";
                        throw new OptimizerException(msg, errCode, 4);
                    }
                    if (requiredInputFieldsList.get(i) != null) {
                        ((RequiredFields)requiredInputFieldsList.get(i)).reIndex(outputIndex);
                    }
                    if (this.cachedRequiredInfo.containsKey(predecessor)) {
                        newRequiredOutputFieldsList = this.cachedRequiredInfo.get((Object)predecessor).requiredFieldsList;
                    }
                    while (newRequiredOutputFieldsList.size() <= outputIndex) {
                        newRequiredOutputFieldsList.add(null);
                    }
                    newRequiredOutputFieldsList.set(outputIndex, (RequiredFields)requiredInputFieldsList.get(i));
                    this.cachedRequiredInfo.put(predecessor, new RequiredInfo(newRequiredOutputFieldsList));
                    continue;
                }
                this.processNode((LogicalOperator)predecessors.get(i), new RequiredInfo(newRequiredOutputFieldsList));
            }
        }
        catch (FrontendException e) {
            int errCode = 2211;
            String msg = "Unable to prune columns when processing node " + lo;
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    private MapKeysInfo getMapKeysInPlan(LogicalPlan plan, int column) throws OptimizerException {
        if (this.isSimpleProjectCast(plan)) {
            return null;
        }
        boolean requireAll = false;
        ArrayList<String> mapKeys = null;
        TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
        try {
            projectFinder.visit();
        }
        catch (VisitorException ve) {
            int errCode = 2200;
            String msg = "Error getting top level project ";
            throw new OptimizerException(msg, errCode, 4, ve);
        }
        for (LOProject project : projectFinder.getProjectSet()) {
            if (project.isStar() || project.getCol() != column) continue;
            List<ExpressionOperator> successors = plan.getSuccessors(project);
            while (successors != null && successors.size() == 1 && successors.get(0) instanceof LOCast) {
                LOCast cast = (LOCast)((Object)successors.get(0));
                successors = plan.getSuccessors(cast);
            }
            if (successors != null && successors.size() == 1 && successors.get(0) instanceof LOMapLookup) {
                LOMapLookup loMapLookup = (LOMapLookup)((Object)successors.get(0));
                if (loMapLookup.getLookUpKey() != null) {
                    if (mapKeys == null) {
                        mapKeys = new ArrayList<String>();
                    }
                    if (!mapKeys.contains(loMapLookup.getLookUpKey())) {
                        mapKeys.add(loMapLookup.getLookUpKey());
                    }
                }
                requireAll = false;
                continue;
            }
            requireAll = true;
        }
        return new MapKeysInfo(requireAll, mapKeys);
    }

    private boolean isSimpleProjectCast(LogicalPlan innerPlan) throws OptimizerException {
        TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(innerPlan);
        try {
            projectFinder.visit();
        }
        catch (VisitorException ve) {
            throw new OptimizerException();
        }
        boolean relayingMapKeys = false;
        if (projectFinder.getProjectSet() != null && projectFinder.getProjectSet().size() == 1) {
            LOProject project = projectFinder.getProjectSet().iterator().next();
            if (innerPlan.getPredecessors(project) == null) {
                relayingMapKeys = true;
                LogicalOperator pred = project;
                while (innerPlan.getSuccessors(pred) != null) {
                    if (innerPlan.getSuccessors(pred).size() != 1) {
                        return false;
                    }
                    if (!(innerPlan.getSuccessors(pred).get(0) instanceof LOCast)) {
                        return false;
                    }
                    pred = innerPlan.getSuccessors(pred).get(0);
                }
            }
            if (relayingMapKeys) {
                return true;
            }
        }
        return false;
    }

    private void pruneLoader(LOLoad load, RequiredFields loaderRequiredFields) throws FrontendException {
        LoadPushDown.RequiredFieldList requiredFieldList = new LoadPushDown.RequiredFieldList();
        if (loaderRequiredFields == null || loaderRequiredFields.needAllFields()) {
            return;
        }
        Schema loadSchema = load.getSchema();
        for (int i = 0; i < loaderRequiredFields.size(); ++i) {
            int j;
            Pair<Integer, Integer> pair = loaderRequiredFields.getField(i);
            MapKeysInfo mapKeysInfo = loaderRequiredFields.getMapKeysInfo(i);
            LoadPushDown.RequiredField requiredField = new LoadPushDown.RequiredField();
            requiredField.setIndex((Integer)pair.second);
            requiredField.setAlias(loadSchema.getField((int)((Integer)pair.second).intValue()).alias);
            requiredField.setType(loadSchema.getField((int)((Integer)pair.second).intValue()).type);
            if (mapKeysInfo != null && !mapKeysInfo.needAllKeys()) {
                ArrayList<LoadPushDown.RequiredField> subFieldList = new ArrayList<LoadPushDown.RequiredField>();
                for (String key : mapKeysInfo.getKeys()) {
                    LoadPushDown.RequiredField mapKeyField = new LoadPushDown.RequiredField();
                    mapKeyField.setIndex(-1);
                    mapKeyField.setType((byte)0);
                    mapKeyField.setAlias(key);
                    subFieldList.add(mapKeyField);
                }
                requiredField.setSubFields(subFieldList);
            }
            for (j = 0; requiredFieldList.getFields().size() > j && requiredFieldList.getFields().get(j).getIndex() < (Integer)pair.second; ++j) {
            }
            requiredFieldList.getFields().add(j, requiredField);
        }
        boolean[] columnRequired = new boolean[load.getSchema().size()];
        LoadPushDown.RequiredFieldResponse response = null;
        try {
            response = load.pushProjection(requiredFieldList);
        }
        catch (FrontendException e) {
            log.warn((Object)("fieldsToRead on " + load + " throw an exception, skip it"));
        }
        if (response == null || !response.getRequiredFieldResponse()) {
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getType() != 100) continue;
                rf.setSubFields(null);
            }
            try {
                response = load.pushProjection(requiredFieldList);
            }
            catch (FrontendException e) {
                log.warn((Object)("fieldsToRead on " + load + " throw an exception, skip it"));
            }
        }
        LogicalOperator forEach = null;
        if (response == null || !response.getRequiredFieldResponse()) {
            ArrayList<Integer> columnsToProject = new ArrayList<Integer>();
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                columnsToProject.add(rf.getIndex());
            }
            forEach = load.insertPlainForEachAfter(columnsToProject);
        }
        for (Pair<Integer, Integer> pair : loaderRequiredFields.getFields()) {
            columnRequired[((Integer)pair.second).intValue()] = true;
        }
        ArrayList<Pair<Integer, Integer>> pruneList = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < columnRequired.length; ++i) {
            if (columnRequired[i]) continue;
            pruneList.add(new Pair<Integer, Integer>(0, i));
        }
        StringBuffer message = new StringBuffer();
        if (pruneList.size() != 0) {
            if (forEach == null) {
                this.pruner.addPruneMap(load, pruneList);
            } else {
                this.pruner.addPruneMap(forEach, pruneList);
            }
            message.append("Columns pruned for " + load.getAlias() + ": ");
            for (int i = 0; i < pruneList.size(); ++i) {
                message.append("$" + ((Pair)pruneList.get((int)i)).second);
                if (i == pruneList.size() - 1) continue;
                message.append(", ");
            }
            log.info((Object)message);
        } else {
            log.info((Object)("No column pruned for " + load.getAlias()));
        }
        message = new StringBuffer();
        for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
            if (rf.getSubFields() == null) continue;
            message.append("Map key required for " + load.getAlias() + ": ");
            if (rf.getIndex() != -1) {
                message.append("$" + rf.getIndex());
            } else {
                message.append(rf.getAlias());
            }
            message.append("->[");
            for (int i = 0; i < rf.getSubFields().size(); ++i) {
                LoadPushDown.RequiredField keyrf = rf.getSubFields().get(i);
                message.append(keyrf);
                if (i == rf.getSubFields().size() - 1) continue;
                message.append(",");
            }
            message.append("] ");
        }
        if (message.length() != 0) {
            log.info((Object)message);
        } else {
            log.info((Object)("No map keys pruned for " + load.getAlias()));
        }
    }

    public void prune() throws OptimizerException {
        try {
            if (!this.safeToPrune) {
                return;
            }
            for (LOLoad load : this.prunedLoaderColumnsMap.keySet()) {
                this.pruneLoader(load, this.prunedLoaderColumnsMap.get(load));
            }
            if (!this.pruner.isEmpty()) {
                this.pruner.visit();
            }
        }
        catch (FrontendException e) {
            int errCode = 2212;
            String msg = "Unable to prune plan";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }
}

