/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGenerate;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOIsNull;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.UnaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckerException;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCheckingVisitor
extends LOVisitor {
    private static final int INF = -1;
    private static final Log log = LogFactory.getLog(TypeCheckingVisitor.class);
    private CompilationMessageCollector msgCollector = null;
    private boolean strictMode = false;
    private String currentAlias = null;
    public static final MultiMap<Byte, Byte> castLookup = new MultiMap();

    public TypeCheckingVisitor(LogicalPlan plan, CompilationMessageCollector messageCollector) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
        this.msgCollector = messageCollector;
    }

    @Override
    protected void visit(ExpressionOperator eOp) throws VisitorException {
        if (eOp instanceof BinaryExpressionOperator) {
            this.visit((BinaryExpressionOperator)eOp);
        } else if (eOp instanceof UnaryExpressionOperator) {
            this.visit((UnaryExpressionOperator)eOp);
        } else if (eOp instanceof LOConst) {
            this.visit((LOConst)eOp);
        } else if (eOp instanceof LOBinCond) {
            this.visit((LOBinCond)eOp);
        } else if (eOp instanceof LOCast) {
            this.visit((LOCast)eOp);
        } else if (eOp instanceof LORegexp) {
            this.visit((LORegexp)eOp);
        } else if (eOp instanceof LOUserFunc) {
            this.visit((LOUserFunc)eOp);
        } else if (eOp instanceof LOProject) {
            this.visit((LOProject)eOp);
        } else if (eOp instanceof LONegative) {
            this.visit((LONegative)eOp);
        } else if (eOp instanceof LONot) {
            this.visit((LONot)eOp);
        } else if (eOp instanceof LOMapLookup) {
            this.visit((LOMapLookup)eOp);
        }
    }

    @Override
    protected void visit(LogicalOperator lOp) throws VisitorException {
        if (lOp instanceof LOLoad) {
            this.visit((LOLoad)lOp);
        } else if (lOp instanceof LODistinct) {
            this.visit((LODistinct)lOp);
        } else if (lOp instanceof LOFilter) {
            this.visit((LOFilter)lOp);
        } else if (lOp instanceof LOUnion) {
            this.visit((LOUnion)lOp);
        } else if (lOp instanceof LOSplit) {
            this.visit((LOSplit)lOp);
        } else if (lOp instanceof LOSplitOutput) {
            this.visit((LOSplitOutput)lOp);
        } else if (lOp instanceof LOCogroup) {
            this.visit((LOCogroup)lOp);
        } else if (lOp instanceof LOSort) {
            this.visit((LOSort)lOp);
        } else if (lOp instanceof LOForEach) {
            this.visit((LOForEach)lOp);
        } else if (lOp instanceof LOGenerate) {
            this.visit((LOGenerate)lOp);
        } else if (lOp instanceof LOCross) {
            this.visit((LOCross)lOp);
        }
    }

    @Override
    protected void visit(LOProject pj) throws VisitorException {
        this.resolveLOProjectType(pj);
    }

    private void resolveLOProjectType(LOProject pj) throws VisitorException {
        try {
            pj.getFieldSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1035;
            String msg = "Error getting LOProject's input schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LOConst cs) throws VisitorException {
    }

    @Override
    public void visit(LOMapLookup map) throws VisitorException {
        if (!DataType.isAtomic(DataType.findType(map.getLookUpKey()))) {
            int errCode = 1036;
            String msg = "Map key should be a basic type";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        map.setType(map.getValueType());
        if (map.getMap().getType() != 100) {
            this.insertCast(map, (byte)100, null, map.getMap());
        }
    }

    @Override
    protected void visit(LORegexp rg) throws VisitorException {
        if (rg.getOperand().getType() == 50) {
            this.insertCastForRegexp(rg);
        }
        if (rg.getOperand().getType() != 55) {
            int errCode = 1037;
            String msg = "Operand of Regex can be CharArray only";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
    }

    private void insertCastForRegexp(LORegexp rg) throws VisitorException {
        this.insertCast(rg, (byte)55, null, rg.getOperand());
    }

    @Override
    public void visit(LOAnd binOp) throws VisitorException {
        this.insertCastsForNullToBoolean(binOp);
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (lhsType != 5 || rhsType != 5) {
            int errCode = 1038;
            String msg = "Operands of AND/OR can be boolean only";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
    }

    private void insertCastsForNullToBoolean(BinaryExpressionOperator binOp) throws VisitorException {
        if (binOp.getLhsOperand() instanceof LOConst && ((LOConst)binOp.getLhsOperand()).getValue() == null) {
            this.insertLeftCastForBinaryOp(binOp, (byte)5);
        }
        if (binOp.getRhsOperand() instanceof LOConst && ((LOConst)binOp.getRhsOperand()).getValue() == null) {
            this.insertRightCastForBinaryOp(binOp, (byte)5);
        }
    }

    @Override
    public void visit(LOOr binOp) throws VisitorException {
        this.insertCastsForNullToBoolean(binOp);
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (lhsType != 5 || rhsType != 5) {
            int errCode = 1038;
            String msg = "Operands of AND/OR can be boolean only";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
    }

    @Override
    public void visit(LOMultiply binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (lhsType == 50 && DataType.isNumberType(rhsType)) {
            this.insertLeftCastForBinaryOp(binOp, rhsType);
        } else if (rhsType == 50 && DataType.isNumberType(lhsType)) {
            this.insertRightCastForBinaryOp(binOp, lhsType);
        } else if (lhsType == 50 && rhsType == 50) {
            this.insertLeftCastForBinaryOp(binOp, (byte)25);
            this.insertRightCastForBinaryOp(binOp, (byte)25);
        } else {
            int errCode = 1039;
            String msg = this.generateIncompatibleTypesMessage(binOp, "Multiplication", lhsType, rhsType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        try {
            binOp.regenerateFieldSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1040;
            String msg = "Could not set Multiply field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    public void visit(LODivide binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (lhsType == 50 && DataType.isNumberType(rhsType)) {
            this.insertLeftCastForBinaryOp(binOp, rhsType);
        } else if (rhsType == 50 && DataType.isNumberType(lhsType)) {
            this.insertRightCastForBinaryOp(binOp, lhsType);
        } else if (lhsType == 50 && rhsType == 50) {
            this.insertLeftCastForBinaryOp(binOp, (byte)25);
            this.insertRightCastForBinaryOp(binOp, (byte)25);
        } else {
            int errCode = 1039;
            String msg = this.generateIncompatibleTypesMessage(binOp, "Division", lhsType, rhsType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        try {
            binOp.regenerateFieldSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1040;
            String msg = "Could not set Divide field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    public void visit(LOAdd binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (lhsType == 50 && DataType.isNumberType(rhsType)) {
            this.insertLeftCastForBinaryOp(binOp, rhsType);
        } else if (rhsType == 50 && DataType.isNumberType(lhsType)) {
            this.insertRightCastForBinaryOp(binOp, lhsType);
        } else if (lhsType == 50 && rhsType == 50) {
            this.insertLeftCastForBinaryOp(binOp, (byte)25);
            this.insertRightCastForBinaryOp(binOp, (byte)25);
        } else {
            int errCode = 1039;
            String msg = this.generateIncompatibleTypesMessage(binOp, "Add", lhsType, rhsType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        try {
            binOp.regenerateFieldSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1040;
            String msg = "Could not set Add field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    public void visit(LOSubtract binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (lhsType == 50 && DataType.isNumberType(rhsType)) {
            this.insertLeftCastForBinaryOp(binOp, rhsType);
        } else if (rhsType == 50 && DataType.isNumberType(lhsType)) {
            this.insertRightCastForBinaryOp(binOp, lhsType);
        } else if (lhsType == 50 && rhsType == 50) {
            this.insertLeftCastForBinaryOp(binOp, (byte)25);
            this.insertRightCastForBinaryOp(binOp, (byte)25);
        } else {
            int errCode = 1039;
            String msg = this.generateIncompatibleTypesMessage(binOp, "Subtract", lhsType, rhsType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        try {
            binOp.regenerateFieldSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1040;
            String msg = "Could not set Subtract field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    public void visit(LOGreaterThan binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (!(lhsType == 55 && rhsType == 55 || lhsType == 50 && rhsType == 50)) {
            if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType))) {
                this.insertLeftCastForBinaryOp(binOp, rhsType);
            } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType))) {
                this.insertRightCastForBinaryOp(binOp, lhsType);
            } else {
                int errCode = 1039;
                String msg = this.generateIncompatibleTypesMessage(binOp, "GreaterThan", lhsType, rhsType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
    }

    @Override
    public void visit(LOGreaterThanEqual binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (!(lhsType == 55 && rhsType == 55 || lhsType == 50 && rhsType == 50)) {
            if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType))) {
                this.insertLeftCastForBinaryOp(binOp, rhsType);
            } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType))) {
                this.insertRightCastForBinaryOp(binOp, lhsType);
            } else {
                int errCode = 1039;
                String msg = this.generateIncompatibleTypesMessage(binOp, "GreaterThanEqualTo", lhsType, rhsType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
    }

    @Override
    public void visit(LOLesserThan binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (!(lhsType == 55 && rhsType == 55 || lhsType == 50 && rhsType == 50)) {
            if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType))) {
                this.insertLeftCastForBinaryOp(binOp, rhsType);
            } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType))) {
                this.insertRightCastForBinaryOp(binOp, lhsType);
            } else {
                int errCode = 1039;
                String msg = this.generateIncompatibleTypesMessage(binOp, "LesserThan", lhsType, rhsType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
    }

    @Override
    public void visit(LOLesserThanEqual binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (!(lhsType == 55 && rhsType == 55 || lhsType == 50 && rhsType == 50)) {
            if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType))) {
                this.insertLeftCastForBinaryOp(binOp, rhsType);
            } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType))) {
                this.insertRightCastForBinaryOp(binOp, lhsType);
            } else {
                int errCode = 1039;
                String msg = this.generateIncompatibleTypesMessage(binOp, "LesserThanEqualTo", lhsType, rhsType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
    }

    @Override
    public void visit(LOEqual binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (!(lhsType == 55 && rhsType == 55 || lhsType == 50 && rhsType == 50)) {
            if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType))) {
                this.insertLeftCastForBinaryOp(binOp, rhsType);
            } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType))) {
                this.insertRightCastForBinaryOp(binOp, lhsType);
            } else if (!(lhsType == 110 && rhsType == 110 || lhsType == 100 && rhsType == 100)) {
                if (binOp.getLhsOperand() instanceof LOConst && ((LOConst)binOp.getLhsOperand()).getValue() == null) {
                    this.insertLeftCastForBinaryOp(binOp, rhsType);
                } else if (binOp.getRhsOperand() instanceof LOConst && ((LOConst)binOp.getRhsOperand()).getValue() == null) {
                    this.insertRightCastForBinaryOp(binOp, lhsType);
                } else {
                    int errCode = 1039;
                    String msg = this.generateIncompatibleTypesMessage(binOp, "EqualTo", lhsType, rhsType);
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException(msg, errCode, 2);
                }
            }
        }
    }

    @Override
    public void visit(LONotEqual binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertLeftCastForBinaryOp(binOp, biggerType);
            } else if (rhsType != biggerType) {
                this.insertRightCastForBinaryOp(binOp, biggerType);
            }
        } else if (!(lhsType == 55 && rhsType == 55 || lhsType == 50 && rhsType == 50)) {
            if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType))) {
                this.insertLeftCastForBinaryOp(binOp, rhsType);
            } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType))) {
                this.insertRightCastForBinaryOp(binOp, lhsType);
            } else if (!(lhsType == 110 && rhsType == 110 || lhsType == 100 && rhsType == 100)) {
                if (binOp.getLhsOperand() instanceof LOConst && ((LOConst)binOp.getLhsOperand()).getValue() == null) {
                    this.insertLeftCastForBinaryOp(binOp, rhsType);
                } else if (binOp.getRhsOperand() instanceof LOConst && ((LOConst)binOp.getRhsOperand()).getValue() == null) {
                    this.insertRightCastForBinaryOp(binOp, lhsType);
                } else {
                    int errCode = 1039;
                    String msg = this.generateIncompatibleTypesMessage(binOp, "NotEqual", lhsType, rhsType);
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException(msg, errCode, 2);
                }
            }
        }
    }

    @Override
    public void visit(LOMod binOp) throws VisitorException {
        ExpressionOperator lhs = binOp.getLhsOperand();
        ExpressionOperator rhs = binOp.getRhsOperand();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (lhsType != 10 || rhsType != 10) {
            if (lhsType == 15 && (rhsType == 10 || rhsType == 15)) {
                if (rhsType == 10) {
                    this.insertRightCastForBinaryOp(binOp, (byte)15);
                }
            } else if (rhsType == 15 && (lhsType == 10 || lhsType == 15)) {
                if (lhsType == 10) {
                    this.insertLeftCastForBinaryOp(binOp, (byte)15);
                }
            } else if (lhsType == 50 && (rhsType == 10 || rhsType == 15)) {
                this.insertLeftCastForBinaryOp(binOp, rhsType);
            } else {
                int errCode = 1039;
                String msg = this.generateIncompatibleTypesMessage(binOp, "Mod", lhsType, rhsType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
        try {
            binOp.regenerateFieldSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1040;
            String msg = "Could not set Mod field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    public void visit(LONegative uniOp) throws VisitorException {
        byte type = uniOp.getOperand().getType();
        if (!DataType.isNumberType(type)) {
            if (type == 50) {
                this.insertCastForUniOp(uniOp, (byte)25);
            } else {
                int errCode = 1041;
                String msg = "NEG can be used with numbers or Bytearray only";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
        try {
            uniOp.regenerateFieldSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1040;
            String msg = "Could not set Negative field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    public void visit(LONot uniOp) throws VisitorException {
        byte type;
        if (uniOp.getOperand() instanceof LOConst && ((LOConst)uniOp.getOperand()).getValue() == null) {
            this.insertCastForUniOp(uniOp, (byte)5);
        }
        if ((type = uniOp.getOperand().getType()) != 5) {
            int errCode = 1042;
            String msg = "NOT can be used with boolean only";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
    }

    @Override
    public void visit(LOIsNull uniOp) throws VisitorException {
    }

    private void insertLeftCastForBinaryOp(BinaryExpressionOperator binOp, byte toType) throws VisitorException {
        this.insertCast(binOp, toType, null, binOp.getLhsOperand());
    }

    private void insertRightCastForBinaryOp(BinaryExpressionOperator binOp, byte toType) throws VisitorException {
        this.insertCast(binOp, toType, null, binOp.getRhsOperand());
    }

    private void insertCast(ExpressionOperator node, byte toType, Schema.FieldSchema toFs, ExpressionOperator predecessor) throws VisitorException {
        LogicalPlan currentPlan = (LogicalPlan)this.mCurrentWalker.getPlan();
        this.collectCastWarning(node, predecessor.getType(), toType);
        OperatorKey newKey = this.genNewOperatorKey(node);
        LOCast cast = new LOCast(currentPlan, newKey, toType);
        try {
            if (toFs != null) {
                cast.setFieldSchema(toFs);
            }
        }
        catch (FrontendException e) {
            int errCode = 2217;
            String msg = "Problem setFieldSchema for " + node + " ";
            throw new TypeCheckerException(msg, errCode, 4, e);
        }
        currentPlan.add(cast);
        try {
            currentPlan.insertBetween(predecessor, cast, node);
        }
        catch (PlanException pe) {
            int errCode = 2059;
            String msg = "Problem with inserting cast operator for " + node + " in plan.";
            throw new TypeCheckerException(msg, errCode, 4, pe);
        }
        this.visit(cast);
    }

    private void insertCastForUDF(LOUserFunc udf, Schema.FieldSchema fromFS, Schema.FieldSchema toFs, ExpressionOperator predecessor) throws VisitorException {
        toFs.setParent(fromFS.canonicalName, predecessor);
        this.insertCast(udf, fromFS.type, toFs, predecessor);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void visit(UnaryExpressionOperator uniOp) throws VisitorException {
        byte type = uniOp.getOperand().getType();
        if (uniOp instanceof LONegative) {
            if (DataType.isNumberType(type)) {
                uniOp.setType(type);
                return;
            }
            if (type == 50) {
                this.insertCastForUniOp(uniOp, (byte)25);
                uniOp.setType((byte)25);
                return;
            }
            int errCode = 1041;
            String msg = "NEG can be used with numbers or Bytearray only";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        if (!(uniOp instanceof LONot)) {
            int errCode = 1079;
            String msg = "Undefined type checking logic for unary operator: " + uniOp.getClass().getSimpleName();
            throw new TypeCheckerException(msg, errCode, 2);
        }
        if (type == 5) {
            uniOp.setType((byte)5);
            return;
        }
        int errCode = 1042;
        String msg = "NOT can be used with boolean only";
        this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
        throw new TypeCheckerException(msg, errCode, 2);
    }

    private void insertCastForUniOp(UnaryExpressionOperator uniOp, byte toType) throws VisitorException {
        this.insertCast(uniOp, toType, null, uniOp.getOperand());
    }

    @Override
    protected void visit(LOUserFunc func) throws VisitorException {
        List<ExpressionOperator> list = func.getArguments();
        Schema s = new Schema();
        for (ExpressionOperator op : list) {
            if (!DataType.isUsableType(op.getType())) {
                int errCode = 1014;
                String msg = "Problem with input " + op + " of User-defined function: " + func;
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
            try {
                s.add(op.getFieldSchema());
            }
            catch (FrontendException e) {
                int errCode = 1043;
                String msg = "Unable to retrieve field schema.";
                throw new TypeCheckerException(msg, errCode, 2, e);
            }
        }
        EvalFunc ef = (EvalFunc)PigContext.instantiateFuncFromSpec(func.getFuncSpec());
        List<FuncSpec> funcSpecs = null;
        try {
            funcSpecs = ef.getArgToFuncMapping();
        }
        catch (Exception e) {
            int errCode = 1044;
            String msg = "Unable to get list of overloaded methods.";
            throw new TypeCheckerException(msg, errCode, 2, e);
        }
        FuncSpec matchingSpec = null;
        boolean notExactMatch = false;
        if (funcSpecs != null && funcSpecs.size() != 0 && (matchingSpec = this.exactMatch(funcSpecs, s, func)) == null) {
            notExactMatch = true;
            if (this.byteArrayFound(s)) {
                matchingSpec = this.exactMatchWithByteArrays(funcSpecs, s, func);
                if (matchingSpec == null && (matchingSpec = this.bestFitMatchWithByteArrays(funcSpecs, s, func)) == null) {
                    int errCode = 1045;
                    String msg = "Could not infer the matching function for " + func.getFuncSpec() + " as multiple or none of them fit. Please use an explicit cast.";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException(msg, errCode, 2);
                }
            } else {
                matchingSpec = this.bestFitMatch(funcSpecs, s);
                if (matchingSpec == null) {
                    int errCode = 1045;
                    String msg = "Could not infer the matching function for " + func.getFuncSpec() + " as multiple or none of them fit. Please use an explicit cast.";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException(msg, errCode, 2);
                }
            }
        }
        if (matchingSpec != null) {
            if (notExactMatch) {
                String msg = "Function " + func.getFuncSpec().getClassName() + "()" + " will be called with following argument types: " + matchingSpec.getInputArgsSchema() + ". If you want to use " + "different input argument types, please use explicit casts.";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Warning, PigWarning.USING_OVERLOADED_FUNCTION);
            }
            matchingSpec.setCtorArgs(func.getFuncSpec().getCtorArgs());
            func.setFuncSpec(matchingSpec);
            this.insertCastsForUDF(func, s, matchingSpec.getInputArgsSchema());
        }
        try {
            func.regenerateFieldSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1040;
            String msg = "Could not set UserFunc field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fee);
        }
    }

    private FuncSpec exactMatchWithByteArrays(List<FuncSpec> funcSpecs, Schema s, LOUserFunc func) throws VisitorException {
        return this.exactMatchHelper(funcSpecs, s, func, true);
    }

    private FuncSpec exactMatch(List<FuncSpec> funcSpecs, Schema s, LOUserFunc func) throws VisitorException {
        return this.exactMatchHelper(funcSpecs, s, func, false);
    }

    private FuncSpec bestFitMatch(List<FuncSpec> funcSpecs, Schema s) {
        FuncSpec matchingSpec = null;
        long score = -1L;
        long prevBestScore = Long.MAX_VALUE;
        long bestScore = Long.MAX_VALUE;
        for (FuncSpec fs : funcSpecs) {
            score = this.fitPossible(s, fs.getInputArgsSchema());
            if (score == -1L || score > bestScore) continue;
            matchingSpec = fs;
            prevBestScore = bestScore;
            bestScore = score;
        }
        if (matchingSpec != null && bestScore != prevBestScore) {
            return matchingSpec;
        }
        return null;
    }

    private FuncSpec bestFitMatchWithByteArrays(List<FuncSpec> funcSpecs, Schema s, LOUserFunc func) throws VisitorException {
        ArrayList<Pair<Long, FuncSpec>> scoreFuncSpecList = new ArrayList<Pair<Long, FuncSpec>>();
        for (FuncSpec fs : funcSpecs) {
            long score = this.fitPossible(s, fs.getInputArgsSchema());
            if (score == -1L) continue;
            scoreFuncSpecList.add(new Pair<Long, FuncSpec>(score, fs));
        }
        if (scoreFuncSpecList.size() == 0) {
            return null;
        }
        if (scoreFuncSpecList.size() > 1) {
            Collections.sort(scoreFuncSpecList, new ScoreFuncSpecListComparator());
            if (((Pair)scoreFuncSpecList.get((int)0)).first == ((Pair)scoreFuncSpecList.get((int)1)).first) {
                int errCode = 1046;
                String msg = "Multiple matching functions for " + func.getFuncSpec() + " with input schemas: " + "(" + ((FuncSpec)((Pair)scoreFuncSpecList.get((int)0)).second).getInputArgsSchema() + ", " + ((FuncSpec)((Pair)scoreFuncSpecList.get((int)1)).second).getInputArgsSchema() + "). Please use an explicit cast.";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
            List<Integer> byteArrayPositions = this.getByteArrayPositions(s);
            HashMap<Integer, Pair<FuncSpec, Byte>> castToMap = new HashMap<Integer, Pair<FuncSpec, Byte>>();
            Iterator it = scoreFuncSpecList.iterator();
            while (it.hasNext()) {
                FuncSpec funcSpec = (FuncSpec)((Pair)it.next()).second;
                Schema sch = funcSpec.getInputArgsSchema();
                for (Integer i : byteArrayPositions) {
                    try {
                        if (!castToMap.containsKey(i)) {
                            castToMap.put(i, new Pair<FuncSpec, Byte>(funcSpec, sch.getField((int)i.intValue()).type));
                            continue;
                        }
                        Pair existingPair = (Pair)castToMap.get(i);
                        if (sch.getField((int)i.intValue()).type == (Byte)existingPair.second) continue;
                        int errCode = 1046;
                        String msg = "Multiple matching functions for " + func.getFuncSpec() + " with input schema: " + "(" + ((FuncSpec)existingPair.first).getInputArgsSchema() + ", " + funcSpec.getInputArgsSchema() + "). Please use an explicit cast.";
                        this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                        throw new TypeCheckerException(msg, errCode, 2);
                    }
                    catch (FrontendException fee) {
                        int errCode = 1043;
                        String msg = "Unalbe to retrieve field schema.";
                        throw new TypeCheckerException(msg, errCode, 2, fee);
                    }
                }
            }
        }
        return (FuncSpec)((Pair)scoreFuncSpecList.get((int)0)).second;
    }

    private boolean byteArrayFound(Schema s) throws VisitorException {
        for (int i = 0; i < s.size(); ++i) {
            try {
                Schema.FieldSchema fs = s.getField(i);
                if (fs.type != 50) continue;
                return true;
            }
            catch (FrontendException fee) {
                int errCode = 1043;
                String msg = "Unable to retrieve field schema.";
                throw new TypeCheckerException(msg, errCode, 2, fee);
            }
        }
        return false;
    }

    private List<Integer> getByteArrayPositions(Schema s) throws VisitorException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < s.size(); ++i) {
            try {
                Schema.FieldSchema fs = s.getField(i);
                if (fs.type != 50) continue;
                result.add(i);
                continue;
            }
            catch (FrontendException fee) {
                int errCode = 1043;
                String msg = "Unable to retrieve field schema.";
                throw new TypeCheckerException(msg, errCode, 2, fee);
            }
        }
        return result;
    }

    private FuncSpec exactMatchHelper(List<FuncSpec> funcSpecs, Schema s, LOUserFunc func, boolean ignoreByteArrays) throws VisitorException {
        ArrayList<FuncSpec> matchingSpecs = new ArrayList<FuncSpec>();
        for (FuncSpec fs : funcSpecs) {
            if (!TypeCheckingVisitor.schemaEqualsForMatching(s, fs.getInputArgsSchema(), ignoreByteArrays)) continue;
            matchingSpecs.add(fs);
        }
        if (matchingSpecs.size() == 0) {
            return null;
        }
        if (matchingSpecs.size() > 1) {
            int errCode = 1046;
            String msg = "Multiple matching functions for " + func.getFuncSpec() + " with input schema: " + "(" + ((FuncSpec)matchingSpecs.get(0)).getInputArgsSchema() + ", " + ((FuncSpec)matchingSpecs.get(1)).getInputArgsSchema() + "). Please use an explicit cast.";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        return (FuncSpec)matchingSpecs.get(0);
    }

    public static boolean schemaEqualsForMatching(Schema inputSchema, Schema udfSchema, boolean ignoreByteArrays) {
        if (inputSchema == null && udfSchema == null) {
            return true;
        }
        if (inputSchema == null) {
            return false;
        }
        if (udfSchema == null) {
            return false;
        }
        if (inputSchema.size() != udfSchema.size()) {
            return false;
        }
        Iterator<Schema.FieldSchema> i = inputSchema.getFields().iterator();
        Iterator<Schema.FieldSchema> j = udfSchema.getFields().iterator();
        while (i.hasNext()) {
            Schema.FieldSchema inputFieldSchema = i.next();
            Schema.FieldSchema udfFieldSchema = j.next();
            if (ignoreByteArrays && inputFieldSchema.type == 50) continue;
            if (inputFieldSchema.type != udfFieldSchema.type) {
                return false;
            }
            if (!DataType.isSchemaType(udfFieldSchema.type) || udfFieldSchema.schema == null || Schema.FieldSchema.equals(inputFieldSchema, udfFieldSchema, false, true)) continue;
            return false;
        }
        return true;
    }

    private long fitPossible(Schema s1, Schema s2) {
        if (s1 == null || s2 == null) {
            return -1L;
        }
        List<Schema.FieldSchema> sFields = s1.getFields();
        List<Schema.FieldSchema> fsFields = s2.getFields();
        if (sFields.size() != fsFields.size()) {
            return -1L;
        }
        long score = 0L;
        int castCnt = 0;
        for (int i = 0; i < sFields.size(); ++i) {
            Schema.FieldSchema sFS = sFields.get(i);
            if (sFS.type == 50) continue;
            Schema.FieldSchema fsFS = fsFields.get(i);
            if (DataType.isSchemaType(sFS.type) && !Schema.FieldSchema.equals(sFS, fsFS, false, true)) {
                return -1L;
            }
            if (Schema.FieldSchema.equals(sFS, fsFS, true, true)) continue;
            if (!castLookup.containsKey(sFS.type)) {
                return -1L;
            }
            if (!castLookup.get(sFS.type).contains(fsFS.type)) {
                return -1L;
            }
            score += (long)(((List)castLookup.get(sFS.type)).indexOf(fsFS.type) + 1);
            ++castCnt;
        }
        return score * (long)castCnt;
    }

    private void insertCastsForUDF(LOUserFunc udf, Schema fromSch, Schema toSch) throws VisitorException {
        List<Schema.FieldSchema> fsLst = fromSch.getFields();
        List<Schema.FieldSchema> tsLst = toSch.getFields();
        List<ExpressionOperator> args = udf.getArguments();
        int i = -1;
        for (Schema.FieldSchema fFSch : fsLst) {
            Schema.FieldSchema tFSch = tsLst.get(++i);
            if (fFSch.type == tFSch.type) continue;
            this.insertCastForUDF(udf, fFSch, tFSch, args.get(i));
        }
    }

    @Override
    protected void visit(LOBinCond binCond) throws VisitorException {
        if (binCond.getCond().getType() != 5) {
            int errCode = 1047;
            String msg = "Condition in BinCond must be boolean";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        byte lhsType = binCond.getLhsOp().getType();
        byte rhsType = binCond.getRhsOp().getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (biggerType > lhsType) {
                this.insertLeftCastForBinCond(binCond, biggerType, null);
            } else if (biggerType > rhsType) {
                this.insertRightCastForBinCond(binCond, biggerType, null);
            }
            binCond.setType(biggerType);
        } else if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType))) {
            this.insertLeftCastForBinCond(binCond, rhsType, null);
            binCond.setType(DataType.mergeType(lhsType, rhsType));
        } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType))) {
            this.insertRightCastForBinCond(binCond, lhsType, null);
            binCond.setType(DataType.mergeType(lhsType, rhsType));
        } else {
            if (binCond.getLhsOp() instanceof LOConst && ((LOConst)binCond.getLhsOp()).getValue() == null) {
                try {
                    this.insertLeftCastForBinCond(binCond, rhsType, binCond.getRhsOp().getFieldSchema());
                }
                catch (FrontendException e) {
                    int errCode = 2216;
                    String msg = "Problem getting fieldSchema for " + binCond.getRhsOp();
                    throw new TypeCheckerException(msg, errCode, 4, e);
                }
            }
            if (binCond.getRhsOp() instanceof LOConst && ((LOConst)binCond.getRhsOp()).getValue() == null) {
                try {
                    this.insertRightCastForBinCond(binCond, lhsType, binCond.getLhsOp().getFieldSchema());
                }
                catch (FrontendException e) {
                    int errCode = 2216;
                    String msg = "Problem getting fieldSchema for " + binCond.getRhsOp();
                    throw new TypeCheckerException(msg, errCode, 4, e);
                }
            }
            if (lhsType == rhsType) {
                if (DataType.isSchemaType(lhsType)) {
                    try {
                        if (!Schema.FieldSchema.equals(binCond.getLhsOp().getFieldSchema(), binCond.getRhsOp().getFieldSchema(), false, true)) {
                            int errCode = 1048;
                            String msg = "Two inputs of BinCond must have compatible schemas. left hand side: " + binCond.getLhsOp().getFieldSchema() + " right hand side: " + binCond.getRhsOp().getFieldSchema();
                            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                            throw new TypeCheckerException(msg, errCode, 2);
                        }
                    }
                    catch (FrontendException fe) {
                        int errCode = 1049;
                        String msg = "Problem during evaluaton of BinCond output type";
                        this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                        throw new TypeCheckerException(msg, errCode, 2, fe);
                    }
                    binCond.setType((byte)110);
                }
                binCond.setType(lhsType);
            } else {
                int errCode = 1050;
                String msg = "Unsupported input type for BinCond: left hand side: " + DataType.findTypeName(lhsType) + "; right hand side: " + DataType.findTypeName(rhsType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
        try {
            binCond.regenerateFieldSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1040;
            String msg = "Could not set BinCond field schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fee);
        }
    }

    private void insertLeftCastForBinCond(LOBinCond binCond, byte toType, Schema.FieldSchema toFs) throws VisitorException {
        this.insertCast(binCond, toType, toFs, binCond.getLhsOp());
    }

    private void insertRightCastForBinCond(LOBinCond binCond, byte toType, Schema.FieldSchema toFs) throws VisitorException {
        this.insertCast(binCond, toType, toFs, binCond.getRhsOp());
    }

    @Override
    protected void visit(LOCast cast) throws VisitorException {
        Schema.FieldSchema inputFs;
        Schema.FieldSchema castFs;
        byte inputType = cast.getExpression().getType();
        byte expectedType = cast.getType();
        if (expectedType == 50) {
            int errCode = 1051;
            String msg = "Cannot cast to bytearray";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        try {
            castFs = cast.getFieldSchema();
            inputFs = cast.getExpression().getFieldSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1076;
            String msg = "Problem while reading field schema of cast operator.";
            throw new TypeCheckerException(msg, errCode, 4, fee);
        }
        boolean castable = Schema.FieldSchema.castable(castFs, inputFs);
        if (!castable) {
            int errCode = 1052;
            String msg = "Cannot cast " + DataType.findTypeName(inputType) + (DataType.isSchemaType(inputType) ? " with schema " + inputFs : "") + " to " + DataType.findTypeName(expectedType) + (DataType.isSchemaType(expectedType) ? " with schema " + castFs : "");
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        if (inputType == 50 || cast.getExpression() instanceof LOUserFunc && ((LOUserFunc)cast.getExpression()).getImplicitReferencedOperator() != null) {
            try {
                Map<String, LogicalOperator> canonicalMap = cast.getFieldSchema().getCanonicalMap();
                FuncSpec prevLoadFuncSpec = null;
                boolean prevLoadFuncSet = false;
                for (Map.Entry<String, LogicalOperator> entry : canonicalMap.entrySet()) {
                    FuncSpec loadFuncSpec = this.getLoadFuncSpec(entry.getValue(), entry.getKey());
                    if (!prevLoadFuncSet) {
                        prevLoadFuncSet = true;
                        prevLoadFuncSpec = loadFuncSpec;
                    }
                    if (loadFuncSpec == null) {
                        if (prevLoadFuncSpec == null) continue;
                        String msg = "Bug: A null and a non-null load function  mapped to cast through lineage";
                        throw new VisitorException(msg, 2258, 4);
                    }
                    if (!loadFuncSpec.equals(prevLoadFuncSpec)) {
                        String msg = "Bug:Two different load functions mapped to an LOCast op";
                        throw new VisitorException(msg, 2258, 4);
                    }
                    cast.setLoadFuncSpec(loadFuncSpec);
                }
            }
            catch (FrontendException fee) {
                int errCode = 1053;
                String msg = "Cannot resolve load function to use for casting from " + DataType.findTypeName(inputType) + " to " + DataType.findTypeName(expectedType) + ". ";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2, fee);
            }
        }
    }

    @Override
    protected void visit(LOUnion u) throws VisitorException {
        u.unsetSchema();
        ArrayList<LogicalOperator> inputs = new ArrayList<LogicalOperator>(u.getInputs());
        if (inputs.size() < 2) {
            throw new AssertionError((Object)"Union with Count(Operand) < 2");
        }
        Schema schema = null;
        try {
            if (this.strictMode) {
                Schema tmpSchema = ((LogicalOperator)inputs.get(0)).getSchema();
                for (int i = 1; i < inputs.size(); ++i) {
                    if ((tmpSchema = tmpSchema.merge(((LogicalOperator)inputs.get(i)).getSchema(), false)) != null) continue;
                    int errCode = 1054;
                    String msg = "Cannot merge schemas from inputs of UNION";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException(msg, errCode, 2);
                }
            }
            schema = u.getSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of Union";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fee);
        }
        if (schema != null && !u.isOnSchema()) {
            for (int i = 0; i < inputs.size(); ++i) {
                LOForEach insertedOp = this.insertCastForEachInBetweenIfNecessary((LogicalOperator)inputs.get(i), u, schema);
                if (insertedOp == null) continue;
                if (insertedOp.getAlias() == null) {
                    insertedOp.setAlias(((LogicalOperator)inputs.get(i)).getAlias());
                }
                try {
                    this.visit(insertedOp);
                    continue;
                }
                catch (FrontendException fee) {
                    int errCode = 1056;
                    String msg = "Problem while casting inputs of Union";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException(msg, errCode, 2, fee);
                }
            }
        }
    }

    @Override
    protected void visit(LOSplitOutput op) throws VisitorException {
        op.unsetSchema();
        LogicalPlan currentPlan = (LogicalPlan)this.mCurrentWalker.getPlan();
        List<LOSplitOutput> list = currentPlan.getPredecessors(op);
        if (list.size() != 1) {
            int errCode = 2008;
            String msg = "LOSplitOutput cannot have more than one input. Found: " + list.size() + " input(s).";
            throw new TypeCheckerException(msg, errCode, 4);
        }
        LogicalPlan condPlan = op.getConditionPlan();
        if (!condPlan.isSingleLeafPlan()) {
            int errCode = 1057;
            String msg = "Split's inner plan can only have one output (leaf)";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        this.checkInnerPlan(op.getAlias(), condPlan);
        byte innerCondType = ((LogicalOperator)condPlan.getLeaves().get(0)).getType();
        if (innerCondType != 5) {
            int errCode = 1058;
            String msg = "Split's condition must evaluate to boolean. Found: " + DataType.findTypeName(innerCondType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        try {
            op.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of SplitOutput";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LODistinct op) throws VisitorException {
        op.unsetSchema();
        try {
            op.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of Distinct";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LOLimit op) throws VisitorException {
        try {
            op.regenerateSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of Limit";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LOCross cs) throws VisitorException {
        cs.unsetSchema();
        try {
            cs.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schemas from inputs of Cross";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
        s.unsetSchema();
        LogicalOperator input = s.getInput();
        for (int i = 0; i < s.getSortColPlans().size(); ++i) {
            LogicalPlan sortColPlan = s.getSortColPlans().get(i);
            if (!sortColPlan.isSingleLeafPlan()) {
                int errCode = 1057;
                String msg = "Sort's inner plan can only have one output (leaf)";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
            this.checkInnerPlan(s.getAlias(), sortColPlan);
        }
        s.setType(input.getType());
        try {
            s.getSchema();
        }
        catch (FrontendException fee) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of Sort";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fee);
        }
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
        filter.unsetSchema();
        LogicalPlan comparisonPlan = filter.getComparisonPlan();
        if (!comparisonPlan.isSingleLeafPlan()) {
            int errCode = 1057;
            String msg = "Filter's cond plan can only have one output (leaf)";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        this.checkInnerPlan(filter.getAlias(), comparisonPlan);
        byte innerCondType = ((LogicalOperator)comparisonPlan.getLeaves().get(0)).getType();
        if (innerCondType != 5) {
            int errCode = 1058;
            String msg = "Filter's condition must evaluate to boolean. Found: " + DataType.findTypeName(innerCondType);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        try {
            filter.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of Filter";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LOSplit split) throws VisitorException {
        List<LOSplit> inputList = ((LogicalPlan)this.mPlan).getPredecessors(split);
        if (inputList.size() != 1) {
            int errCode = 2008;
            String msg = "LOSplit cannot have more than one input. Found: " + inputList.size() + " input(s).";
            throw new TypeCheckerException(msg, errCode, 4);
        }
        try {
            split.regenerateSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1059;
            String msg = "Problem while reconciling output schema of Split";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LOJoin join) throws VisitorException {
        String msg;
        block16: {
            try {
                join.regenerateSchema();
            }
            catch (FrontendException fe) {
                int errCode = 1060;
                String msg2 = "Cannot resolve Join output schema";
                this.msgCollector.collect(msg2, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg2, errCode, 2, fe);
            }
            MultiMap<LogicalOperator, LogicalPlan> joinColPlans = join.getJoinPlans();
            List<LogicalOperator> inputs = join.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                LogicalOperator input = inputs.get(i);
                ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(joinColPlans.get(input));
                for (int j = 0; j < innerPlans.size(); ++j) {
                    LogicalPlan innerPlan = (LogicalPlan)innerPlans.get(j);
                    if (!innerPlan.isSingleLeafPlan()) {
                        int errCode = 1057;
                        String msg3 = "Join's inner plans can only have one output (leaf)";
                        this.msgCollector.collect(msg3, CompilationMessageCollector.MessageType.Error);
                        throw new TypeCheckerException(msg3, errCode, 2);
                    }
                    this.checkInnerPlan(join.getAlias(), (LogicalPlan)innerPlans.get(j));
                }
            }
            try {
                LogicalOperator input;
                int i;
                if (!join.isTupleJoinCol()) {
                    byte groupType = join.getAtomicJoinColType();
                    for (i = 0; i < inputs.size(); ++i) {
                        input = inputs.get(i);
                        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(joinColPlans.get(input));
                        byte innerType = ((LogicalPlan)innerPlans.get(0)).getSingleLeafPlanOutputType();
                        if (innerType == groupType) continue;
                        this.insertAtomicCastForJoinInnerPlan((LogicalPlan)innerPlans.get(0), join, groupType);
                    }
                    break block16;
                }
                Schema groupBySchema = join.getTupleJoinSchema();
                for (i = 0; i < inputs.size(); ++i) {
                    input = inputs.get(i);
                    ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(joinColPlans.get(input));
                    for (int j = 0; j < innerPlans.size(); ++j) {
                        LogicalPlan innerPlan = (LogicalPlan)innerPlans.get(j);
                        byte innerType = innerPlan.getSingleLeafPlanOutputType();
                        byte expectedType = 50;
                        if (!DataType.isAtomic(innerType) && 110 != innerType) {
                            int errCode = 1057;
                            String msg4 = "Join's inner plans can onlyhave one output (leaf)";
                            this.msgCollector.collect(msg4, CompilationMessageCollector.MessageType.Error);
                            throw new TypeCheckerException(msg4, errCode, 2);
                        }
                        try {
                            expectedType = groupBySchema.getField((int)j).type;
                        }
                        catch (FrontendException fee) {
                            int errCode = 1060;
                            String msg5 = "Cannot resolve Join output schema";
                            this.msgCollector.collect(msg5, CompilationMessageCollector.MessageType.Error);
                            throw new TypeCheckerException(msg5, errCode, 2, fee);
                        }
                        if (innerType == expectedType) continue;
                        this.insertAtomicCastForJoinInnerPlan(innerPlan, join, expectedType);
                    }
                }
            }
            catch (FrontendException fe) {
                int errCode = 1060;
                msg = "Cannot resolve Join output schema";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2, fe);
            }
        }
        try {
            Schema outputSchema = join.regenerateSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1060;
            msg = "Cannot resolve Join output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
        String msg;
        block16: {
            try {
                cg.regenerateSchema();
            }
            catch (FrontendException fe) {
                int errCode = 1060;
                String msg2 = "Cannot resolve COGroup output schema";
                this.msgCollector.collect(msg2, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg2, errCode, 2, fe);
            }
            MultiMap<LogicalOperator, LogicalPlan> groupByPlans = cg.getGroupByPlans();
            List<LogicalOperator> inputs = cg.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                LogicalOperator input = inputs.get(i);
                ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(groupByPlans.get(input));
                for (int j = 0; j < innerPlans.size(); ++j) {
                    LogicalPlan innerPlan = (LogicalPlan)innerPlans.get(j);
                    if (!innerPlan.isSingleLeafPlan()) {
                        int errCode = 1057;
                        String msg3 = "COGroup's inner plans can onlyhave one output (leaf)";
                        this.msgCollector.collect(msg3, CompilationMessageCollector.MessageType.Error);
                        throw new TypeCheckerException(msg3, errCode, 2);
                    }
                    this.checkInnerPlan(cg.getAlias(), (LogicalPlan)innerPlans.get(j));
                }
            }
            try {
                LogicalOperator input;
                int i;
                if (!cg.isTupleGroupCol()) {
                    byte groupType = cg.getAtomicGroupByType();
                    for (i = 0; i < inputs.size(); ++i) {
                        input = inputs.get(i);
                        ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(groupByPlans.get(input));
                        byte innerType = ((LogicalPlan)innerPlans.get(0)).getSingleLeafPlanOutputType();
                        if (innerType == groupType) continue;
                        this.insertAtomicCastForCOGroupInnerPlan((LogicalPlan)innerPlans.get(0), cg, groupType);
                    }
                    break block16;
                }
                Schema groupBySchema = cg.getTupleGroupBySchema();
                for (i = 0; i < inputs.size(); ++i) {
                    input = inputs.get(i);
                    ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(groupByPlans.get(input));
                    for (int j = 0; j < innerPlans.size(); ++j) {
                        LogicalPlan innerPlan = (LogicalPlan)innerPlans.get(j);
                        byte innerType = innerPlan.getSingleLeafPlanOutputType();
                        byte expectedType = 50;
                        if (!DataType.isAtomic(innerType) && 110 != innerType) {
                            int errCode = 1061;
                            String msg4 = "Sorry, group by complex types will be supported soon";
                            this.msgCollector.collect(msg4, CompilationMessageCollector.MessageType.Error);
                            throw new TypeCheckerException(msg4, errCode, 2);
                        }
                        try {
                            expectedType = groupBySchema.getField((int)j).type;
                        }
                        catch (FrontendException fee) {
                            int errCode = 1060;
                            String msg5 = "Cannot resolve COGroup output schema";
                            this.msgCollector.collect(msg5, CompilationMessageCollector.MessageType.Error);
                            throw new TypeCheckerException(msg5, errCode, 2, fee);
                        }
                        if (innerType == expectedType) continue;
                        this.insertAtomicCastForCOGroupInnerPlan(innerPlan, cg, expectedType);
                    }
                }
            }
            catch (FrontendException fe) {
                int errCode = 1060;
                msg = "Cannot resolve COGroup output schema";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2, fe);
            }
        }
        try {
            Schema outputSchema = cg.regenerateSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1060;
            msg = "Cannot resolve COGroup output schema";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    private void insertAtomicCastForJoinInnerPlan(LogicalPlan innerPlan, LOJoin frj, byte toType) throws VisitorException {
        if (!DataType.isUsableType(toType)) {
            int errCode = 1051;
            String msg = "Cannot cast to " + DataType.findTypeName(toType);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        List leaves = innerPlan.getLeaves();
        if (leaves.size() > 1) {
            int errCode = 2060;
            String msg = "Expected one leaf. Found " + leaves.size() + " leaves.";
            throw new TypeCheckerException(msg, errCode, 4);
        }
        ExpressionOperator currentOutput = (ExpressionOperator)leaves.get(0);
        this.collectCastWarning(frj, currentOutput.getType(), toType);
        OperatorKey newKey = this.genNewOperatorKey(currentOutput);
        LOCast cast = new LOCast(innerPlan, newKey, toType);
        innerPlan.add(cast);
        try {
            innerPlan.connect(currentOutput, cast);
        }
        catch (PlanException pe) {
            int errCode = 2059;
            String msg = "Problem with inserting cast operator for fragment replicate join in plan.";
            throw new TypeCheckerException(msg, errCode, 4, pe);
        }
        this.visit(cast);
    }

    private void insertAtomicCastForCOGroupInnerPlan(LogicalPlan innerPlan, LOCogroup cg, byte toType) throws VisitorException {
        if (!DataType.isUsableType(toType)) {
            int errCode = 1051;
            String msg = "Cannot cast to " + DataType.findTypeName(toType);
            throw new TypeCheckerException(msg, errCode, 2);
        }
        List leaves = innerPlan.getLeaves();
        if (leaves.size() > 1) {
            int errCode = 2060;
            String msg = "Expected one leaf. Found " + leaves.size() + " leaves.";
            throw new TypeCheckerException(msg, errCode, 4);
        }
        ExpressionOperator currentOutput = (ExpressionOperator)leaves.get(0);
        this.collectCastWarning(cg, currentOutput.getType(), toType);
        OperatorKey newKey = this.genNewOperatorKey(currentOutput);
        LOCast cast = new LOCast(innerPlan, newKey, toType);
        innerPlan.add(cast);
        try {
            innerPlan.connect(currentOutput, cast);
        }
        catch (PlanException pe) {
            int errCode = 2059;
            String msg = "Problem with inserting cast operator for cogroup in plan.";
            throw new TypeCheckerException(msg, errCode, 4, pe);
        }
        this.visit(cast);
    }

    public byte getAtomicGroupByType(LOCogroup cg) throws VisitorException {
        if (cg.isTupleGroupCol()) {
            int errCode = 2061;
            String msg = "Expected single group by element but found multiple elements.";
            throw new TypeCheckerException(msg, errCode, 4);
        }
        int groupType = 50;
        for (int i = 0; i < cg.getInputs().size(); ++i) {
            String msg;
            LogicalOperator input = cg.getInputs().get(i);
            ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(cg.getGroupByPlans().get(input));
            if (innerPlans.size() != 1) {
                int errCode = 2062;
                msg = "Each COGroup input has to have the same number of inner plans.";
                throw new TypeCheckerException(msg, errCode, 4);
            }
            byte innerType = ((LogicalPlan)innerPlans.get(0)).getSingleLeafPlanOutputType();
            if ((groupType = DataType.mergeType((byte)groupType, innerType)) != -1) continue;
            if (!this.strictMode) {
                msg = "COGroup by incompatible types results in ByteArray";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Warning, PigWarning.GROUP_BY_INCOMPATIBLE_TYPES);
                groupType = 50;
                continue;
            }
            int errCode = 1062;
            String msg2 = "COGroup by incompatible types";
            this.msgCollector.collect(msg2, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg2, errCode, 2);
        }
        return (byte)groupType;
    }

    public Schema getTupleGroupBySchema(LOCogroup cg) throws VisitorException {
        int i;
        if (!cg.isTupleGroupCol()) {
            int errCode = 2063;
            String msg = "Expected multiple group by element but found single element.";
            throw new TypeCheckerException(msg, errCode, 4);
        }
        ArrayList<Schema.FieldSchema> fsList = new ArrayList<Schema.FieldSchema>();
        int outputSchemaSize = cg.getGroupByPlans().get(cg.getInputs().get(0)).size();
        for (i = 0; i < outputSchemaSize; ++i) {
            fsList.add(new Schema.FieldSchema(null, 50));
        }
        for (i = 0; i < cg.getInputs().size(); ++i) {
            LogicalOperator input = cg.getInputs().get(i);
            ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(cg.getGroupByPlans().get(input));
            for (int j = 0; j < innerPlans.size(); ++j) {
                byte innerType = ((LogicalPlan)innerPlans.get(j)).getSingleLeafPlanOutputType();
                ((Schema.FieldSchema)fsList.get((int)j)).type = DataType.mergeType(((Schema.FieldSchema)fsList.get((int)j)).type, innerType);
                if (((Schema.FieldSchema)fsList.get((int)j)).type != -1) continue;
                if (!this.strictMode) {
                    String msg = "COGroup by incompatible types results in ByteArray";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Warning, PigWarning.GROUP_BY_INCOMPATIBLE_TYPES);
                    ((Schema.FieldSchema)fsList.get((int)j)).type = (byte)50;
                    continue;
                }
                int errCode = 1062;
                String msg = "COGroup by incompatible types";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2);
            }
        }
        return new Schema(fsList);
    }

    @Override
    protected void visit(LOForEach f) throws VisitorException {
        ArrayList<LogicalPlan> plans = f.getForEachPlans();
        f.unsetSchema();
        try {
            boolean outputSchemaIdx = false;
            for (int i = 0; i < plans.size(); ++i) {
                LogicalPlan plan = (LogicalPlan)plans.get(i);
                if (!plan.isSingleLeafPlan()) {
                    int errCode = 1057;
                    String msg = "Generate's expression plan can  only have one output (leaf)";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException(msg, errCode, 2);
                }
                List rootList = plan.getRoots();
                for (int j = 0; j < rootList.size(); ++j) {
                    LogicalOperator innerRoot = (LogicalOperator)rootList.get(j);
                    if (innerRoot instanceof LOProject) {
                        this.resolveLOProjectType((LOProject)innerRoot);
                        continue;
                    }
                    if (innerRoot instanceof LOConst || innerRoot instanceof LOUserFunc) continue;
                    int errCode = 2064;
                    String msg = "Unsupported root type in LOForEach: " + innerRoot.getClass().getSimpleName();
                    throw new TypeCheckerException(msg, errCode, 4);
                }
                this.checkInnerPlan(f.getAlias(), plan);
            }
            f.getSchema();
        }
        catch (VisitorException ve) {
            throw ve;
        }
        catch (FrontendException fe) {
            int errCode = 1060;
            String msg = "Cannot resolve ForEach output schema.";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException(msg, errCode, 2, fe);
        }
    }

    private void checkInnerPlan(String alias, LogicalPlan innerPlan) throws VisitorException {
        this.currentAlias = alias;
        boolean errorCount = false;
        List rootList = innerPlan.getRoots();
        if (rootList.size() < 1) {
            int errCode = 2065;
            String msg = "Did not find roots of the inner plan.";
            throw new TypeCheckerException(msg, errCode, 4);
        }
        for (LogicalOperator op : rootList) {
            if (op instanceof LOProject) {
                this.resolveLOProjectType((LOProject)op);
                continue;
            }
            if (op instanceof LOForEach) {
                op.setType((byte)110);
                DependencyOrderWalker walker = new DependencyOrderWalker(innerPlan);
                this.pushWalker(walker);
                this.visit((LOForEach)op);
                this.popWalker();
                continue;
            }
            if (op instanceof LOConst) continue;
            if (op instanceof LOUserFunc) {
                this.visit((LOUserFunc)op);
                continue;
            }
            int errCode = 2066;
            String msg = "Unsupported root operator in inner plan:" + op.getClass().getSimpleName();
            throw new TypeCheckerException(msg, errCode, 4);
        }
        DependencyOrderWalker walker = new DependencyOrderWalker(innerPlan);
        this.pushWalker(walker);
        this.visit();
        this.popWalker();
    }

    @Override
    protected void visit(LOLoad load) throws VisitorException {
    }

    @Override
    protected void visit(LOStore store) {
    }

    private LOForEach insertCastForEachInBetweenIfNecessary(LogicalOperator fromOp, LogicalOperator toOp, Schema targetSchema) throws VisitorException {
        LogicalPlan currentPlan = (LogicalPlan)this.mCurrentWalker.getPlan();
        List<LogicalOperator> preList = currentPlan.getPredecessors(toOp);
        boolean found = false;
        for (LogicalOperator tmpOp : preList) {
            if (tmpOp != fromOp) continue;
            found = true;
            break;
        }
        if (!found) {
            int errCode = 1077;
            String msg = "Two operators that require a cast in between are not adjacent.";
            throw new TypeCheckerException(msg, errCode, 2);
        }
        Schema fromSchema = null;
        try {
            fromSchema = fromOp.getSchema();
        }
        catch (FrontendException fe) {
            int errCode = 1055;
            String msg = "Problem while reading schema from input of " + fromOp.getClass().getSimpleName();
            throw new TypeCheckerException(msg, errCode, 4, fe);
        }
        if (fromSchema.size() != targetSchema.size()) {
            int errCode = 1078;
            String msg = "Schema size mismatch for casting. Input schema size: " + fromSchema.size() + ". Target schema size: " + targetSchema.size();
            throw new TypeCheckerException(msg, errCode, 2);
        }
        ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>();
        int castNeededCounter = 0;
        for (int i = 0; i < fromSchema.size(); ++i) {
            byte inputFieldType;
            LogicalPlan genPlan = new LogicalPlan();
            LOProject project = new LOProject(genPlan, this.genNewOperatorKey(fromOp), fromOp, i);
            project.setSentinel(true);
            genPlan.add(project);
            Schema.FieldSchema fs = null;
            try {
                fs = fromSchema.getField(i);
            }
            catch (FrontendException fee) {
                int errCode = 1063;
                String msg = "Problem while reading field schema from input while inserting cast ";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException(msg, errCode, 2, fee);
            }
            try {
                inputFieldType = targetSchema.getField((int)i).type;
            }
            catch (FrontendException fee) {
                int errCode = 1064;
                String msg = "Problem reading column " + i + " from schema: " + targetSchema;
                throw new TypeCheckerException(msg, errCode, 2, fee);
            }
            if (inputFieldType != fs.type) {
                ++castNeededCounter;
                LOCast cast = new LOCast(genPlan, this.genNewOperatorKey(fromOp), inputFieldType);
                genPlan.add(cast);
                try {
                    genPlan.connect(project, cast);
                }
                catch (PlanException pe) {
                    int errCode = 2059;
                    String msg = "Problem with inserting cast operator for project in plan.";
                    throw new TypeCheckerException(msg, errCode, 4, pe);
                }
            }
            generatePlans.add(genPlan);
        }
        if (castNeededCounter > 0) {
            ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
            for (int i = 0; i < targetSchema.size(); ++i) {
                flattenList.add(false);
            }
            LOForEach foreach = new LOForEach(currentPlan, this.genNewOperatorKey(fromOp), generatePlans, flattenList);
            currentPlan.add(foreach);
            currentPlan.disconnect(fromOp, toOp);
            try {
                currentPlan.connect(fromOp, foreach);
                currentPlan.connect(foreach, toOp);
            }
            catch (PlanException pe) {
                int errCode = 2059;
                String msg = "Problem with inserting foeach operator for " + toOp.getClass().getSimpleName() + " in plan.";
                throw new TypeCheckerException(msg, errCode, 4, pe);
            }
            return foreach;
        }
        log.debug((Object)"Tried to insert relational casting when not necessary");
        return null;
    }

    private void collectCastWarning(LogicalOperator op, byte originalType, byte toType) {
        String originalTypeName = DataType.findTypeName(originalType);
        String toTypeName = DataType.findTypeName(toType);
        String opName = op.getClass().getSimpleName();
        PigWarning kind = null;
        switch (toType) {
            case 120: {
                kind = PigWarning.IMPLICIT_CAST_TO_BAG;
                break;
            }
            case 55: {
                kind = PigWarning.IMPLICIT_CAST_TO_CHARARRAY;
                break;
            }
            case 25: {
                kind = PigWarning.IMPLICIT_CAST_TO_DOUBLE;
                break;
            }
            case 20: {
                kind = PigWarning.IMPLICIT_CAST_TO_FLOAT;
                break;
            }
            case 10: {
                kind = PigWarning.IMPLICIT_CAST_TO_INT;
                break;
            }
            case 15: {
                kind = PigWarning.IMPLICIT_CAST_TO_LONG;
                break;
            }
            case 100: {
                kind = PigWarning.IMPLICIT_CAST_TO_MAP;
                break;
            }
            case 110: {
                kind = PigWarning.IMPLICIT_CAST_TO_TUPLE;
            }
        }
        this.msgCollector.collect(originalTypeName + " is implicitly cast to " + toTypeName + " under " + opName + " Operator", CompilationMessageCollector.MessageType.Warning, kind);
    }

    private OperatorKey genNewOperatorKey(LogicalOperator neighbor) {
        String scope = neighbor.getOperatorKey().getScope();
        long newId = NodeIdGenerator.getGenerator().getNextNodeId(scope);
        return new OperatorKey(scope, newId);
    }

    private FuncSpec getLoadFuncSpec(LogicalOperator op, String parentCanonicalName) throws FrontendException {
        MultiMap<String, FuncSpec> loadFuncSpecMap = new MultiMap<String, FuncSpec>();
        if (op instanceof ExpressionOperator) {
            if (op instanceof LOUserFunc && ((LOUserFunc)op).getImplicitReferencedOperator() == null) {
                return null;
            }
            Schema.FieldSchema fs = ((ExpressionOperator)op).getFieldSchema();
            if (parentCanonicalName != null && !fs.findFieldSchema(parentCanonicalName).getCanonicalMap().isEmpty()) {
                fs = fs.findFieldSchema(parentCanonicalName);
            }
            this.getLoadFuncSpec(fs, loadFuncSpecMap);
        } else {
            if (op instanceof LOLoad) {
                return ((LOLoad)op).getInputFile().getFuncSpec();
            }
            if (op instanceof LOStream) {
                StreamingCommand command = ((LOStream)op).getStreamingCommand();
                StreamingCommand.HandleSpec streamOutputSpec = command.getOutputSpec();
                FuncSpec streamLoaderSpec = new FuncSpec(streamOutputSpec.getSpec());
                return streamLoaderSpec;
            }
            Schema s = op.getSchema();
            if (null != s) {
                Schema.FieldSchema fieldSchema = s.findFieldSchema(parentCanonicalName);
                this.getLoadFuncSpec(fieldSchema, loadFuncSpecMap);
            } else {
                LogicalPlan lp = op.getPlan();
                for (LogicalOperator pred : lp.getPredecessors(op)) {
                    FuncSpec lfSpec = this.getLoadFuncSpec(pred, parentCanonicalName);
                    if (null == lfSpec) continue;
                    loadFuncSpecMap.put(lfSpec.getClassName(), lfSpec);
                }
            }
        }
        if (loadFuncSpecMap.keySet().size() == 0) {
            return null;
        }
        if (loadFuncSpecMap.keySet().size() == 1) {
            String lfString = loadFuncSpecMap.keySet().iterator().next();
            return loadFuncSpecMap.get(lfString).iterator().next();
        }
        int errCode = 1065;
        String msg = "Found more than one load function to use: " + loadFuncSpecMap.keySet();
        throw new FrontendException(msg, errCode, 2);
    }

    private void getLoadFuncSpec(Schema.FieldSchema fieldSchema, MultiMap<String, FuncSpec> loadFuncSpecMap) throws FrontendException {
        if (fieldSchema == null) {
            return;
        }
        Map<String, LogicalOperator> canonicalMap = fieldSchema.getCanonicalMap();
        if (canonicalMap.size() > 0) {
            for (Map.Entry<String, LogicalOperator> entry : canonicalMap.entrySet()) {
                FuncSpec lfSpec = this.getLoadFuncSpec(entry.getValue(), entry.getKey());
                if (null == lfSpec) continue;
                loadFuncSpecMap.put(lfSpec.getClassName(), lfSpec);
            }
        } else {
            MultiMap<LogicalOperator, String> reverseCanonicalMap = fieldSchema.getReverseCanonicalMap();
            for (LogicalOperator lop : reverseCanonicalMap.keySet()) {
                FuncSpec lfSpec = this.getLoadFuncSpec(lop, null);
                if (null == lfSpec) continue;
                loadFuncSpecMap.put(lfSpec.getClassName(), lfSpec);
            }
        }
    }

    private String generateIncompatibleTypesMessage(LogicalOperator op, String operatorDesc, byte lhsType, byte rhsType) {
        String alias = this.currentAlias;
        if (op.getAlias() != null) {
            alias = op.getAlias();
        }
        String msg = "In alias " + alias + ", ";
        msg = msg + "incompatible types in " + operatorDesc + " Operator" + " left hand side:" + DataType.findTypeName(lhsType) + " right hand side:" + DataType.findTypeName(rhsType);
        return msg;
    }

    static {
        castLookup.put((Byte)10, (byte)15);
        castLookup.put((Byte)10, (byte)20);
        castLookup.put((Byte)10, (byte)25);
        castLookup.put((Byte)15, (byte)20);
        castLookup.put((Byte)15, (byte)25);
        castLookup.put((Byte)20, (byte)25);
        castLookup.put((Byte)50, (byte)10);
        castLookup.put((Byte)50, (byte)15);
        castLookup.put((Byte)50, (byte)20);
        castLookup.put((Byte)50, (byte)25);
        castLookup.put((Byte)50, (byte)55);
        castLookup.put((Byte)50, (byte)110);
        castLookup.put((Byte)50, (byte)120);
        castLookup.put((Byte)50, (byte)100);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScoreFuncSpecListComparator
    implements Comparator<Pair<Long, FuncSpec>> {
        private ScoreFuncSpecListComparator() {
        }

        @Override
        public int compare(Pair<Long, FuncSpec> o1, Pair<Long, FuncSpec> o2) {
            if ((Long)o1.first < (Long)o2.first) {
                return -1;
            }
            if ((Long)o1.first > (Long)o2.first) {
                return 1;
            }
            return 0;
        }
    }
}

