/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.CommonNodeFinder;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.plan.optimizer.Rule;
import org.apache.pig.impl.plan.optimizer.RuleOperator;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleMatcher<O extends Operator, P extends OperatorPlan<O>> {
    private Rule<O, P> mRule;
    private List<Pair<O, RuleOperator.NodeType>> mMatch;
    private List<List<Pair<O, RuleOperator.NodeType>>> mPrelimMatches = new ArrayList<List<Pair<O, RuleOperator.NodeType>>>();
    private List<List<O>> mMatches = new ArrayList<List<O>>();
    private P mPlan;
    private int mNumCommonNodes = 0;

    public boolean match(Rule<O, P> rule) throws OptimizerException {
        this.mRule = rule;
        CommonNodeFinder commonNodeFinder = new CommonNodeFinder(this.mRule.getPlan());
        try {
            commonNodeFinder.visit();
            this.mNumCommonNodes = commonNodeFinder.getCount();
        }
        catch (VisitorException ve) {
            int errCode = 2125;
            String msg = "Internal error. Problem in computing common nodes in the Rule Plan.";
            throw new OptimizerException(msg, errCode, 4, ve);
        }
        this.mPlan = this.mRule.getTransformer().getPlan();
        this.mMatches.clear();
        this.mPrelimMatches.clear();
        if (this.mRule.getWalkerAlgo() == Rule.WalkerAlgo.DependencyOrderWalker) {
            this.DependencyOrderWalker();
        } else if (this.mRule.getWalkerAlgo() == Rule.WalkerAlgo.DepthFirstWalker) {
            this.DepthFirstWalker();
        } else if (this.mRule.getWalkerAlgo() == Rule.WalkerAlgo.ReverseDependencyOrderWalker) {
            this.ReverseDependencyOrderWalker();
        }
        return this.mMatches.size() != 0;
    }

    private void ReverseDependencyOrderWalker() {
        ArrayList fifo = new ArrayList();
        HashSet seen = new HashSet();
        List roots = ((OperatorPlan)this.mPlan).getRoots();
        if (roots == null) {
            return;
        }
        for (Operator op : roots) {
            this.RDODoAllSuccessors(op, seen, fifo);
        }
        for (Operator op : fifo) {
            if (!this.beginMatch(op)) continue;
            this.mPrelimMatches.add(this.mMatch);
        }
        if (this.mPrelimMatches.size() > 0) {
            this.processPreliminaryMatches();
        }
    }

    private void RDODoAllSuccessors(O node, Set<O> seen, Collection<O> fifo) {
        if (!seen.contains(node)) {
            List<O> succs = ((OperatorPlan)this.mPlan).getSuccessors(node);
            if (succs != null && succs.size() > 0) {
                for (Operator op : succs) {
                    this.RDODoAllSuccessors(op, seen, fifo);
                }
            }
            seen.add(node);
            fifo.add(node);
        }
    }

    private void DependencyOrderWalker() {
        ArrayList fifo = new ArrayList();
        HashSet seen = new HashSet();
        List leaves = ((OperatorPlan)this.mPlan).getLeaves();
        if (leaves == null) {
            return;
        }
        for (Operator op : leaves) {
            this.BFSDoAllPredecessors(op, seen, fifo);
        }
        for (Operator op : fifo) {
            if (!this.beginMatch(op)) continue;
            this.mPrelimMatches.add(this.mMatch);
        }
        if (this.mPrelimMatches.size() > 0) {
            this.processPreliminaryMatches();
        }
    }

    private void processPreliminaryMatches() {
        int i;
        ArrayList<List<O>> commonNodesPerMatch = new ArrayList<List<O>>();
        for (i = 0; i < this.mPrelimMatches.size(); ++i) {
            commonNodesPerMatch.add(this.getCommonNodesFromMatch(this.mPrelimMatches.get(i)));
        }
        if (this.mNumCommonNodes == 0) {
            for (i = 0; i < commonNodesPerMatch.size(); ++i) {
                if (commonNodesPerMatch.get(i) == null) continue;
                return;
            }
            for (i = 0; i < this.mPrelimMatches.size(); ++i) {
                ArrayList match = new ArrayList();
                match.add(this.mPrelimMatches.get((int)i).get((int)0).first);
                this.mMatches.add(match);
            }
            return;
        }
        for (i = 0; i < commonNodesPerMatch.size(); ++i) {
            int commonNodes;
            int n = commonNodes = commonNodesPerMatch.get(i) == null ? 0 : ((List)commonNodesPerMatch.get(i)).size();
            if (commonNodes == this.mNumCommonNodes) continue;
            return;
        }
        ArrayList<Boolean> processedMatches = new ArrayList<Boolean>();
        for (int i2 = 0; i2 < this.mPrelimMatches.size(); ++i2) {
            processedMatches.add(false);
        }
        int outerIndex = 0;
        do {
            if (((Boolean)processedMatches.get(outerIndex)).booleanValue()) {
                ++outerIndex;
                continue;
            }
            List<Pair<O, RuleOperator.NodeType>> outerMatch = this.mPrelimMatches.get(outerIndex);
            List outerCommonNodes = (List)commonNodesPerMatch.get(outerIndex);
            HashSet outerSetCommonNodes = new HashSet(outerCommonNodes);
            HashSet finalIntersection = new HashSet(outerCommonNodes);
            HashSet cumulativeIntersection = new HashSet(outerCommonNodes);
            ArrayList<Operator> patternMatchingRoots = new ArrayList<Operator>();
            HashSet unionOfRoots = new HashSet();
            boolean innerMatchProcessed = false;
            unionOfRoots.add(outerMatch.get((int)0).first);
            for (int innerIndex = outerIndex + 1; innerIndex < this.mPrelimMatches.size() && !((Boolean)processedMatches.get(innerIndex)).booleanValue(); ++innerIndex) {
                List<Pair<O, RuleOperator.NodeType>> innerMatch = this.mPrelimMatches.get(innerIndex);
                List innerCommonNodes = (List)commonNodesPerMatch.get(innerIndex);
                HashSet innerSetCommonNodes = new HashSet(innerCommonNodes);
                outerSetCommonNodes.retainAll(innerSetCommonNodes);
                if (outerSetCommonNodes.size() != this.mNumCommonNodes) continue;
                HashSet tempCumulativeIntersection = new HashSet(cumulativeIntersection);
                tempCumulativeIntersection.retainAll(outerSetCommonNodes);
                if (tempCumulativeIntersection.size() != this.mNumCommonNodes) {
                    this.mMatches = new ArrayList<List<O>>();
                    return;
                }
                processedMatches.set(innerIndex, true);
                innerMatchProcessed = true;
                cumulativeIntersection = tempCumulativeIntersection;
                unionOfRoots.add(innerMatch.get((int)0).first);
            }
            cumulativeIntersection.retainAll(finalIntersection);
            if (cumulativeIntersection.size() != this.mNumCommonNodes && innerMatchProcessed) {
                this.mMatches = new ArrayList<List<O>>();
                return;
            }
            processedMatches.set(outerIndex, true);
            for (Operator node : unionOfRoots) {
                patternMatchingRoots.add(node);
            }
            this.mMatches.add(patternMatchingRoots);
            ++outerIndex;
        } while (outerIndex < this.mPrelimMatches.size() - 1);
    }

    private List<O> getCommonNodesFromMatch(List<Pair<O, RuleOperator.NodeType>> match) {
        ArrayList<Operator> commonNodes = null;
        HashMap<Operator, Boolean> lookup = new HashMap<Operator, Boolean>();
        for (int index = 0; index < match.size(); ++index) {
            Operator node;
            if (!((RuleOperator.NodeType)((Object)match.get((int)index).second)).equals((Object)RuleOperator.NodeType.COMMON_NODE)) continue;
            if (commonNodes == null) {
                commonNodes = new ArrayList<Operator>();
            }
            if (lookup.get(node = (Operator)match.get((int)index).first) != null) continue;
            commonNodes.add(node);
            lookup.put(node, true);
        }
        return commonNodes;
    }

    private void BFSDoAllPredecessors(O node, Set<O> seen, Collection<O> fifo) {
        if (!seen.contains(node)) {
            List<O> preds = ((OperatorPlan)this.mPlan).getPredecessors(node);
            if (preds != null && preds.size() > 0) {
                for (Operator op : preds) {
                    this.BFSDoAllPredecessors(op, seen, fifo);
                }
            }
            seen.add(node);
            fifo.add(node);
        }
    }

    private void DepthFirstWalker() {
        HashSet seen = new HashSet();
        this.DFSVisit(null, ((OperatorPlan)this.mPlan).getRoots(), seen);
    }

    private void DFSVisit(O node, Collection<O> successors, Set<O> seen) {
        if (successors == null) {
            return;
        }
        for (Operator suc : successors) {
            if (!seen.add(suc)) continue;
            if (this.beginMatch(suc)) {
                this.mPrelimMatches.add(this.mMatch);
            }
            List<Operator> newSuccessors = ((OperatorPlan)this.mPlan).getSuccessors((Operator)suc);
            this.DFSVisit(suc, newSuccessors, seen);
        }
    }

    List<O> getMatches() {
        if (this.mMatches.size() >= 1) {
            return this.mMatches.get(0);
        }
        return null;
    }

    public List<List<O>> getAllMatches() {
        return this.mMatches;
    }

    private boolean beginMatch(O node) {
        if (node == null) {
            return false;
        }
        this.mMatch = new ArrayList<Pair<O, RuleOperator.NodeType>>();
        List ruleRoots = this.mRule.getPlan().getRoots();
        for (RuleOperator ruleRoot : ruleRoots) {
            if (!node.getClass().getName().equals(ruleRoot.getNodeClass().getName()) && !ruleRoot.getNodeType().equals((Object)RuleOperator.NodeType.ANY_NODE)) continue;
            this.mMatch.add(new Pair<O, RuleOperator.NodeType>(node, ruleRoot.getNodeType()));
            List<RuleOperator> ruleRootSuccessors = this.mRule.getPlan().getSuccessors(ruleRoot);
            if (ruleRootSuccessors == null) {
                return true;
            }
            List<O> nodeSuccessors = ((OperatorPlan)this.mPlan).getSuccessors(node);
            if (nodeSuccessors == null || nodeSuccessors.size() != ruleRootSuccessors.size()) {
                return false;
            }
            boolean foundMatch = false;
            for (Operator nodeSuccessor : nodeSuccessors) {
                foundMatch |= this.continueMatch(nodeSuccessor, ruleRootSuccessors);
            }
            return foundMatch;
        }
        return false;
    }

    private boolean continueMatch(O node, List<RuleOperator> ruleOperators) {
        Iterator<RuleOperator> i$ = ruleOperators.iterator();
        if (i$.hasNext()) {
            RuleOperator ruleOperator = i$.next();
            if (node.getClass().getName().equals(ruleOperator.getNodeClass().getName()) || ruleOperator.getNodeType().equals((Object)RuleOperator.NodeType.ANY_NODE)) {
                this.mMatch.add(new Pair<O, RuleOperator.NodeType>(node, ruleOperator.getNodeType()));
                List<RuleOperator> ruleOperatorSuccessors = this.mRule.getPlan().getSuccessors(ruleOperator);
                if (ruleOperatorSuccessors == null) {
                    return true;
                }
                List<O> nodeSuccessors = ((OperatorPlan)this.mPlan).getSuccessors(node);
                if (nodeSuccessors == null || nodeSuccessors.size() != ruleOperatorSuccessors.size()) {
                    return false;
                }
                boolean foundMatch = false;
                for (Operator nodeSuccessor : nodeSuccessors) {
                    foundMatch |= this.continueMatch(nodeSuccessor, ruleOperatorSuccessors);
                }
                return foundMatch;
            }
            return false;
        }
        return false;
    }
}

