/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan.optimizer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.RuleOperator;
import org.apache.pig.impl.plan.optimizer.RulePlan;
import org.apache.pig.impl.plan.optimizer.RulePlanVisitor;

public class RulePlanPrinter
extends RulePlanVisitor {
    private PrintStream mStream = null;
    private String TAB1 = "    ";
    private String TABMore = "|   ";
    private String LSep = "|\n|---";
    private int levelCntr = -1;

    public RulePlanPrinter(PrintStream ps, RulePlan plan) {
        super(plan, (PlanWalker<RuleOperator, RulePlan>)new DepthFirstWalker<RuleOperator, RulePlan>(plan));
        this.mStream = ps;
    }

    public void visit() throws VisitorException {
        try {
            this.mStream.write(this.depthFirst().getBytes());
        }
        catch (IOException e) {
            throw new VisitorException(e);
        }
    }

    public void print(OutputStream printer) throws VisitorException, IOException {
        printer.write(this.depthFirst().getBytes());
    }

    protected String depthFirst() throws VisitorException, IOException {
        StringBuilder sb = new StringBuilder();
        List leaves = ((RulePlan)this.mPlan).getLeaves();
        Collections.sort(leaves);
        for (RuleOperator leaf : leaves) {
            sb.append(this.depthFirst(leaf));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String depthFirst(RuleOperator node) throws VisitorException, IOException {
        StringBuilder sb = new StringBuilder(node.name());
        sb.append("\n");
        List<RuleOperator> originalPredecessors = ((RulePlan)this.mPlan).getPredecessors(node);
        if (originalPredecessors == null) {
            return sb.toString();
        }
        ArrayList<RuleOperator> predecessors = new ArrayList<RuleOperator>(originalPredecessors);
        Collections.sort(predecessors);
        int i = 0;
        for (RuleOperator pred : predecessors) {
            ++i;
            String DFStr = this.depthFirst(pred);
            if (DFStr == null) continue;
            sb.append(this.LSep);
            if (i < predecessors.size()) {
                sb.append(this.shiftStringByTabs(DFStr, 2));
                continue;
            }
            sb.append(this.shiftStringByTabs(DFStr, 1));
        }
        return sb.toString();
    }

    private String shiftStringByTabs(String DFStr, int TabType) {
        StringBuilder sb = new StringBuilder();
        String[] spl = DFStr.split("\n");
        String tab = TabType == 1 ? this.TAB1 : this.TABMore;
        sb.append(spl[0] + "\n");
        for (int i = 1; i < spl.length; ++i) {
            sb.append(tab);
            sb.append(spl[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void dispTabs() {
        for (int i = 0; i < this.levelCntr; ++i) {
            System.out.print(this.TAB1);
        }
    }
}

