/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOIsNull;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.DependencyOrderWalkerWOSeenChk;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ColumnExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NegativeExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalExpPlanMigrationVistor
extends LOVisitor {
    protected LogicalExpressionPlan exprPlan = new LogicalExpressionPlan();
    protected HashMap<LogicalOperator, LogicalExpression> exprOpsMap = new HashMap();
    protected LogicalRelationalOperator attachedRelationalOp;
    protected LogicalOperator oldAttachedRelationalOp;
    protected LogicalPlan outerPlan;
    private Map<LogicalOperator, LogicalRelationalOperator> outerOpsMap;

    public LogicalExpPlanMigrationVistor(LogicalPlan expressionPlan, LogicalOperator oldAttachedOperator, LogicalRelationalOperator attachedOperator, LogicalPlan outerPlan, Map<LogicalOperator, LogicalRelationalOperator> outerOpsMap) {
        super(expressionPlan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalkerWOSeenChk<LogicalOperator, LogicalPlan>(expressionPlan));
        this.attachedRelationalOp = attachedOperator;
        this.oldAttachedRelationalOp = oldAttachedOperator;
        this.outerPlan = outerPlan;
        this.outerOpsMap = outerOpsMap;
    }

    private void translateConnection(LogicalOperator oldOp, Operator newOp) {
        List<LogicalOperator> softPreds;
        List<LogicalOperator> preds = ((LogicalPlan)this.mPlan).getPredecessors(oldOp);
        if (preds != null) {
            for (LogicalOperator pred : preds) {
                Operator newPred = this.exprOpsMap.get(pred);
                newOp.getPlan().connect(newOp, newPred);
            }
        }
        if ((softPreds = ((LogicalPlan)this.mPlan).getSoftLinkPredecessors(oldOp)) != null) {
            for (LogicalOperator softPred : softPreds) {
                Operator newSoftPred = this.exprOpsMap.get(softPred);
                newOp.getPlan().createSoftLink(newOp, newSoftPred);
            }
        }
    }

    @Override
    public void visit(LOProject project) throws VisitorException {
        ColumnExpression pe;
        int col = project.getCol();
        if (project.getPlan().getPredecessors(project) != null && project.getPlan().getPredecessors(project).get(0) instanceof LOProject) {
            ArrayList<Integer> columnNums = new ArrayList<Integer>();
            columnNums.add(col);
            pe = new DereferenceExpression((OperatorPlan)this.exprPlan, columnNums);
        } else {
            int input;
            LogicalOperator lg = project.getExpression();
            if (this.oldAttachedRelationalOp instanceof LOSplitOutput) {
                LOSplit split = (LOSplit)this.outerPlan.getPredecessors(this.oldAttachedRelationalOp).get(0);
                input = this.outerPlan.getPredecessors(split).indexOf(lg);
            } else {
                input = this.outerPlan.getPredecessors(this.oldAttachedRelationalOp).indexOf(lg);
            }
            pe = new ProjectExpression(this.exprPlan, input, project.isStar() ? -1 : col, this.attachedRelationalOp);
        }
        this.exprPlan.add(pe);
        this.exprOpsMap.put(project, pe);
        this.translateConnection(project, pe);
    }

    @Override
    public void visit(LOConst con) throws VisitorException {
        ConstantExpression ce = null;
        try {
            ce = new ConstantExpression(this.exprPlan, con.getValue(), Util.translateFieldSchema(con.getFieldSchema()));
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
        this.exprPlan.add(ce);
        this.exprOpsMap.put(con, ce);
        this.translateConnection(con, ce);
    }

    @Override
    public void visit(LOGreaterThan op) throws VisitorException {
        ExpressionOperator left = op.getLhsOperand();
        ExpressionOperator right = op.getRhsOperand();
        GreaterThanExpression eq = new GreaterThanExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(op, eq);
    }

    @Override
    public void visit(LOLesserThan op) throws VisitorException {
        ExpressionOperator left = op.getLhsOperand();
        ExpressionOperator right = op.getRhsOperand();
        LessThanExpression eq = new LessThanExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(op, eq);
    }

    @Override
    public void visit(LOGreaterThanEqual op) throws VisitorException {
        ExpressionOperator left = op.getLhsOperand();
        ExpressionOperator right = op.getRhsOperand();
        GreaterThanEqualExpression eq = new GreaterThanEqualExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(op, eq);
    }

    @Override
    public void visit(LOLesserThanEqual op) throws VisitorException {
        ExpressionOperator left = op.getLhsOperand();
        ExpressionOperator right = op.getRhsOperand();
        LessThanEqualExpression eq = new LessThanEqualExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(op, eq);
    }

    @Override
    public void visit(LOEqual op) throws VisitorException {
        ExpressionOperator left = op.getLhsOperand();
        ExpressionOperator right = op.getRhsOperand();
        EqualExpression eq = new EqualExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(op, eq);
    }

    @Override
    public void visit(LOUserFunc op) throws VisitorException {
        UserFuncExpression exp = new UserFuncExpression(this.exprPlan, op.getFuncSpec());
        List<ExpressionOperator> args = op.getArguments();
        for (ExpressionOperator arg : args) {
            LogicalExpression expArg = this.exprOpsMap.get(arg);
            this.exprPlan.connect(exp, expArg);
        }
        this.exprOpsMap.put(op, exp);
        if (op.getImplicitReferencedOperator() != null) {
            exp.setImplicitReferencedOperator(this.outerOpsMap.get(op.getImplicitReferencedOperator()));
        }
    }

    @Override
    public void visit(LOBinCond op) throws VisitorException {
        ExpressionOperator condition = op.getCond();
        ExpressionOperator left = op.getLhsOp();
        ExpressionOperator right = op.getRhsOp();
        BinCondExpression exp = new BinCondExpression(this.exprPlan, this.exprOpsMap.get(condition), this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(op, exp);
    }

    @Override
    public void visit(LOCast cast) throws VisitorException {
        ExpressionOperator exp = cast.getExpression();
        CastExpression c = null;
        try {
            c = new CastExpression(this.exprPlan, this.exprOpsMap.get(exp), Util.translateFieldSchema(cast.getFieldSchema()));
        }
        catch (FrontendException e) {
            throw new VisitorException(e);
        }
        c.setFuncSpec(cast.getLoadFuncSpec());
        this.exprOpsMap.put(cast, c);
    }

    @Override
    public void visit(LORegexp binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        RegexExpression ae = new RegexExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LONotEqual op) throws VisitorException {
        ExpressionOperator left = op.getLhsOperand();
        ExpressionOperator right = op.getRhsOperand();
        NotEqualExpression eq = new NotEqualExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(op, eq);
    }

    @Override
    public void visit(LOAdd binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        AddExpression ae = new AddExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LOSubtract binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        SubtractExpression ae = new SubtractExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LOMultiply binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        MultiplyExpression ae = new MultiplyExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LODivide binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        DivideExpression ae = new DivideExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LOMod binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        ModExpression ae = new ModExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LONegative uniOp) throws VisitorException {
        ExpressionOperator exp = uniOp.getOperand();
        NegativeExpression op = new NegativeExpression(this.exprPlan, this.exprOpsMap.get(exp));
        this.exprOpsMap.put(uniOp, op);
    }

    @Override
    public void visit(LOMapLookup colOp) throws VisitorException {
        Schema.FieldSchema fieldSchema;
        try {
            fieldSchema = colOp.getFieldSchema();
        }
        catch (FrontendException e) {
            throw new VisitorException(e.getMessage());
        }
        LogicalSchema.LogicalFieldSchema logfieldSchema = new LogicalSchema.LogicalFieldSchema(fieldSchema.alias, Util.translateSchema(fieldSchema.schema), fieldSchema.type);
        LogicalExpression map = this.exprOpsMap.get(colOp.getMap());
        MapLookupExpression op = new MapLookupExpression(this.exprPlan, colOp.getLookUpKey(), logfieldSchema);
        this.exprPlan.connect(op, map);
        this.exprOpsMap.put(colOp, op);
    }

    @Override
    public void visit(LOAnd binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        AndExpression ae = new AndExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LOOr binOp) throws VisitorException {
        ExpressionOperator left = binOp.getLhsOperand();
        ExpressionOperator right = binOp.getRhsOperand();
        OrExpression ae = new OrExpression(this.exprPlan, this.exprOpsMap.get(left), this.exprOpsMap.get(right));
        this.exprOpsMap.put(binOp, ae);
    }

    @Override
    public void visit(LONot uniOp) throws VisitorException {
        ExpressionOperator exp = uniOp.getOperand();
        NotExpression not = new NotExpression(this.exprPlan, this.exprOpsMap.get(exp));
        this.exprOpsMap.put(uniOp, not);
    }

    @Override
    public void visit(LOIsNull uniOp) throws VisitorException {
        ExpressionOperator exp = uniOp.getOperand();
        IsNullExpression isNull = new IsNullExpression(this.exprPlan, this.exprOpsMap.get(exp));
        this.exprOpsMap.put(uniOp, isNull);
    }
}

