/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static LogicalSchema translateSchema(Schema schema) {
        if (schema == null) {
            return null;
        }
        LogicalSchema s2 = new LogicalSchema();
        List<Schema.FieldSchema> ll = schema.getFields();
        for (Schema.FieldSchema f : ll) {
            LogicalSchema.LogicalFieldSchema f2 = new LogicalSchema.LogicalFieldSchema(f.alias, Util.translateSchema(f.schema), f.type);
            s2.addField(f2);
        }
        s2.setTwoLevelAccessRequired(schema.isTwoLevelAccessRequired());
        return s2;
    }

    public static LogicalSchema.LogicalFieldSchema translateFieldSchema(Schema.FieldSchema fs) {
        LogicalSchema newSchema = null;
        if (fs.schema != null) {
            newSchema = Util.translateSchema(fs.schema);
        }
        LogicalSchema.LogicalFieldSchema newFs = new LogicalSchema.LogicalFieldSchema(null, newSchema, fs.type);
        return newFs;
    }

    public static Schema translateSchema(LogicalSchema schema) {
        if (schema == null) {
            return null;
        }
        Schema s2 = new Schema();
        List<LogicalSchema.LogicalFieldSchema> ll = schema.getFields();
        for (LogicalSchema.LogicalFieldSchema f : ll) {
            Schema.FieldSchema f2 = null;
            try {
                f2 = new Schema.FieldSchema(f.alias, Util.translateSchema(f.schema), f.type);
                f2.canonicalName = Long.valueOf(f.uid).toString();
                s2.add(f2);
            }
            catch (FrontendException e) {}
        }
        s2.setTwoLevelAccessRequired(schema.isTwoLevelAccessRequired());
        return s2;
    }

    public static Schema.FieldSchema translateFieldSchema(LogicalSchema.LogicalFieldSchema fs) {
        Schema newSchema = null;
        if (fs.schema != null) {
            newSchema = Util.translateSchema(fs.schema);
        }
        Schema.FieldSchema newFs = null;
        try {
            newFs = new Schema.FieldSchema(null, newSchema, fs.type);
        }
        catch (FrontendException frontendException) {
            // empty catch block
        }
        return newFs;
    }

    public static LOForEach addForEachAfter(LogicalPlan plan, LogicalRelationalOperator op, int branch, Set<Integer> columnsToDrop) throws FrontendException {
        LOForEach foreach = new LOForEach(plan);
        plan.add(foreach);
        List<Operator> next = plan.getSuccessors(op);
        if (next != null) {
            LogicalRelationalOperator nextOp = (LogicalRelationalOperator)next.get(branch);
            plan.insertBetween(op, foreach, nextOp);
        } else {
            plan.connect(op, foreach);
        }
        LogicalPlan innerPlan = new LogicalPlan();
        foreach.setInnerPlan(innerPlan);
        LogicalSchema schema = op.getSchema();
        ArrayList<LogicalExpressionPlan> exps = new ArrayList<LogicalExpressionPlan>();
        LOGenerate gen = new LOGenerate(innerPlan, exps, new boolean[schema.size() - columnsToDrop.size()]);
        innerPlan.add(gen);
        int j = 0;
        for (int i = 0; i < schema.size(); ++i) {
            if (columnsToDrop.contains(i)) continue;
            LOInnerLoad innerLoad = new LOInnerLoad(innerPlan, foreach, i);
            innerPlan.add(innerLoad);
            innerPlan.connect(innerLoad, gen);
            LogicalExpressionPlan exp = new LogicalExpressionPlan();
            ProjectExpression prj = new ProjectExpression(exp, j++, -1, gen);
            exp.add(prj);
            exps.add(exp);
        }
        return foreach;
    }
}

