/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORead;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.pen.EquivalenceClasses;
import org.apache.pig.pen.util.DependencyOrderLimitedWalker;
import org.apache.pig.pen.util.LineageTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedDataVisitor
extends LOVisitor {
    Map<LogicalOperator, DataBag> derivedData = new HashMap<LogicalOperator, DataBag>();
    PhysicalPlan physPlan = null;
    Map<LOLoad, DataBag> baseData = null;
    Map<LogicalOperator, PhysicalOperator> LogToPhyMap = null;
    Log log = LogFactory.getLog(this.getClass());
    Map<LogicalOperator, Collection<IdentityHashSet<Tuple>>> OpToEqClasses = null;
    Collection<IdentityHashSet<Tuple>> EqClasses = null;
    LineageTracer lineage = new LineageTracer();

    public DerivedDataVisitor(LogicalPlan plan, PigContext pc, Map<LOLoad, DataBag> baseData, Map<LogicalOperator, PhysicalOperator> logToPhyMap, PhysicalPlan physPlan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
        this.baseData = baseData;
        this.OpToEqClasses = new HashMap<LogicalOperator, Collection<IdentityHashSet<Tuple>>>();
        this.EqClasses = new LinkedList<IdentityHashSet<Tuple>>();
        this.LogToPhyMap = logToPhyMap;
        this.physPlan = physPlan;
    }

    public DerivedDataVisitor(LogicalOperator op, PigContext pc, Map<LOLoad, DataBag> baseData, Map<LogicalOperator, PhysicalOperator> logToPhyMap, PhysicalPlan physPlan) {
        super(op.getPlan(), (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderLimitedWalker<LogicalOperator, LogicalPlan>(op, op.getPlan()));
        this.baseData = baseData;
        this.OpToEqClasses = new HashMap<LogicalOperator, Collection<IdentityHashSet<Tuple>>>();
        this.EqClasses = new LinkedList<IdentityHashSet<Tuple>>();
        this.LogToPhyMap = logToPhyMap;
        this.physPlan = physPlan;
    }

    public void setOperatorToEvaluate(LogicalOperator op) {
        this.mCurrentWalker = new DependencyOrderLimitedWalker<LogicalOperator, LogicalPlan>(op, op.getPlan());
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
        PhysicalOperator physOp = this.LogToPhyMap.get(cg);
        Random r = new Random();
        ArrayList<PhysicalOperator> inputs = new ArrayList<PhysicalOperator>();
        PhysicalPlan phy = new PhysicalPlan();
        phy.add(physOp);
        for (PhysicalOperator input : this.physPlan.getPredecessors(physOp)) {
            inputs.add(input.getInputs().get(0));
            phy.add(input);
            try {
                phy.connect(input, physOp);
            }
            catch (PlanException e) {
                e.printStackTrace();
                this.log.error((Object)("Error connecting " + input.name() + " to " + physOp.name()));
            }
        }
        physOp.setLineageTracer(this.lineage);
        for (int i = 0; i < inputs.size(); ++i) {
            DataBag bag = this.derivedData.get(cg.getInputs().get(i));
            PORead por = new PORead(new OperatorKey("", r.nextLong()), bag);
            phy.add(por);
            try {
                phy.connect(por, physOp.getInputs().get(i));
                continue;
            }
            catch (PlanException e) {
                e.printStackTrace();
                this.log.error((Object)("Error connecting " + por.name() + " to " + physOp.name()));
            }
        }
        DataBag output = BagFactory.getInstance().newDefaultBag();
        Tuple t = null;
        try {
            Result res = physOp.getNext(t);
            while (res.returnStatus != 3) {
                output.add((Tuple)res.result);
                res = physOp.getNext(t);
            }
        }
        catch (ExecException e) {
            this.log.error((Object)("Error evaluating operator : " + physOp.name()));
        }
        this.derivedData.put(cg, output);
        try {
            Collection<IdentityHashSet<Tuple>> eq = EquivalenceClasses.getEquivalenceClasses(cg, this.derivedData);
            this.EqClasses.addAll(eq);
            this.OpToEqClasses.put(cg, eq);
        }
        catch (ExecException e) {
            e.printStackTrace();
            this.log.error((Object)("Error updating equivalence classes while evaluating operators. \n" + e.getMessage()));
        }
        physOp.setLineageTracer(null);
    }

    @Override
    protected void visit(LOCross cs) throws VisitorException {
        this.evaluateOperator(cs);
    }

    @Override
    protected void visit(LODistinct dt) throws VisitorException {
        this.evaluateOperator(dt);
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
        this.evaluateOperator(filter);
    }

    @Override
    protected void visit(LOForEach forEach) throws VisitorException {
        this.evaluateOperator(forEach);
    }

    @Override
    protected void visit(LOLoad load) throws VisitorException {
        this.derivedData.put(load, this.baseData.get(load));
        Collection<IdentityHashSet<Tuple>> eq = EquivalenceClasses.getEquivalenceClasses(load, this.derivedData);
        this.EqClasses.addAll(eq);
        this.OpToEqClasses.put(load, eq);
        Iterator<Tuple> it = this.derivedData.get(load).iterator();
        while (it.hasNext()) {
            this.lineage.insert(it.next());
        }
    }

    @Override
    protected void visit(LOSplit split) throws VisitorException {
        this.evaluateOperator(split);
    }

    @Override
    protected void visit(LOStore store) throws VisitorException {
        this.derivedData.put(store, this.derivedData.get(store.getPlan().getPredecessors(store).get(0)));
    }

    @Override
    protected void visit(LOUnion u) throws VisitorException {
        this.evaluateOperator(u);
    }

    @Override
    protected void visit(LOLimit l) throws VisitorException {
        this.evaluateOperator(l);
    }

    @Override
    protected void visit(LOSort sort) throws VisitorException {
        this.evaluateOperator(sort);
    }

    private void evaluateOperator(LogicalOperator op) {
        PhysicalOperator physOp = this.LogToPhyMap.get(op);
        Random r = new Random();
        List<PhysicalOperator> inputs = physOp.getInputs();
        physOp.setInputs(null);
        physOp.setLineageTracer(this.lineage);
        PhysicalPlan phy = new PhysicalPlan();
        phy.add(physOp);
        for (LogicalOperator l : op.getPlan().getPredecessors(op)) {
            DataBag bag = this.derivedData.get(l);
            PORead por = new PORead(new OperatorKey("", r.nextLong()), bag);
            phy.add(por);
            try {
                phy.connect(por, physOp);
            }
            catch (PlanException e) {
                e.printStackTrace();
                this.log.error((Object)("Error connecting " + por.name() + " to " + physOp.name()));
            }
        }
        DataBag output = BagFactory.getInstance().newDefaultBag();
        Tuple t = null;
        try {
            Result res = physOp.getNext(t);
            while (res.returnStatus != 3) {
                output.add((Tuple)res.result);
                res = physOp.getNext(t);
            }
        }
        catch (ExecException e) {
            this.log.error((Object)("Error evaluating operator : " + physOp.name()));
        }
        this.derivedData.put(op, output);
        try {
            Collection<IdentityHashSet<Tuple>> eq = EquivalenceClasses.getEquivalenceClasses(op, this.derivedData);
            this.EqClasses.addAll(eq);
            this.OpToEqClasses.put(op, eq);
        }
        catch (ExecException e) {
            e.printStackTrace();
            this.log.error((Object)("Error updating equivalence classes while evaluating operators. \n" + e.getMessage()));
        }
        physOp.setInputs(inputs);
        physOp.setLineageTracer(null);
    }

    public DataBag evaluateIsolatedOperator(LOCogroup op, List<DataBag> inputBags) {
        if (op.getPlan().getPredecessors(op).size() > inputBags.size()) {
            return null;
        }
        int count = 0;
        for (LogicalOperator logicalOperator : op.getPlan().getPredecessors(op)) {
            this.derivedData.put(logicalOperator, inputBags.get(count++));
        }
        return this.evaluateIsolatedOperator(op);
    }

    public DataBag evaluateIsolatedOperator(LOCogroup op) {
        for (LogicalOperator logicalOperator : op.getPlan().getPredecessors(op)) {
            if (this.derivedData.get(logicalOperator) != null) continue;
            return null;
        }
        LineageTracer oldLineage = this.lineage;
        this.lineage = new LineageTracer();
        PhysicalOperator physicalOperator = this.LogToPhyMap.get(op);
        Random r = new Random();
        ArrayList<PhysicalOperator> inputs = new ArrayList<PhysicalOperator>();
        PhysicalPlan phy = new PhysicalPlan();
        phy.add(physicalOperator);
        for (PhysicalOperator input : physicalOperator.getInputs()) {
            inputs.add(input.getInputs().get(0));
            input.setInputs(null);
            phy.add(input);
            try {
                phy.connect(input, physicalOperator);
            }
            catch (PlanException e) {
                e.printStackTrace();
                this.log.error((Object)("Error connecting " + input.name() + " to " + physicalOperator.name()));
            }
        }
        physicalOperator.setLineageTracer(this.lineage);
        physicalOperator.setLineageTracer(null);
        for (int i = 0; i < inputs.size(); ++i) {
            DataBag bag = this.derivedData.get(op.getInputs().get(i));
            PORead por = new PORead(new OperatorKey("", r.nextLong()), bag);
            phy.add(por);
            try {
                phy.connect(por, physicalOperator.getInputs().get(i));
                continue;
            }
            catch (PlanException e) {
                e.printStackTrace();
                this.log.error((Object)("Error connecting " + por.name() + " to " + physicalOperator.name()));
            }
        }
        DataBag output = BagFactory.getInstance().newDefaultBag();
        Tuple t = null;
        try {
            Result res = physicalOperator.getNext(t);
            while (res.returnStatus != 3) {
                output.add((Tuple)res.result);
                res = physicalOperator.getNext(t);
            }
        }
        catch (ExecException e) {
            this.log.error((Object)("Error evaluating operator : " + physicalOperator.name()));
        }
        this.lineage = oldLineage;
        physicalOperator.setInputs(inputs);
        physicalOperator.setLineageTracer(null);
        return output;
    }
}

