/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.pen.DerivedDataVisitor;
import org.apache.pig.pen.util.LineageTracer;
import org.apache.pig.pen.util.MetricEvaluation;
import org.apache.pig.pen.util.PreOrderDepthFirstWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineageTrimmingVisitor
extends LOVisitor {
    LogicalPlan plan = null;
    Map<LOLoad, DataBag> baseData = new HashMap<LOLoad, DataBag>();
    Map<LogicalOperator, PhysicalOperator> LogToPhyMap = null;
    PhysicalPlan physPlan = null;
    double completeness = 100.0;
    Log log = LogFactory.getLog(this.getClass());
    Map<LogicalOperator, Map<IdentityHashSet<Tuple>, Integer>> AffinityGroups = new HashMap<LogicalOperator, Map<IdentityHashSet<Tuple>, Integer>>();
    Map<LogicalOperator, LineageTracer> Lineage = new HashMap<LogicalOperator, LineageTracer>();
    boolean continueTrimming;
    PigContext pc;

    public LineageTrimmingVisitor(LogicalPlan plan, Map<LOLoad, DataBag> baseData, Map<LogicalOperator, PhysicalOperator> LogToPhyMap, PhysicalPlan physPlan, PigContext pc) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new PreOrderDepthFirstWalker<LogicalOperator, LogicalPlan>(plan));
        this.baseData = baseData;
        this.plan = plan;
        this.LogToPhyMap = LogToPhyMap;
        this.pc = pc;
        this.physPlan = physPlan;
        this.init();
    }

    public void init() {
        DerivedDataVisitor visitor = new DerivedDataVisitor(this.plan, this.pc, this.baseData, this.LogToPhyMap, this.physPlan);
        try {
            visitor.visit();
        }
        catch (VisitorException e) {
            this.log.error((Object)e.getMessage());
        }
        LineageTracer lineage = visitor.lineage;
        this.Lineage.put((LogicalOperator)this.plan.getLeaves().get(0), lineage);
        Map<LogicalOperator, Collection<IdentityHashSet<Tuple>>> OpToEqClasses = visitor.OpToEqClasses;
        Collection<IdentityHashSet<Tuple>> EqClasses = visitor.EqClasses;
        HashMap<IdentityHashSet<Tuple>, Integer> affinityGroup = new HashMap<IdentityHashSet<Tuple>, Integer>();
        for (IdentityHashSet<Tuple> set : EqClasses) {
            affinityGroup.put(set, 1);
        }
        this.AffinityGroups.put((LogicalOperator)this.plan.getLeaves().get(0), (Map<IdentityHashSet<Tuple>, Integer>)affinityGroup);
        this.completeness = MetricEvaluation.getCompleteness(null, visitor.derivedData, OpToEqClasses, true);
        this.LogToPhyMap = visitor.LogToPhyMap;
        this.continueTrimming = true;
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
        if (this.continueTrimming) {
            HashMap affinityGroups = null;
            this.continueTrimming = this.checkCompleteness(cg);
            DerivedDataVisitor visitor = null;
            LineageTracer lineage = null;
            if (cg.getInputs().size() == 1) {
                affinityGroups = new HashMap();
                LogicalOperator childOp = cg.getInputs().get(0);
                visitor = new DerivedDataVisitor(childOp, null, this.baseData, this.LogToPhyMap, this.physPlan);
                try {
                    visitor.visit();
                }
                catch (VisitorException e) {
                    this.log.error((Object)e.getMessage());
                }
                lineage = visitor.lineage;
                DataBag bag = visitor.evaluateIsolatedOperator(cg);
                Iterator<Tuple> it = bag.iterator();
                while (it.hasNext()) {
                    DataBag field;
                    try {
                        field = (DataBag)it.next().get(1);
                    }
                    catch (ExecException e) {
                        e.printStackTrace();
                        this.log.error((Object)e.getMessage());
                        throw new VisitorException("Error trimming operator COGROUP operator " + cg.getAlias() + "in example generator");
                    }
                    IdentityHashSet<Tuple> set = new IdentityHashSet<Tuple>();
                    affinityGroups.put(set, 2);
                    Iterator<Tuple> it1 = field.iterator();
                    while (it1.hasNext()) {
                        set.add(it1.next());
                    }
                }
                for (IdentityHashSet<Tuple> set : visitor.EqClasses) {
                    affinityGroups.put(set, 1);
                }
                this.AffinityGroups.put(cg.getInputs().get(0), affinityGroups);
                this.Lineage.put(cg.getInputs().get(0), lineage);
            } else {
                LinkedList<DataBag> inputs = new LinkedList<DataBag>();
                visitor = new DerivedDataVisitor(cg, null, this.baseData, this.LogToPhyMap, this.physPlan);
                affinityGroups = new HashMap();
                for (int i = 0; i < cg.getInputs().size(); ++i) {
                    LogicalOperator childOp = cg.getInputs().get(i);
                    visitor.setOperatorToEvaluate(childOp);
                    try {
                        visitor.visit();
                    }
                    catch (VisitorException e) {
                        this.log.error((Object)e.getMessage());
                    }
                    inputs.add(visitor.derivedData.get(childOp));
                    for (IdentityHashSet<Tuple> set : visitor.EqClasses) {
                        affinityGroups.put(set, 1);
                    }
                }
                for (LogicalOperator input : cg.getInputs()) {
                    this.Lineage.put(input, visitor.lineage);
                    this.AffinityGroups.put(input, affinityGroups);
                }
                visitor = new DerivedDataVisitor(cg, null, this.baseData, this.LogToPhyMap, this.physPlan);
                DataBag output = visitor.evaluateIsolatedOperator(cg, inputs);
                for (int i = 1; i <= cg.getInputs().size(); ++i) {
                    affinityGroups = new HashMap();
                    Iterator<Tuple> it = output.iterator();
                    while (it.hasNext()) {
                        DataBag bag = null;
                        try {
                            bag = (DataBag)it.next().get(i);
                        }
                        catch (ExecException e) {
                            this.log.error((Object)e.getMessage());
                        }
                        IdentityHashSet<Tuple> set = new IdentityHashSet<Tuple>();
                        affinityGroups.put(set, 1);
                        Iterator<Tuple> it1 = bag.iterator();
                        while (it1.hasNext()) {
                            set.add(it1.next());
                        }
                    }
                    this.AffinityGroups.get(cg.getInputs().get(i - 1)).putAll(affinityGroups);
                }
                this.AffinityGroups = this.AffinityGroups;
            }
        }
    }

    @Override
    protected void visit(LOCross cs) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(cs);
        }
    }

    @Override
    protected void visit(LODistinct dt) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(dt);
        }
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(filter);
        }
    }

    @Override
    protected void visit(LOForEach forEach) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(forEach);
        }
    }

    @Override
    protected void visit(LOLimit limOp) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(limOp);
        }
    }

    @Override
    protected void visit(LOLoad load) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(load);
        }
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(s);
        }
    }

    @Override
    protected void visit(LOSplit split) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(split);
        }
    }

    @Override
    protected void visit(LOUnion u) throws VisitorException {
        if (this.continueTrimming) {
            this.processOperator(u);
        }
    }

    private Map<LOLoad, DataBag> PruneBaseDataConstrainedCoverage(Map<LOLoad, DataBag> baseData, DataBag rootOutput, LineageTracer lineage, Map<IdentityHashSet<Tuple>, Integer> equivalenceClasses) {
        IdentityHashMap<Tuple, Collection<Tuple>> membershipMap = lineage.getMembershipMap();
        IdentityHashMap<Tuple, Double> lineageGroupWeights = lineage.getWeightedCounts(2.0f, 1.0f);
        IdentityHashMap<Tuple, HashSet<IdentityHashSet<Tuple>>> lineageGroupToEquivClasses = new IdentityHashMap<Tuple, HashSet<IdentityHashSet<Tuple>>>();
        int equivClassId = 0;
        for (IdentityHashSet<Tuple> equivClass : equivalenceClasses.keySet()) {
            for (Tuple t : equivClass) {
                Tuple lineageGroup = lineage.getRepresentative(t);
                HashSet<IdentityHashSet<Tuple>> entry = (HashSet<IdentityHashSet<Tuple>>)lineageGroupToEquivClasses.get(lineageGroup);
                if (entry == null) {
                    entry = new HashSet<IdentityHashSet<Tuple>>();
                    lineageGroupToEquivClasses.put(lineageGroup, entry);
                }
                entry.add(equivClass);
            }
            ++equivClassId;
        }
        IdentityHashSet<Tuple> selectedLineageGroups = new IdentityHashSet<Tuple>();
        while (!lineageGroupToEquivClasses.isEmpty()) {
            double bestScore = -1.0;
            Tuple bestLineageGroup = null;
            Set bestEquivClassesCovered = null;
            for (Tuple lineageGroup : lineageGroupToEquivClasses.keySet()) {
                double weight = lineageGroupWeights.get(lineageGroup);
                Set equivClassesCovered = (Set)lineageGroupToEquivClasses.get(lineageGroup);
                int numEquivClassesCovered = equivClassesCovered.size();
                double score = (double)numEquivClassesCovered / weight;
                if (!(score > bestScore)) continue;
                if (selectedLineageGroups.contains(lineageGroup)) {
                    bestLineageGroup = lineageGroup;
                    bestEquivClassesCovered = equivClassesCovered;
                    continue;
                }
                bestScore = score;
                bestLineageGroup = lineageGroup;
                bestEquivClassesCovered = equivClassesCovered;
            }
            selectedLineageGroups.add(bestLineageGroup);
            HashSet toCopy = bestEquivClassesCovered;
            bestEquivClassesCovered = new HashSet();
            bestEquivClassesCovered.addAll(toCopy);
            LinkedList<Tuple> toRemove = new LinkedList<Tuple>();
            for (Tuple lineageGroup : lineageGroupToEquivClasses.keySet()) {
                Set equivClasses = (Set)lineageGroupToEquivClasses.get(lineageGroup);
                Iterator it = equivClasses.iterator();
                while (it.hasNext()) {
                    IdentityHashSet equivClass = (IdentityHashSet)it.next();
                    if (!bestEquivClassesCovered.contains(equivClass) || equivalenceClasses.get(equivClass) - 1 > 0) continue;
                    it.remove();
                }
                if (equivClasses.size() != 0) continue;
                toRemove.add(lineageGroup);
            }
            for (Tuple removeMe : toRemove) {
                lineageGroupToEquivClasses.remove(removeMe);
            }
            for (IdentityHashSet equivClass : bestEquivClassesCovered) {
                equivalenceClasses.put(equivClass, equivalenceClasses.get(equivClass) - 1);
            }
        }
        IdentityHashSet<Tuple> tuplesToRetain = new IdentityHashSet<Tuple>();
        for (Tuple lineageGroup : selectedLineageGroups) {
            Collection<Tuple> members = membershipMap.get(lineageGroup);
            for (Tuple t : members) {
                tuplesToRetain.add(t);
            }
        }
        HashMap<LOLoad, DataBag> newBaseData = new HashMap<LOLoad, DataBag>();
        for (LOLoad loadOp : baseData.keySet()) {
            DataBag data = baseData.get(loadOp);
            DataBag newData = BagFactory.getInstance().newDefaultBag();
            for (Tuple t : data) {
                if (!tuplesToRetain.contains(t)) continue;
                newData.add(t);
            }
            newBaseData.put(loadOp, newData);
        }
        return newBaseData;
    }

    private void processOperator(LogicalOperator op) {
        if (op instanceof LOLoad) {
            return;
        }
        this.continueTrimming = this.checkCompleteness(op);
        if (!this.continueTrimming) {
            return;
        }
        LogicalOperator childOp = this.plan.getPredecessors(op).get(0);
        DerivedDataVisitor visitor = new DerivedDataVisitor(childOp, null, this.baseData, this.LogToPhyMap, this.physPlan);
        try {
            visitor.visit();
        }
        catch (VisitorException e) {
            this.log.error((Object)e.getMessage());
        }
        DataBag bag = visitor.derivedData.get(childOp);
        HashMap affinityGroups = new HashMap();
        Iterator<Tuple> it = bag.iterator();
        while (it.hasNext()) {
            IdentityHashSet<Tuple> set = new IdentityHashSet<Tuple>();
            affinityGroups.put(set, 1);
            set.add(it.next());
        }
        for (IdentityHashSet<Tuple> set : visitor.EqClasses) {
            affinityGroups.put(set, 1);
        }
        this.AffinityGroups.put(childOp, affinityGroups);
        this.Lineage.put(childOp, visitor.lineage);
    }

    private boolean checkCompleteness(LogicalOperator op) {
        LineageTracer lineage = this.Lineage.get(op);
        this.Lineage.remove(op);
        Map<IdentityHashSet<Tuple>, Integer> affinityGroups = this.AffinityGroups.get(op);
        this.AffinityGroups.remove(op);
        Map<LOLoad, DataBag> newBaseData = this.PruneBaseDataConstrainedCoverage(this.baseData, null, lineage, affinityGroups);
        DerivedDataVisitor visitor = new DerivedDataVisitor(this.plan, null, newBaseData, this.LogToPhyMap, this.physPlan);
        try {
            visitor.visit();
        }
        catch (VisitorException e) {
            this.log.error((Object)e.getMessage());
        }
        double newCompleteness = MetricEvaluation.getCompleteness(null, visitor.derivedData, visitor.OpToEqClasses, true);
        if (newCompleteness >= this.completeness) {
            this.completeness = newCompleteness;
            this.baseData.putAll(newBaseData);
        } else {
            this.continueTrimming = false;
        }
        return this.continueTrimming;
    }
}

