/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers.gen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jmi.model.MultiplicityType;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public class ContentsFinder {
    private final HashMap snameToObject = new HashMap();
    private final Class superClass;
    private final String substName;
    private final boolean derived;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static String firstUpper(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() < 2) {
            return text.toUpperCase(Locale.US);
        }
        return String.valueOf(text.substring(0, 1).toUpperCase(Locale.US)) + text.substring(1);
    }

    private void retrieveContents(StorableBaseObject storable, StorableObject meta) throws Exception {
        StorableObject element;
        List contents = (List)meta.getReference("contents");
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            element = (StorableObject)it.next();
            String substName = TagSupport.getSubstName(element);
            this.snameToObject.put(ContentsFinder.firstUpper(substName), new ElementDescriptor(storable, element));
        }
        List supertypes = (List)meta.getReference("supertypes");
        Iterator it2 = supertypes.iterator();
        while (it2.hasNext()) {
            element = (StorableObject)it2.next();
            this.retrieveContents(storable, element);
        }
    }

    public ContentsFinder(StorableBaseObject storable) {
        try {
            boolean derived = false;
            StorableObject meta = storable.getMetaObject();
            this.retrieveContents(storable, meta);
            this.substName = TagSupport.getSubstName(meta);
            if (storable instanceof StorableAssociation) {
                derived = (Boolean)meta.getAttribute("isDerived");
                Class temp = null;
                if (derived) {
                    try {
                        temp = BaseObjectHandler.resolveImplementation(TagSupport.getImplFullName(meta, 0));
                    }
                    catch (ClassNotFoundException e) {
                        temp = null;
                    }
                }
                if (temp == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.netbeans.mdr.handlers.AssociationHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    temp = clazz;
                }
                this.superClass = temp;
            } else if (storable instanceof StorablePackage) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.netbeans.mdr.handlers.PackageProxyHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.superClass = clazz;
            } else {
                this.superClass = storable instanceof StorableObject ? ((StorableObject)storable).getClassProxy().getInstanceSuperclass() : (storable instanceof StorableClass ? ((StorableClass)storable).getClassSuperclass() : null);
            }
            this.derived = derived;
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    public Class getHandlerClass() {
        return this.superClass;
    }

    public String getSubstName() {
        return this.substName;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public ElementDescriptor lookup(String substName) {
        return (ElementDescriptor)this.snameToObject.get(ContentsFinder.firstUpper(substName));
    }

    public class ElementDescriptor {
        public static final int ATTRIBUTE = 1;
        public static final int REFERENCE = 2;
        public static final int OPERATION = 4;
        public static final int CLASS = 8;
        public static final int PACKAGE = 16;
        public static final int ASSOCIATION = 32;
        public static final int DATATYPE = 64;
        public static final int ASSOCIATION_END = 128;
        public static final int IMPORT = 256;
        private final String name;
        private final int type;
        private final boolean multivalued;
        private final boolean ordered;
        private final boolean writable;
        private final boolean derived;
        private final int index;

        private ElementDescriptor(StorableBaseObject parent, StorableObject storable) {
            try {
                this.name = (String)storable.getAttribute("name");
                String typeName = (String)storable.getMetaObject().getAttribute("name");
                boolean multivalued = false;
                boolean ordered = false;
                boolean writable = false;
                boolean derived = false;
                int index = 0;
                if (typeName.equals("Attribute") || typeName.equals("Reference")) {
                    MultiplicityType multiplicity = (MultiplicityType)storable.getAttribute("multiplicity");
                    multivalued = multiplicity.getUpper() != 1 || multiplicity.getLower() != 1;
                    ordered = multiplicity.isOrdered() && multivalued;
                    writable = (Boolean)storable.getAttribute("isChangeable");
                    if (typeName.equals("Reference")) {
                        this.type = 2;
                    } else {
                        this.type = 1;
                        derived = (Boolean)storable.getAttribute("isDerived");
                        if (!derived) {
                            index = ((StorableFeatured)parent).getClassProxy().getAttrIndex(this.name);
                        }
                    }
                } else if (typeName.equals("Operation")) {
                    this.type = 4;
                    derived = true;
                } else {
                    this.type = typeName.equals("Class") ? 8 : (typeName.equals("Package") ? 16 : (typeName.equals("Association") ? 32 : (typeName.equals("EnumerationType") || typeName.equals("StructureType") ? 64 : (typeName.equals("AssociationEnd") ? 128 : (typeName.equals("Import") ? 256 : 0)))));
                }
                this.multivalued = multivalued;
                this.ordered = ordered;
                this.writable = writable;
                this.derived = derived;
                this.index = index;
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isOfType(int type) {
            return (this.type & type) != 0;
        }

        public boolean isMultivalued() {
            return this.multivalued;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        public boolean canModify() {
            return this.writable;
        }

        public boolean isDerived() {
            return this.derived;
        }
    }
}

