/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ComposedLazyList
extends AbstractList {
    private final List lists = new ArrayList();
    private int elementCount = 0;

    public ComposedLazyList() {
    }

    public ComposedLazyList(Collection col) {
        this();
        this.addAll(col);
    }

    public boolean addAll(Collection col) {
        List result = col instanceof List ? (List)col : new ArrayList(col);
        ++this.modCount;
        this.elementCount += result.size();
        return this.lists.add(result);
    }

    public int size() {
        return this.elementCount;
    }

    public Object get(int index) {
        int listUBound = 0;
        int listLBound = 0;
        List currentList = null;
        Iterator it = this.lists.iterator();
        while (it.hasNext() && listUBound <= index) {
            currentList = (List)it.next();
            listLBound = listUBound;
            listUBound += currentList.size();
        }
        return currentList.get(index - listLBound);
    }

    public Iterator iterator() {
        return new LazyIterator();
    }

    private class LazyIterator
    implements Iterator {
        Iterator listIterator;
        Iterator currentIterator;

        private LazyIterator() {
            this.listIterator = ComposedLazyList.this.lists.iterator();
            this.currentIterator = null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            this.hasNext();
            return this.currentIterator.next();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean hasNext() {
            if (this.currentIterator == null) {
                if (!this.listIterator.hasNext()) {
                    return false;
                }
                this.currentIterator = ((List)this.listIterator.next()).iterator();
            }
            while (!this.currentIterator.hasNext()) {
                if (!this.listIterator.hasNext()) {
                    return false;
                }
                this.currentIterator = ((List)this.listIterator.next()).iterator();
            }
            return true;
        }
    }
}

