/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.spark;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.spark.PatternMatchingStreamLogger;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(image="org/pentaho/di/ui/job/entries/spark/img/spark.svg", id="SparkSubmit", name="JobEntrySparkSubmit.Title", description="JobEntrySparkSubmit.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.spark", documentationUrl="http://wiki.pentaho.com/display/EAI/Spark+Submit")
public class JobEntrySparkSubmit
extends JobEntryBase
implements Cloneable,
JobEntryInterface,
JobEntryListener {
    private static Class<?> PKG = JobEntrySparkSubmit.class;
    private String scriptPath;
    private String master = "yarn-cluster";
    private List<String> configParams = new ArrayList<String>();
    private String jar;
    private String className;
    private String args;
    private boolean blockExecution = true;
    private String executorMemory;
    private String driverMemory;
    protected Process proc;

    public JobEntrySparkSubmit(String n) {
        super(n, "");
    }

    public JobEntrySparkSubmit() {
        this("");
    }

    public Object clone() {
        JobEntrySparkSubmit je = (JobEntrySparkSubmit)super.clone();
        return je;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"scriptPath", (String)this.scriptPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"master", (String)this.master));
        retval.append("      ").append(XMLHandler.addTagValue((String)"jar", (String)this.jar));
        retval.append("      ").append(XMLHandler.addTagValue((String)"className", (String)this.className));
        retval.append("      ").append(XMLHandler.addTagValue((String)"args", (String)this.args));
        retval.append("      ").append(XMLHandler.openTag((String)"configParams")).append(Const.CR);
        for (String param : this.configParams) {
            retval.append("            ").append(XMLHandler.addTagValue((String)"param", (String)param));
        }
        retval.append("      ").append(XMLHandler.closeTag((String)"configParams")).append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"driverMemory", (String)this.driverMemory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"executorMemory", (String)this.executorMemory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blockExecution", (boolean)this.blockExecution));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.scriptPath = XMLHandler.getTagValue((Node)entrynode, (String)"scriptPath");
            this.master = XMLHandler.getTagValue((Node)entrynode, (String)"master");
            this.jar = XMLHandler.getTagValue((Node)entrynode, (String)"jar");
            this.className = XMLHandler.getTagValue((Node)entrynode, (String)"className");
            this.args = XMLHandler.getTagValue((Node)entrynode, (String)"args");
            Node configParamsNode = XMLHandler.getSubNode((Node)entrynode, (String)"configParams");
            List paramNodes = XMLHandler.getNodes((Node)configParamsNode, (String)"param");
            for (Node paramNode : paramNodes) {
                this.configParams.add(paramNode.getTextContent());
            }
            this.driverMemory = XMLHandler.getTagValue((Node)entrynode, (String)"driverMemory");
            this.executorMemory = XMLHandler.getTagValue((Node)entrynode, (String)"executorMemory");
            this.blockExecution = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blockExecution"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'SparkSubmit' from XML node", (Throwable)xe);
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.scriptPath = rep.getJobEntryAttributeString(id_jobentry, "scriptPath");
            this.master = rep.getJobEntryAttributeString(id_jobentry, "master");
            this.jar = rep.getJobEntryAttributeString(id_jobentry, "jar");
            this.className = rep.getJobEntryAttributeString(id_jobentry, "className");
            this.args = rep.getJobEntryAttributeString(id_jobentry, "args");
            for (int i = 0; i < rep.countNrJobEntryAttributes(id_jobentry, "param"); ++i) {
                this.configParams.add(rep.getJobEntryAttributeString(id_jobentry, i, "param"));
            }
            this.driverMemory = rep.getJobEntryAttributeString(id_jobentry, "driverMemory");
            this.executorMemory = rep.getJobEntryAttributeString(id_jobentry, "executorMemory");
            this.blockExecution = rep.getJobEntryAttributeBoolean(id_jobentry, "blockExecution");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'SparkSubmit' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "scriptPath", this.scriptPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "master", this.master);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "jar", this.jar);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "className", this.className);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "args", this.args);
            for (int i = 0; i < this.configParams.size(); ++i) {
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "param", this.configParams.get(i));
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "driverMemory", this.driverMemory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "executorMemory", this.executorMemory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blockExecution", this.blockExecution);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'SparkSubmit' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getMaster() {
        return this.master;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public List<String> getConfigParams() {
        return this.configParams;
    }

    public void setConfigParams(List<String> configParams) {
        this.configParams = configParams;
    }

    public String getJar() {
        return this.jar;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getExecutorMemory() {
        return this.executorMemory;
    }

    public void setExecutorMemory(String executorMemory) {
        this.executorMemory = executorMemory;
    }

    public String getDriverMemory() {
        return this.driverMemory;
    }

    public void setDriverMemory(String driverMemory) {
        this.driverMemory = driverMemory;
    }

    public boolean isBlockExecution() {
        return this.blockExecution;
    }

    public void setBlockExecution(boolean blockExecution) {
        this.blockExecution = blockExecution;
    }

    public List<String> getCmds() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.environmentSubstitute(this.scriptPath));
        cmds.add("--master");
        cmds.add(this.environmentSubstitute(this.master));
        if (!Const.isEmpty((String)this.className)) {
            cmds.add("--class");
            cmds.add(this.environmentSubstitute(this.className));
        }
        for (String confParam : this.configParams) {
            cmds.add("--conf");
            cmds.add(this.environmentSubstitute(confParam));
        }
        if (!Const.isEmpty((String)this.driverMemory)) {
            cmds.add("--driver-memory");
            cmds.add(this.environmentSubstitute(this.driverMemory));
        }
        if (!Const.isEmpty((String)this.executorMemory)) {
            cmds.add("--executor-memory");
            cmds.add(this.environmentSubstitute(this.executorMemory));
        }
        cmds.add(this.jar);
        if (!Const.isEmpty((String)this.args)) {
            String[] argArray;
            for (String anArgArray : argArray = this.environmentSubstitute(this.args).split(" ")) {
                if (Const.isEmpty((String)anArgArray)) continue;
                cmds.add(anArgArray);
            }
        }
        return cmds;
    }

    @VisibleForTesting
    protected boolean validate() {
        boolean valid = true;
        if (Const.isEmpty((String)this.scriptPath) || !new File(this.environmentSubstitute(this.scriptPath)).exists()) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Error.SparkSubmitPathInvalid", (String[])new String[0]));
            valid = false;
        }
        if (Const.isEmpty((String)this.master)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Error.MasterURLEmpty", (String[])new String[0]));
            valid = false;
        }
        if (Const.isEmpty((String)this.jar)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Error.JarPathEmpty", (String[])new String[0]));
            valid = false;
        }
        return valid;
    }

    public Result execute(Result result, int nr) {
        if (!this.validate()) {
            result.setResult(false);
            return result;
        }
        List<String> cmds = this.getCmds();
        this.logBasic("Submitting Spark Script");
        if (this.log.isDetailed()) {
            this.logDetailed(cmds.toString());
        }
        try {
            String[] variables;
            ProcessBuilder procBuilder = new ProcessBuilder(cmds);
            Map<String, String> env = procBuilder.environment();
            for (String variable : variables = this.listVariables()) {
                env.put(variable, this.getVariable(variable));
            }
            this.proc = procBuilder.start();
            String[] jobSubmittedPatterns = new String[]{"tracking URL:"};
            final AtomicBoolean jobSubmitted = new AtomicBoolean(false);
            PatternMatchingStreamLogger errorLogger = new PatternMatchingStreamLogger(this.log, this.proc.getErrorStream(), jobSubmittedPatterns, jobSubmitted);
            PatternMatchingStreamLogger outputLogger = new PatternMatchingStreamLogger(this.log, this.proc.getInputStream(), jobSubmittedPatterns, jobSubmitted);
            if (!this.blockExecution) {
                PatternMatchingStreamLogger.PatternMatchedListener cb = new PatternMatchingStreamLogger.PatternMatchedListener(){

                    @Override
                    public void onPatternFound(String pattern) {
                        JobEntrySparkSubmit.this.log.logDebug("Found match in output, considering job submitted, stopping spark-submit");
                        jobSubmitted.set(true);
                        JobEntrySparkSubmit.this.proc.destroy();
                    }
                };
                errorLogger.addPatternMatchedListener(cb);
                outputLogger.addPatternMatchedListener(cb);
            }
            Thread errorLoggerThread = new Thread(errorLogger);
            errorLoggerThread.start();
            Thread outputLoggerThread = new Thread(outputLogger);
            outputLoggerThread.start();
            final AtomicBoolean processFinished = new AtomicBoolean(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!JobEntrySparkSubmit.this.getParentJob().isStopped() && !processFinished.get()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    JobEntrySparkSubmit.this.proc.destroy();
                }
            }).start();
            this.proc.waitFor();
            processFinished.set(true);
            if (this.log.isDetailed()) {
                this.logDetailed("Spark submit finished");
            }
            errorLoggerThread.join();
            outputLoggerThread.join();
            this.proc.getErrorStream().close();
            this.proc.getOutputStream().close();
            int exitCode = this.blockExecution ? this.proc.exitValue() : (jobSubmitted.get() ? 0 : this.proc.exitValue());
            result.setExitStatus(exitCode);
            if (exitCode != 0) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.ExitStatus", (Object[])new Object[]{result.getExitStatus()}));
                }
                result.setNrErrors(1L);
            }
            result.setResult(exitCode == 0);
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Error.SubmittingScript", (String[])new String[]{e.getMessage()}));
            this.logError(Const.getStackTracker((Throwable)e));
            result.setResult(false);
        }
        return result;
    }

    public boolean evaluates() {
        return true;
    }

    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate((CheckResultSourceInterface)this, "scriptPath", remarks, AndValidator.putValidators((JobEntryValidator[])new JobEntryValidator[]{JobEntryValidatorUtils.notBlankValidator()}));
        JobEntryValidatorUtils.andValidator().validate((CheckResultSourceInterface)this, "scriptPath", remarks, AndValidator.putValidators((JobEntryValidator[])new JobEntryValidator[]{JobEntryValidatorUtils.fileExistsValidator()}));
        JobEntryValidatorUtils.andValidator().validate((CheckResultSourceInterface)this, "master", remarks, AndValidator.putValidators((JobEntryValidator[])new JobEntryValidator[]{JobEntryValidatorUtils.notBlankValidator()}));
        JobEntryValidatorUtils.andValidator().validate((CheckResultSourceInterface)this, "jar", remarks, AndValidator.putValidators((JobEntryValidator[])new JobEntryValidator[]{JobEntryValidatorUtils.notBlankValidator()}));
        JobEntryValidatorUtils.andValidator().validate((CheckResultSourceInterface)this, "className", remarks, AndValidator.putValidators((JobEntryValidator[])new JobEntryValidator[]{JobEntryValidatorUtils.notBlankValidator()}));
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntrySparkSubmit().check(remarks, null, (VariableSpace)new Variables(), null, null);
        System.out.printf("Remarks: %s\n", remarks);
    }

    public void afterExecution(Job arg0, JobEntryCopy arg1, JobEntryInterface arg2, Result arg3) {
        this.proc.destroy();
    }

    public void beforeExecution(Job arg0, JobEntryCopy arg1, JobEntryInterface arg2) {
    }
}

