/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.market.place;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.market.Market;
import org.pentaho.di.core.market.place.Marketplace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Marketplaces
extends ArrayList<Marketplace> {
    private static Class<?> MARKET_PKG = Market.class;
    private static final long serialVersionUID = 5561589064643143850L;

    public Marketplaces() {
        String marketplacesFile = Market.getMarketplacesFile();
        try {
            File file = new File(marketplacesFile);
            if (file.exists()) {
                Document doc = XMLHandler.loadXMLFile((String)marketplacesFile);
                Node placesNode = XMLHandler.getSubNode((Node)doc, (String)"marketplaces");
                List nodes = XMLHandler.getNodes((Node)placesNode, (String)Marketplace.XML_TAG);
                for (Node node : nodes) {
                    this.add(new Marketplace(node));
                }
            } else {
                this.addAll(Marketplace.getDefaultMarketplaces());
            }
        }
        catch (KettleXMLException kxe) {
            new ErrorDialog(Spoon.getInstance().getShell(), BaseMessages.getString(MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString(MARKET_PKG, (String)"Marketplaces.xmlerror.message", (String[])new String[]{marketplacesFile}), (Exception)((Object)kxe));
        }
    }
}

