/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.IgnoreTransitionXCommand;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsIgnoreXCommand
extends IgnoreTransitionXCommand<CoordinatorActionInfo> {
    CoordinatorJobBean coordJob;
    String jobId;
    String type;
    String scope;
    private List<CoordinatorActionBean> coordActions;

    public CoordActionsIgnoreXCommand(String coordId, String type, String scope) {
        super("coord_action_ignore", "coord_action_ignore", 1);
        this.jobId = ParamChecker.notEmpty(coordId, "coordJobId");
        this.type = ParamChecker.notEmpty(type, "type");
        this.scope = ParamChecker.notEmpty(scope, "scope");
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordJob.getStatus() == Job.Status.PREP) {
            this.LOG.info("CoordActionsIgnoreXCommand is not able to run, job status=" + this.coordJob.getStatus() + ", jobid=" + this.jobId);
            throw new PreconditionException(ErrorCode.E1024, "No actions are materialized to ignore");
        }
        StringBuilder ineligibleActions = new StringBuilder();
        if (!this.checkAllActionsStatus(ineligibleActions)) {
            throw new CommandException(ErrorCode.E1024, "part or all actions are not eligible to ignore, check state of action number(s) [" + ineligibleActions.toString() + "]");
        }
    }

    @Override
    public void ignoreChildren() throws CommandException {
        for (CoordinatorActionBean action : this.coordActions) {
            action.setStatus(CoordinatorAction.Status.IGNORED);
            action.setLastModifiedTime(new Date());
            action.setPending(0);
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, action));
            this.LOG.info("Ignore coord action = [{0}], new status = [{1}]", action.getId(), action.getStatus());
        }
        this.ret = new CoordinatorActionInfo(this.coordActions);
    }

    private boolean checkAllActionsStatus(StringBuilder ineligibleActions) throws CommandException {
        boolean ret = true;
        if (this.coordActions == null || this.coordActions.size() == 0) {
            throw new CommandException(ErrorCode.E1024, "no actions are eligible to ignore");
        }
        for (CoordinatorActionBean action : this.coordActions) {
            ParamChecker.notNull(action, "Action cannot be null");
            if (action.getStatus() == CoordinatorAction.Status.FAILED || action.getStatus() == CoordinatorAction.Status.KILLED || action.getStatus() == CoordinatorAction.Status.TIMEDOUT) continue;
            this.LOG.info("Cannot ignore coord action = [{0}], since its status is [{1}]", action.getId(), action.getStatus());
            if (ineligibleActions.length() != 0) {
                ineligibleActions.append(",");
            }
            ineligibleActions.append(action.getActionNumber());
            ret = false;
        }
        return ret;
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
        }
        catch (JPAExecutorException jex) {
            throw new CommandException(jex);
        }
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_STATUS_PARENTID, this.jobId);
            this.coordActions = CoordUtils.getCoordActions(this.type, this.jobId, this.scope, false);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
        LogUtils.setLogInfo(this.coordJob, this.logInfo);
    }
}

