/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.event.BundleJobEvent;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.CoordinatorJobEvent;
import org.apache.oozie.event.EventQueue;
import org.apache.oozie.event.MemoryEventQueue;
import org.apache.oozie.event.WorkflowActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.event.listener.JobEventListener;
import org.apache.oozie.jms.JMSJobEventListener;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.listener.SLAEventListener;
import org.apache.oozie.sla.listener.SLAJobEventListener;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XLog;

public class EventHandlerService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.EventHandlerService.";
    public static final String CONF_QUEUE_SIZE = "oozie.service.EventHandlerService.queue.size";
    public static final String CONF_EVENT_QUEUE = "oozie.service.EventHandlerService.event.queue";
    public static final String CONF_LISTENERS = "oozie.service.EventHandlerService.event.listeners";
    public static final String CONF_FILTER_APP_TYPES = "oozie.service.EventHandlerService.filter.app.types";
    public static final String CONF_BATCH_SIZE = "oozie.service.EventHandlerService.batch.size";
    public static final String CONF_WORKER_THREADS = "oozie.service.EventHandlerService.worker.threads";
    public static final String CONF_WORKER_INTERVAL = "oozie.service.EventHandlerService.worker.interval";
    private static EventQueue eventQueue;
    private XLog LOG;
    private Map<Event.MessageType, List<?>> listenerMap = new HashMap();
    private Set<String> apptypes;
    private static boolean eventsEnabled;
    private int numWorkers;

    @Override
    public void init(Services services) throws ServiceException {
        try {
            Configuration conf = services.getConf();
            this.LOG = XLog.getLog(this.getClass());
            this.LOG = XLog.resetPrefix(this.LOG);
            Class queueImpl = conf.getClass(CONF_EVENT_QUEUE, null);
            eventQueue = queueImpl == null ? new MemoryEventQueue() : (EventQueue)queueImpl.newInstance();
            eventQueue.init(conf);
            this.initApptypes(conf);
            this.initEventListeners(conf);
            this.initWorkerThreads(conf, services);
            eventsEnabled = true;
            this.LOG.info("EventHandlerService initialized. Event queue = [{0}], Event listeners configured = [{1}], Events configured for App-types = [{2}], Num Worker Threads = [{3}]", eventQueue.getClass().getName(), this.listenerMap.toString(), this.apptypes, this.numWorkers);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0100, ex.getMessage(), ex);
        }
    }

    private void initApptypes(Configuration conf) {
        this.apptypes = new HashSet<String>();
        for (String jobtype : conf.getStringCollection(CONF_FILTER_APP_TYPES)) {
            String tmp = jobtype.trim().toLowerCase();
            if (tmp.length() == 0) continue;
            this.apptypes.add(tmp);
        }
    }

    private void initEventListeners(Configuration conf) throws Exception {
        Class[] listenerClass = conf.getClasses(CONF_LISTENERS, new Class[]{JMSJobEventListener.class, SLAJobEventListener.class});
        for (int i = 0; i < listenerClass.length; ++i) {
            Object listener = null;
            try {
                listener = listenerClass[i].newInstance();
            }
            catch (InstantiationException e) {
                this.LOG.warn("Could not create event listener instance, " + e);
            }
            catch (IllegalAccessException e) {
                this.LOG.warn("Illegal access to event listener instance, " + e);
            }
            this.addEventListener(listener, conf, listenerClass[i].getName());
        }
    }

    public void addEventListener(Object listener, Configuration conf, String name) throws Exception {
        if (listener instanceof JobEventListener) {
            List<?> listenersList = this.listenerMap.get(Event.MessageType.JOB);
            if (listenersList == null) {
                listenersList = new ArrayList();
                this.listenerMap.put(Event.MessageType.JOB, listenersList);
            }
            listenersList.add(listener);
            ((JobEventListener)listener).init(conf);
        } else if (listener instanceof SLAEventListener) {
            List<?> listenersList = this.listenerMap.get(Event.MessageType.SLA);
            if (listenersList == null) {
                listenersList = new ArrayList();
                this.listenerMap.put(Event.MessageType.SLA, listenersList);
            }
            listenersList.add(listener);
            ((SLAEventListener)listener).init(conf);
        } else {
            this.LOG.warn("Event listener [{0}] is of undefined type", name);
        }
    }

    public static boolean isEnabled() {
        return eventsEnabled;
    }

    private void initWorkerThreads(Configuration conf, Services services) throws ServiceException {
        this.numWorkers = conf.getInt(CONF_WORKER_THREADS, 3);
        int interval = conf.getInt(CONF_WORKER_INTERVAL, 30);
        SchedulerService ss = services.get(SchedulerService.class);
        int available = ss.getSchedulableThreads(conf);
        if (this.numWorkers + 3 > available) {
            throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), "Event worker threads requested [" + this.numWorkers + "] cannot be handled with current settings. Increase " + "oozie.service.SchedulerService.threads");
        }
        EventWorker eventWorker = new EventWorker();
        for (int i = 0; i < this.numWorkers; ++i) {
            ss.schedule(eventWorker, (long)(10 + i * 20), (long)interval, SchedulerService.Unit.SEC);
        }
    }

    @Override
    public void destroy() {
        eventsEnabled = false;
        for (Event.MessageType type : this.listenerMap.keySet()) {
            Iterator<?> iter = this.listenerMap.get(type).iterator();
            while (iter.hasNext()) {
                if (type == Event.MessageType.JOB) {
                    ((JobEventListener)iter.next()).destroy();
                    continue;
                }
                if (type != Event.MessageType.SLA) continue;
                ((SLAEventListener)iter.next()).destroy();
            }
        }
    }

    @Override
    public Class<? extends Service> getInterface() {
        return EventHandlerService.class;
    }

    public boolean isSupportedApptype(String appType) {
        return this.apptypes.contains(appType.toLowerCase());
    }

    public void setAppTypes(Set<String> types) {
        this.apptypes = types;
    }

    public Set<String> getAppTypes() {
        return this.apptypes;
    }

    public String listEventListeners() {
        return this.listenerMap.toString();
    }

    public void queueEvent(Event event) {
        this.LOG = LogUtils.setLogPrefix(this.LOG, event);
        this.LOG.debug("Queueing event : {0}", event);
        this.LOG.trace("Stack trace while queueing event : {0}", event, new Throwable());
        eventQueue.add(event);
        LogUtils.clearLogPrefix();
    }

    public EventQueue getEventQueue() {
        return eventQueue;
    }

    static {
        eventsEnabled = false;
    }

    public class EventWorker
    implements Runnable {
        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                if (!eventQueue.isEmpty()) {
                    List<Event> work = eventQueue.pollBatch();
                    for (Event event : work) {
                        EventHandlerService.this.LOG = LogUtils.setLogPrefix(EventHandlerService.this.LOG, event);
                        EventHandlerService.this.LOG.debug("Processing event : {0}", event);
                        Event.MessageType msgType = event.getMsgType();
                        List listeners = (List)EventHandlerService.this.listenerMap.get(msgType);
                        if (listeners == null) continue;
                        Iterator iter = listeners.iterator();
                        while (iter.hasNext()) {
                            try {
                                if (msgType == Event.MessageType.JOB) {
                                    this.invokeJobEventListener((JobEventListener)iter.next(), (JobEvent)event);
                                    continue;
                                }
                                if (msgType == Event.MessageType.SLA) {
                                    this.invokeSLAEventListener((SLAEventListener)iter.next(), (SLAEvent)event);
                                    continue;
                                }
                                iter.next();
                            }
                            catch (Throwable error) {
                                XLog.getLog(EventHandlerService.class).debug((Object)"Throwable in EventWorker thread run : ", error);
                            }
                        }
                    }
                }
            }
            catch (Throwable error) {
                XLog.getLog(EventHandlerService.class).debug((Object)"Throwable in EventWorker thread run : ", error);
            }
        }

        private void invokeJobEventListener(JobEventListener jobListener, JobEvent event) {
            switch (event.getAppType()) {
                case WORKFLOW_JOB: {
                    jobListener.onWorkflowJobEvent((WorkflowJobEvent)event);
                    break;
                }
                case WORKFLOW_ACTION: {
                    jobListener.onWorkflowActionEvent((WorkflowActionEvent)event);
                    break;
                }
                case COORDINATOR_JOB: {
                    jobListener.onCoordinatorJobEvent((CoordinatorJobEvent)event);
                    break;
                }
                case COORDINATOR_ACTION: {
                    jobListener.onCoordinatorActionEvent((CoordinatorActionEvent)event);
                    break;
                }
                case BUNDLE_JOB: {
                    jobListener.onBundleJobEvent((BundleJobEvent)event);
                    break;
                }
                default: {
                    XLog.getLog(EventHandlerService.class).info("Undefined Job Event app-type - {0}", event.getAppType());
                }
            }
        }

        private void invokeSLAEventListener(SLAEventListener slaListener, SLAEvent event) {
            switch (event.getEventStatus()) {
                case START_MET: {
                    slaListener.onStartMet(event);
                    break;
                }
                case START_MISS: {
                    slaListener.onStartMiss(event);
                    break;
                }
                case END_MET: {
                    slaListener.onEndMet(event);
                    break;
                }
                case END_MISS: {
                    slaListener.onEndMiss(event);
                    break;
                }
                case DURATION_MET: {
                    slaListener.onDurationMet(event);
                    break;
                }
                case DURATION_MISS: {
                    slaListener.onDurationMiss(event);
                    break;
                }
                default: {
                    XLog.getLog(EventHandlerService.class).info("Undefined SLA event type - {0}", event.getSLAStatus());
                }
            }
        }
    }
}

