/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ImageAttribute;
import com.amazonaws.services.ec2.model.transform.BlockDeviceMappingStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.LaunchPermissionStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ProductCodeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageAttributeStaxUnmarshaller
implements Unmarshaller<ImageAttribute, StaxUnmarshallerContext> {
    private static ImageAttributeStaxUnmarshaller instance;

    @Override
    public ImageAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        ImageAttribute imageAttribute = new ImageAttribute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return imageAttribute;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("imageId", targetDepth)) {
                    imageAttribute.setImageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("launchPermission/item", targetDepth)) {
                    imageAttribute.getLaunchPermissions().add(LaunchPermissionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("productCodes/item", targetDepth)) {
                    imageAttribute.getProductCodes().add(ProductCodeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("kernel/value", targetDepth)) {
                    imageAttribute.setKernelId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ramdisk/value", targetDepth)) {
                    imageAttribute.setRamdiskId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description/value", targetDepth)) {
                    imageAttribute.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sriovNetSupport/value", targetDepth)) {
                    imageAttribute.setSriovNetSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("blockDeviceMapping/item", targetDepth)) continue;
                imageAttribute.getBlockDeviceMappings().add(BlockDeviceMappingStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return imageAttribute;
    }

    public static ImageAttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ImageAttributeStaxUnmarshaller();
        }
        return instance;
    }
}

