/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class MasterAddressTracker
extends ZooKeeperNodeTracker {
    public MasterAddressTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.masterAddressZNode, abortable);
    }

    public HServerAddress getMasterAddress() {
        byte[] data = super.getData();
        return data == null ? null : new HServerAddress(Bytes.toString(data));
    }

    public boolean hasMaster() {
        return super.getData() != null;
    }

    public synchronized HServerAddress waitForMaster(long timeout) throws InterruptedException {
        byte[] data = super.blockUntilAvailable();
        return data == null ? null : new HServerAddress(Bytes.toString(data));
    }
}

