/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Writables;

class CatalogJanitor
extends Chore {
    private static final Log LOG = LogFactory.getLog((String)CatalogJanitor.class.getName());
    private final Server server;
    private final MasterServices services;
    private boolean enabled = true;

    CatalogJanitor(Server server, MasterServices services) {
        super(server.getServerName() + "-CatalogJanitor", server.getConfiguration().getInt("hbase.catalogjanitor.interval", 300000), server);
        this.server = server;
        this.services = services;
    }

    @Override
    protected boolean initialChore() {
        try {
            if (this.enabled) {
                this.scan();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed initial scan of catalog table", (Throwable)e);
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    protected void chore() {
        try {
            this.scan();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed scan of catalog table", (Throwable)e);
        }
    }

    void scan() throws IOException {
        final AtomicInteger count = new AtomicInteger(0);
        final TreeMap splitParents = new TreeMap();
        MetaReader.Visitor visitor = new MetaReader.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                count.incrementAndGet();
                HRegionInfo info = CatalogJanitor.getHRegionInfo(r);
                if (info == null) {
                    return true;
                }
                if (info.isSplitParent()) {
                    splitParents.put(info, r);
                }
                return true;
            }
        };
        MetaReader.fullScan(this.server.getCatalogTracker(), visitor);
        int cleaned = 0;
        for (Map.Entry e : splitParents.entrySet()) {
            if (!this.cleanParent((HRegionInfo)((Object)e.getKey()), (Result)e.getValue())) continue;
            ++cleaned;
        }
        if (cleaned != 0) {
            LOG.info((Object)("Scanned " + count.get() + " catalog row(s) and gc'd " + cleaned + " unreferenced parent region(s)"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scanned " + count.get() + " catalog row(s) and gc'd " + cleaned + " unreferenced parent region(s)"));
        }
    }

    static HRegionInfo getHRegionInfo(Result result) throws IOException {
        byte[] bytes = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            LOG.warn((Object)("REGIONINFO_QUALIFIER is empty in " + result));
            return null;
        }
        return Writables.getHRegionInfo(bytes);
    }

    boolean cleanParent(HRegionInfo parent, Result rowContent) throws IOException {
        boolean result = false;
        boolean hasReferencesA = this.checkDaughter(parent, rowContent, HConstants.SPLITA_QUALIFIER);
        boolean hasReferencesB = this.checkDaughter(parent, rowContent, HConstants.SPLITB_QUALIFIER);
        if (!hasReferencesA && !hasReferencesB) {
            LOG.debug((Object)("Deleting region " + parent.getRegionNameAsString() + " because daughter splits no longer hold references"));
            if (this.services.getAssignmentManager() != null) {
                this.services.getAssignmentManager().regionOffline(parent);
            }
            FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
            Path rootdir = this.services.getMasterFileSystem().getRootDir();
            HRegion.deleteRegion(fs, rootdir, parent);
            MetaEditor.deleteRegion(this.server.getCatalogTracker(), parent);
            result = true;
        }
        return result;
    }

    boolean checkDaughter(HRegionInfo parent, Result rowContent, byte[] qualifier) throws IOException {
        HRegionInfo hri = this.getDaughterRegionInfo(rowContent, qualifier);
        return this.hasReferences(parent, rowContent, hri, qualifier);
    }

    private HRegionInfo getDaughterRegionInfo(Result result, byte[] which) throws IOException {
        byte[] bytes = result.getValue(HConstants.CATALOG_FAMILY, which);
        return Writables.getHRegionInfoOrNull(bytes);
    }

    private void removeDaughterFromParent(HRegionInfo parent, HRegionInfo split, byte[] qualifier) throws IOException {
        MetaEditor.deleteDaughterReferenceInParent(this.server.getCatalogTracker(), parent, qualifier, split);
    }

    boolean hasReferences(HRegionInfo parent, Result rowContent, HRegionInfo split, byte[] qualifier) throws IOException {
        boolean result = false;
        if (split == null) {
            return result;
        }
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = new Path(rootdir, split.getTableDesc().getNameAsString());
        for (HColumnDescriptor family : split.getTableDesc().getFamilies()) {
            Path p = Store.getStoreHomedir(tabledir, split.getEncodedName(), family.getName());
            FileStatus[] ps = fs.listStatus(p, new PathFilter(){

                public boolean accept(Path path) {
                    return StoreFile.isReference(path);
                }
            });
            if (ps == null || ps.length <= 0) continue;
            result = true;
            break;
        }
        if (!result) {
            this.removeDaughterFromParent(parent, split, qualifier);
        }
        return result;
    }
}

