/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;

public class ModifyTableHandler
extends TableEventHandler {
    private final HTableDescriptor htd;

    public ModifyTableHandler(byte[] tableName, HTableDescriptor htd, Server server, MasterServices masterServices) throws IOException {
        super(EventHandler.EventType.C_M_MODIFY_TABLE, tableName, server, masterServices);
        this.htd = htd;
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        for (HRegionInfo hri : hris) {
            hri.setTableDesc(this.htd);
            MetaEditor.updateRegionInfo(this.server.getCatalogTracker(), hri);
            this.masterServices.getMasterFileSystem().updateRegionInfo(hri);
        }
    }
}

