/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.util.Bytes;

public class TableDeleteFamilyHandler
extends TableEventHandler {
    private final byte[] familyName;

    public TableDeleteFamilyHandler(byte[] tableName, byte[] familyName, Server server, MasterServices masterServices) throws IOException {
        super(EventHandler.EventType.C_M_ADD_FAMILY, tableName, server, masterServices);
        this.familyName = familyName;
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        HTableDescriptor htd = hris.get(0).getTableDesc();
        if (!htd.hasFamily(this.familyName)) {
            throw new InvalidFamilyOperationException("Family '" + Bytes.toString(this.familyName) + "' does not exist so " + "cannot be deleted");
        }
        for (HRegionInfo hri : hris) {
            hri.getTableDesc().removeFamily(this.familyName);
            MetaEditor.updateRegionInfo(this.server.getCatalogTracker(), hri);
            MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
            mfs.updateRegionInfo(hri);
            mfs.deleteFamily(hri, this.familyName);
            this.masterServices.getMasterFileSystem().updateRegionInfo(hri);
        }
    }
}

