/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterAddressTracker;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.UnknownRowLockException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.RootLocationEditor;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiPut;
import org.apache.hadoop.hbase.client.MultiPutResponse;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseRpcMetrics;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningException;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServerCommandLine;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionServerRunningException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.ShutdownHook;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.handler.CloseMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.CloseRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.CloseRootHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRootHandler;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALObserver;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.zookeeper.KeeperException;

public class HRegionServer
implements HRegionInterface,
HBaseRPCErrorHandler,
Runnable,
RegionServerServices,
Server {
    public static final Log LOG = LogFactory.getLog(HRegionServer.class);
    protected volatile boolean stopped = false;
    private boolean stopping = false;
    protected volatile boolean abortRequested;
    private volatile boolean killed = false;
    protected volatile boolean fsOk = true;
    protected HServerInfo serverInfo;
    protected final Configuration conf;
    private final HConnection connection;
    protected final AtomicBoolean haveRootRegion = new AtomicBoolean(false);
    private FileSystem fs;
    private Path rootDir;
    private final Random rand = new Random();
    protected final Map<String, HRegion> onlineRegions = new ConcurrentHashMap<String, HRegion>();
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final LinkedBlockingQueue<HMsg> outboundMsgs = new LinkedBlockingQueue();
    final int numRetries;
    protected final int threadWakeFrequency;
    private final int msgInterval;
    protected final int numRegionsToReport;
    private final long maxScannerResultSize;
    private HMasterRegionInterface hbaseMaster;
    HBaseServer server;
    private Leases leases;
    private volatile AtomicInteger requestCount = new AtomicInteger();
    InfoServer infoServer;
    public static final String REGIONSERVER = "regionserver";
    private final LinkedList<byte[]> reservedSpace = new LinkedList();
    private RegionServerMetrics metrics;
    CompactSplitThread compactSplitThread;
    MemStoreFlusher cacheFlusher;
    Chore majorCompactionChecker;
    protected volatile HLog hlog;
    LogRoller hlogRoller;
    protected volatile boolean isOnline;
    final Map<String, InternalScanner> scanners = new ConcurrentHashMap<String, InternalScanner>();
    private ZooKeeperWatcher zooKeeper;
    private MasterAddressTracker masterAddressManager;
    private CatalogTracker catalogTracker;
    private ClusterStatusTracker clusterStatusTracker;
    private final Sleeper sleeper;
    private final int rpcTimeout;
    private Thread regionServerThread;
    private ExecutorService service;
    private Replication replicationHandler;
    private final Set<byte[]> regionsInTransitionInRS = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    private static final int NORMAL_QOS = 0;
    private static final int QOS_THRESHOLD = 10;
    private static final int HIGH_QOS = 100;
    Map<String, Integer> rowlocks = new ConcurrentHashMap<String, Integer>();

    public HRegionServer(Configuration conf) throws IOException, InterruptedException {
        this.conf = conf;
        this.connection = HConnectionManager.getConnection(conf);
        this.isOnline = false;
        String[] codecs = conf.getStrings("hbase.regionserver.codecs", (String[])null);
        if (codecs != null) {
            for (String codec : codecs) {
                if (CompressionTest.testCompression(codec)) continue;
                throw new IOException("Compression codec " + codec + " not supported, aborting RS construction");
            }
        }
        this.numRetries = conf.getInt("hbase.client.retries.number", 10);
        this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
        this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 3000);
        this.sleeper = new Sleeper(this.msgInterval, this);
        this.maxScannerResultSize = conf.getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.numRegionsToReport = conf.getInt("hbase.regionserver.numregionstoreport", 10);
        this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
        this.abortRequested = false;
        this.stopped = false;
        String machineName = DNS.getDefaultHost((String)conf.get("hbase.regionserver.dns.interface", "default"), (String)conf.get("hbase.regionserver.dns.nameserver", "default"));
        String addressStr = machineName + ":" + conf.get("hbase.regionserver.port", Integer.toString(60020));
        HServerAddress address = new HServerAddress(addressStr);
        this.server = HBaseRPC.getServer(this, new Class[]{HRegionInterface.class, HBaseRPCErrorHandler.class, OnlineRegions.class}, address.getBindAddress(), address.getPort(), conf.getInt("hbase.regionserver.handler.count", 10), conf.getInt("hbase.regionserver.metahandler.count", 10), false, conf, 10);
        this.server.setErrorHandler(this);
        this.server.setQosFunction(new QosFunction());
        this.serverInfo = new HServerInfo(new HServerAddress(new InetSocketAddress(address.getBindAddress(), this.server.getListenerAddress().getPort())), System.currentTimeMillis(), this.conf.getInt("hbase.regionserver.info.port", 60030), machineName);
        if (this.serverInfo.getServerAddress() == null) {
            throw new NullPointerException("Server address cannot be null; hbase-958 debugging");
        }
        User.login(conf, "hbase.regionserver.keytab.file", "hbase.regionserver.kerberos.principal", this.serverInfo.getHostname());
    }

    private void initialize() throws IOException, InterruptedException {
        try {
            this.initializeZooKeeper();
            this.initializeThreads();
            int nbBlocks = this.conf.getInt("hbase.regionserver.nbreservationblocks", 4);
            for (int i = 0; i < nbBlocks; ++i) {
                this.reservedSpace.add(new byte[0x500000]);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Stopping HRS because failed initialize", t);
            this.server.stop();
        }
    }

    private void initializeZooKeeper() throws IOException, InterruptedException {
        this.zooKeeper = new ZooKeeperWatcher(this.conf, "regionserver:" + this.serverInfo.getServerAddress().getPort(), this);
        this.masterAddressManager = new MasterAddressTracker(this.zooKeeper, this);
        this.masterAddressManager.start();
        this.blockAndCheckIfStopped(this.masterAddressManager);
        this.clusterStatusTracker = new ClusterStatusTracker(this.zooKeeper, this);
        this.clusterStatusTracker.start();
        this.blockAndCheckIfStopped(this.clusterStatusTracker);
        this.catalogTracker = new CatalogTracker(this.zooKeeper, this.connection, this, this.conf.getInt("hbase.regionserver.catalog.timeout", Integer.MAX_VALUE));
        this.catalogTracker.start();
    }

    private void blockAndCheckIfStopped(ZooKeeperNodeTracker tracker) throws IOException, InterruptedException {
        while (tracker.blockUntilAvailable(this.msgInterval) == null) {
            if (!this.stopped) continue;
            throw new IOException("Received the shutdown message while waiting.");
        }
    }

    private boolean isClusterUp() {
        return this.clusterStatusTracker.isClusterUp();
    }

    private void initializeThreads() throws IOException {
        this.cacheFlusher = new MemStoreFlusher(this.conf, this);
        this.compactSplitThread = new CompactSplitThread(this);
        int multiplier = this.conf.getInt("hbase.server.thread.wakefrequency.multiplier", 1000);
        this.majorCompactionChecker = new MajorCompactionChecker(this, this.threadWakeFrequency * multiplier, (Stoppable)this);
        this.leases = new Leases((int)this.conf.getLong(HConstants.HBASE_REGIONSERVER_LEASE_PERIOD_KEY, HConstants.DEFAULT_HBASE_REGIONSERVER_LEASE_PERIOD), this.threadWakeFrequency);
    }

    @Override
    public void run() {
        LruBlockCache c;
        block35: {
            try {
                this.initialize();
            }
            catch (Exception e) {
                this.abort("Fatal exception during initialization", e);
            }
            this.regionServerThread = Thread.currentThread();
            try {
                while (!this.stopped && !this.tryReportForDuty()) {
                }
                long lastMsg = 0L;
                ArrayList<HMsg> outboundMessages = new ArrayList<HMsg>();
                int tries = 0;
                while (!this.stopped && this.isHealthy()) {
                    HMsg msg;
                    long now;
                    if (!this.isClusterUp()) {
                        if (this.isOnlineRegionsEmpty()) {
                            this.stop("Exiting; cluster shutdown set and not carrying any regions");
                        } else if (!this.stopping) {
                            this.stopping = true;
                            this.closeUserRegions(this.abortRequested);
                        } else if (this.stopping && LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Waiting on " + this.getOnlineRegionsAsPrintableString()));
                        }
                    }
                    if ((now = System.currentTimeMillis()) - lastMsg >= (long)this.msgInterval || !outboundMessages.isEmpty()) {
                        try {
                            this.doMetrics();
                            this.tryRegionServerReport(outboundMessages);
                            lastMsg = System.currentTimeMillis();
                            tries = 0;
                            if (this.stopped) {
                                continue;
                            }
                        }
                        catch (Exception e2) {
                            IOException e2;
                            if (e2 instanceof IOException) {
                                e2 = RemoteExceptionHandler.checkIOException((IOException)e2);
                            }
                            if (e2 instanceof YouAreDeadException) {
                                throw e2;
                            }
                            if (++tries > 0 && tries % this.numRetries == 0) {
                                this.checkFileSystem();
                            }
                            if (this.stopped) continue;
                            LOG.warn((Object)("Attempt=" + tries), (Throwable)e2);
                            lastMsg = System.currentTimeMillis();
                        }
                    }
                    if ((msg = this.outboundMsgs.poll((long)this.msgInterval - ((now = System.currentTimeMillis()) - lastMsg), TimeUnit.MILLISECONDS)) == null) continue;
                    outboundMessages.add(msg);
                }
            }
            catch (Throwable t) {
                if (this.checkOOME(t)) break block35;
                this.abort("Unhandled exception: " + t.getMessage(), t);
            }
        }
        this.leases.closeAfterLeasesExpire();
        this.server.stop();
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((c = (LruBlockCache)StoreFile.getBlockCache(this.conf)) != null) {
            c.shutdown();
        }
        if (this.cacheFlusher != null) {
            this.cacheFlusher.interruptIfNecessary();
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.interruptIfNecessary();
        }
        if (this.hlogRoller != null) {
            this.hlogRoller.interruptIfNecessary();
        }
        if (this.majorCompactionChecker != null) {
            this.majorCompactionChecker.interrupt();
        }
        if (!this.killed) {
            if (this.abortRequested) {
                if (this.fsOk) {
                    this.closeAllRegions(this.abortRequested);
                    this.closeWAL(false);
                }
                LOG.info((Object)("aborting server at: " + this.serverInfo.getServerName()));
            } else {
                this.closeAllRegions(this.abortRequested);
                this.closeWAL(true);
                this.closeAllScanners();
                LOG.info((Object)("stopping server at: " + this.serverInfo.getServerName()));
            }
        }
        if (this.catalogTracker != null) {
            this.catalogTracker.stop();
        }
        if (this.fsOk) {
            this.waitOnAllRegionsToClose();
        }
        if (this.hbaseMaster != null) {
            HBaseRPC.stopProxy(this.hbaseMaster);
            this.hbaseMaster = null;
        }
        this.leases.close();
        HConnectionManager.deleteConnection(this.conf, true);
        this.zooKeeper.close();
        if (!this.killed) {
            this.join();
        }
        LOG.info((Object)(Thread.currentThread().getName() + " exiting"));
    }

    String getOnlineRegionsAsPrintableString() {
        StringBuilder sb = new StringBuilder();
        for (HRegion r : this.onlineRegions.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(r.getRegionInfo().getEncodedName());
        }
        return sb.toString();
    }

    private void waitOnAllRegionsToClose() {
        int lastCount = -1;
        while (!this.isOnlineRegionsEmpty()) {
            int count = this.getNumberOfOnlineRegions();
            if (count != lastCount) {
                lastCount = count;
                LOG.info((Object)("Waiting on " + count + " regions to close"));
                if (count < 10 && LOG.isDebugEnabled()) {
                    LOG.debug(this.onlineRegions);
                }
            }
            Threads.sleep(1000);
        }
    }

    List<HMsg> tryRegionServerReport(List<HMsg> outboundMessages) throws IOException {
        this.serverInfo.setLoad(this.buildServerLoad());
        this.requestCount.set(0);
        this.addOutboundMsgs(outboundMessages);
        HMsg[] msgs = null;
        while (!this.stopped) {
            try {
                msgs = this.hbaseMaster.regionServerReport(this.serverInfo, outboundMessages.toArray(HMsg.EMPTY_HMSG_ARRAY), this.getMostLoadedRegions());
                break;
            }
            catch (IOException ioe) {
                if (ioe instanceof RemoteException) {
                    ioe = ((RemoteException)((Object)ioe)).unwrapRemoteException();
                }
                if (ioe instanceof YouAreDeadException) {
                    throw ioe;
                }
                this.getMaster();
            }
        }
        this.updateOutboundMsgs(outboundMessages);
        outboundMessages.clear();
        for (int i = 0; !this.stopped && msgs != null && i < msgs.length; ++i) {
            LOG.info((Object)msgs[i].toString());
            if (msgs[i].getType().equals((Object)HMsg.Type.STOP_REGIONSERVER)) {
                this.stop("Received " + msgs[i]);
                continue;
            }
            LOG.warn((Object)("NOT PROCESSING " + msgs[i] + " -- WHY IS MASTER SENDING IT TO US?"));
        }
        return outboundMessages;
    }

    private HServerLoad buildServerLoad() {
        MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        HServerLoad hsl = new HServerLoad(this.requestCount.get(), (int)(memory.getUsed() / 1024L / 1024L), (int)(memory.getMax() / 1024L / 1024L));
        for (HRegion r : this.onlineRegions.values()) {
            hsl.addRegionInfo(this.createRegionLoad(r));
        }
        return hsl;
    }

    private void closeWAL(boolean delete) {
        try {
            if (this.hlog != null) {
                if (delete) {
                    this.hlog.closeAndDelete();
                } else {
                    this.hlog.close();
                }
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Close and delete failed", RemoteExceptionHandler.checkThrowable(e));
        }
    }

    private void closeAllScanners() {
        for (Map.Entry<String, InternalScanner> e : this.scanners.entrySet()) {
            try {
                e.getValue().close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Closing scanner " + e.getKey()), (Throwable)ioe);
            }
        }
    }

    private void addOutboundMsgs(List<HMsg> msgs) {
        if (msgs.isEmpty()) {
            this.outboundMsgs.drainTo(msgs);
            return;
        }
        block0: for (HMsg m : this.outboundMsgs) {
            for (HMsg mm : msgs) {
                if (!mm.equals(m)) continue;
                continue block0;
            }
            msgs.add(m);
        }
    }

    private void updateOutboundMsgs(List<HMsg> msgs) {
        if (msgs.isEmpty()) {
            return;
        }
        block0: for (HMsg m : this.outboundMsgs) {
            for (HMsg mm : msgs) {
                if (!mm.equals(m)) continue;
                this.outboundMsgs.remove(m);
                continue block0;
            }
        }
    }

    protected void handleReportForDutyResponse(MapWritable c) throws IOException {
        try {
            for (Map.Entry e : c.entrySet()) {
                String key = ((Writable)e.getKey()).toString();
                if (key.equals("hbase.regionserver.address")) {
                    HServerAddress hsa = (HServerAddress)e.getValue();
                    LOG.info((Object)("Master passed us address to use. Was=" + this.serverInfo.getServerAddress() + ", Now=" + hsa.toString()));
                    this.serverInfo.setServerAddress(hsa);
                    continue;
                }
                String value = ((Writable)e.getValue()).toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Config from master: " + key + "=" + value));
                }
                this.conf.set(key, value);
            }
            if (this.conf.get("mapred.task.id") == null) {
                this.conf.set("mapred.task.id", "hb_rs_" + this.serverInfo.getServerName() + "_" + System.currentTimeMillis());
            }
            this.conf.set("fs.defaultFS", this.conf.get("hbase.rootdir"));
            this.fs = FileSystem.get((Configuration)this.conf);
            this.rootDir = new Path(this.conf.get("hbase.rootdir"));
            this.hlog = this.setupWALAndReplication();
            this.metrics = new RegionServerMetrics();
            this.startServiceThreads();
            LOG.info((Object)("Serving as " + this.serverInfo.getServerName() + ", RPC listening on " + this.server.getListenerAddress() + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getZooKeeper().getSessionId())));
            this.isOnline = true;
        }
        catch (Throwable e) {
            this.isOnline = false;
            this.stop("Failed initialization");
            throw this.convertThrowableToIOE(this.cleanup(e, "Failed init"), "Region server startup failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HServerLoad.RegionLoad createRegionLoad(HRegion r) {
        byte[] name = r.getRegionName();
        int stores = 0;
        int storefiles = 0;
        int storefileSizeMB = 0;
        int memstoreSizeMB = (int)(r.memstoreSize.get() / 1024L / 1024L);
        int storefileIndexSizeMB = 0;
        Map<byte[], Store> map = r.stores;
        synchronized (map) {
            stores += r.stores.size();
            for (Store store : r.stores.values()) {
                storefiles += store.getStorefilesCount();
                storefileSizeMB += (int)(store.getStorefilesSize() / 1024L / 1024L);
                storefileIndexSizeMB += (int)(store.getStorefilesIndexSize() / 1024L / 1024L);
            }
        }
        return new HServerLoad.RegionLoad(name, stores, storefiles, storefileSizeMB, memstoreSizeMB, storefileIndexSizeMB);
    }

    public HServerLoad.RegionLoad createRegionLoad(String encodedRegionName) {
        HRegion r = null;
        r = this.onlineRegions.get(encodedRegionName);
        return r != null ? this.createRegionLoad(r) : null;
    }

    private Throwable cleanup(Throwable t) {
        return this.cleanup(t, null);
    }

    private Throwable cleanup(Throwable t, String msg) {
        if (t instanceof NotServingRegionException) {
            LOG.debug((Object)("NotServingRegionException; " + t.getMessage()));
            return t;
        }
        if (msg == null) {
            LOG.error((Object)"", RemoteExceptionHandler.checkThrowable(t));
        } else {
            LOG.error((Object)msg, RemoteExceptionHandler.checkThrowable(t));
        }
        if (!this.checkOOME(t)) {
            this.checkFileSystem();
        }
        return t;
    }

    private IOException convertThrowableToIOE(Throwable t) {
        return this.convertThrowableToIOE(t, null);
    }

    private IOException convertThrowableToIOE(Throwable t, String msg) {
        return t instanceof IOException ? (IOException)t : (msg == null || msg.length() == 0 ? new IOException(t) : new IOException(msg, t));
    }

    @Override
    public boolean checkOOME(Throwable e) {
        boolean stop = false;
        if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
            this.abort("OutOfMemoryError, aborting", e);
            stop = true;
        }
        return stop;
    }

    protected boolean checkFileSystem() {
        if (this.fsOk && this.fs != null) {
            try {
                FSUtils.checkFileSystemAvailable(this.fs);
            }
            catch (IOException e) {
                this.abort("File System not available", e);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    private HLog setupWALAndReplication() throws IOException {
        Path oldLogDir = new Path(this.rootDir, ".oldlogs");
        Path logdir = new Path(this.rootDir, HLog.getHLogDirectoryName(this.serverInfo));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logdir=" + logdir));
        }
        if (this.fs.exists(logdir)) {
            throw new RegionServerRunningException("Region server already running at " + this.serverInfo.getServerName() + " because logdir " + logdir.toString() + " exists");
        }
        try {
            this.replicationHandler = Replication.isReplication(this.conf) ? new Replication(this, this.fs, logdir, oldLogDir) : null;
        }
        catch (KeeperException e) {
            throw new IOException("Failed replication handler create", e);
        }
        return this.instantiateHLog(logdir, oldLogDir);
    }

    protected HLog instantiateHLog(Path logdir, Path oldLogDir) throws IOException {
        return new HLog(this.fs, logdir, oldLogDir, this.conf, this.getWALActionListeners(), this.serverInfo.getServerAddress().toString());
    }

    protected List<WALObserver> getWALActionListeners() {
        ArrayList<WALObserver> listeners = new ArrayList<WALObserver>();
        this.hlogRoller = new LogRoller(this, this);
        listeners.add(this.hlogRoller);
        if (this.replicationHandler != null) {
            listeners.add(this.replicationHandler);
        }
        return listeners;
    }

    protected LogRoller getLogRoller() {
        return this.hlogRoller;
    }

    protected void doMetrics() {
        try {
            this.metrics();
        }
        catch (Throwable e) {
            LOG.warn((Object)"Failed metrics", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void metrics() {
        int seconds = this.msgInterval / 1000;
        if (0 == seconds) {
            seconds = 1;
        }
        this.metrics.regions.set(this.onlineRegions.size());
        this.metrics.requests.set(this.requestCount.get() / seconds);
        int stores = 0;
        int storefiles = 0;
        long memstoreSize = 0L;
        long storefileIndexSize = 0L;
        for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
            HRegion r = e.getValue();
            memstoreSize += r.memstoreSize.get();
            Map<byte[], Store> map = r.stores;
            synchronized (map) {
                stores += r.stores.size();
                for (Map.Entry<byte[], Store> ee : r.stores.entrySet()) {
                    Store store = ee.getValue();
                    storefiles += store.getStorefilesCount();
                    storefileIndexSize += store.getStorefilesIndexSize();
                }
            }
        }
        this.metrics.stores.set(stores);
        this.metrics.storefiles.set(storefiles);
        this.metrics.memstoreSizeMB.set((int)(memstoreSize / 0x100000L));
        this.metrics.storefileIndexSizeMB.set((int)(storefileIndexSize / 0x100000L));
        this.metrics.compactionQueueSize.set(this.compactSplitThread.getCompactionQueueSize());
        this.metrics.flushQueueSize.set(this.cacheFlusher.getFlushQueueSize());
        LruBlockCache lruBlockCache = (LruBlockCache)StoreFile.getBlockCache(this.conf);
        if (lruBlockCache != null) {
            this.metrics.blockCacheCount.set(lruBlockCache.size());
            this.metrics.blockCacheFree.set(lruBlockCache.getFreeSize());
            this.metrics.blockCacheSize.set(lruBlockCache.getCurrentSize());
            LruBlockCache.CacheStats cacheStats = lruBlockCache.getStats();
            this.metrics.blockCacheHitCount.set(cacheStats.getHitCount());
            this.metrics.blockCacheMissCount.set(cacheStats.getMissCount());
            this.metrics.blockCacheEvictedCount.set(lruBlockCache.getEvictedCount());
            double ratio = lruBlockCache.getStats().getHitRatio();
            int percent = (int)(ratio * 100.0);
            this.metrics.blockCacheHitRatio.set(percent);
            ratio = lruBlockCache.getStats().getHitCachingRatio();
            percent = (int)(ratio * 100.0);
            this.metrics.blockCacheHitCachingRatio.set(percent);
        }
    }

    public RegionServerMetrics getMetrics() {
        return this.metrics;
    }

    private void startServiceThreads() throws IOException {
        String n = Thread.currentThread().getName();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                HRegionServer.this.abort("Uncaught exception in service thread " + t.getName(), e);
            }
        };
        this.service = new ExecutorService(this.getServerName());
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_OPEN_REGION, this.conf.getInt("hbase.regionserver.executor.openregion.threads", 3));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_OPEN_ROOT, this.conf.getInt("hbase.regionserver.executor.openroot.threads", 1));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_OPEN_META, this.conf.getInt("hbase.regionserver.executor.openmeta.threads", 1));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_CLOSE_REGION, this.conf.getInt("hbase.regionserver.executor.closeregion.threads", 3));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_CLOSE_ROOT, this.conf.getInt("hbase.regionserver.executor.closeroot.threads", 1));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_CLOSE_META, this.conf.getInt("hbase.regionserver.executor.closemeta.threads", 1));
        Threads.setDaemonThreadRunning(this.hlogRoller, n + ".logRoller", handler);
        Threads.setDaemonThreadRunning(this.cacheFlusher, n + ".cacheFlusher", handler);
        Threads.setDaemonThreadRunning(this.compactSplitThread, n + ".compactor", handler);
        Threads.setDaemonThreadRunning(this.majorCompactionChecker, n + ".majorCompactionChecker", handler);
        this.leases.setName(n + ".leaseChecker");
        this.leases.start();
        int port = this.conf.getInt("hbase.regionserver.info.port", 60030);
        if (port >= 0) {
            String addr = this.conf.get("hbase.regionserver.info.bindAddress", "0.0.0.0");
            boolean auto = this.conf.getBoolean("hbase.regionserver.info.port.auto", false);
            while (true) {
                try {
                    this.infoServer = new InfoServer(REGIONSERVER, addr, port, false);
                    this.infoServer.setAttribute(REGIONSERVER, this);
                    this.infoServer.start();
                }
                catch (BindException e) {
                    if (!auto) {
                        throw e;
                    }
                    LOG.info((Object)("Failed binding http info server to port: " + port));
                    this.serverInfo = new HServerInfo(this.serverInfo.getServerAddress(), this.serverInfo.getStartCode(), ++port, this.serverInfo.getHostname());
                    continue;
                }
                break;
            }
        }
        if (this.replicationHandler != null) {
            this.replicationHandler.startReplicationServices();
        }
        this.server.start();
    }

    private boolean isHealthy() {
        if (!this.fsOk) {
            return false;
        }
        if (!(this.leases.isAlive() && this.compactSplitThread.isAlive() && this.cacheFlusher.isAlive() && this.hlogRoller.isAlive() && this.majorCompactionChecker.isAlive())) {
            this.stop("One or more threads are no longer alive -- stop");
            return false;
        }
        return true;
    }

    @Override
    public HLog getWAL() {
        return this.hlog;
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String msg) {
        this.stopped = true;
        LOG.info((Object)("STOPPED: " + msg));
        HRegionServer hRegionServer = this;
        synchronized (hRegionServer) {
            this.notifyAll();
        }
    }

    @Override
    public void postOpenDeployTasks(HRegion r, CatalogTracker ct, boolean daughter) throws KeeperException, IOException {
        if (r.hasReferences() || r.hasTooManyStoreFiles()) {
            this.getCompactionRequester().requestCompaction(r, r.hasReferences() ? "Region has references on open" : "Region has too many store files");
        }
        this.addToOnlineRegions(r);
        if (r.getRegionInfo().isRootRegion()) {
            RootLocationEditor.setRootLocation(this.getZooKeeper(), this.getServerInfo().getServerAddress());
        } else if (r.getRegionInfo().isMetaRegion()) {
            MetaEditor.updateMetaLocation(ct, r.getRegionInfo(), this.getServerInfo());
        } else if (daughter) {
            MetaEditor.addDaughter(ct, r.getRegionInfo(), this.getServerInfo());
        } else {
            MetaEditor.updateRegionLocation(ct, r.getRegionInfo(), this.getServerInfo());
        }
    }

    @Override
    public HBaseRpcMetrics getRpcMetrics() {
        return this.server.getRpcMetrics();
    }

    @Override
    public void abort(String reason, Throwable cause) {
        if (cause != null) {
            LOG.fatal((Object)("ABORTING region server " + this + ": " + reason), cause);
        } else {
            LOG.fatal((Object)("ABORTING region server " + this + ": " + reason));
        }
        this.abortRequested = true;
        this.reservedSpace.clear();
        if (this.metrics != null) {
            LOG.info((Object)("Dump of metrics: " + this.metrics));
        }
        this.stop(reason);
    }

    public void abort(String reason) {
        this.abort(reason, null);
    }

    protected void kill() {
        this.killed = true;
        this.abort("Simulated kill");
    }

    protected void join() {
        Threads.shutdown(this.majorCompactionChecker);
        Threads.shutdown(this.cacheFlusher);
        Threads.shutdown(this.compactSplitThread);
        Threads.shutdown(this.hlogRoller);
        this.service.shutdown();
        if (this.replicationHandler != null) {
            this.replicationHandler.join();
        }
    }

    private HServerAddress getMaster() {
        HServerAddress masterAddress = null;
        HMasterRegionInterface master = null;
        while (!this.stopped && master == null) {
            masterAddress = this.getMasterAddress();
            LOG.info((Object)("Attempting connect to Master server at " + masterAddress));
            try {
                master = (HMasterRegionInterface)HBaseRPC.waitForProxy(HMasterRegionInterface.class, 27L, masterAddress.getInetSocketAddress(), this.conf, -1, this.rpcTimeout, this.rpcTimeout);
            }
            catch (IOException e) {
                IOException iOException = e = e instanceof RemoteException ? ((RemoteException)((Object)e)).unwrapRemoteException() : e;
                if (e instanceof ServerNotRunningException) {
                    LOG.info((Object)"Master isn't available yet, retrying");
                } else {
                    LOG.warn((Object)"Unable to connect to master. Retrying. Error was:", (Throwable)e);
                }
                this.sleeper.sleep();
            }
        }
        LOG.info((Object)("Connected to master at " + masterAddress));
        this.hbaseMaster = master;
        return masterAddress;
    }

    private HServerAddress getMasterAddress() {
        HServerAddress masterAddress = null;
        while ((masterAddress = this.masterAddressManager.getMasterAddress()) == null) {
            if (this.stopped) {
                return null;
            }
            LOG.debug((Object)"No master found, will retry");
            this.sleeper.sleep();
        }
        return masterAddress;
    }

    private boolean tryReportForDuty() throws IOException {
        MapWritable w = this.reportForDuty();
        if (w != null) {
            this.handleReportForDutyResponse(w);
            return true;
        }
        this.sleeper.sleep();
        LOG.warn((Object)"No response on reportForDuty. Sleeping and then retrying.");
        return false;
    }

    private MapWritable reportForDuty() throws IOException {
        HServerAddress masterAddress = null;
        while (!this.stopped && (masterAddress = this.getMaster()) == null) {
            this.sleeper.sleep();
            LOG.warn((Object)"Unable to get master for initialization");
        }
        MapWritable result = null;
        long lastMsg = 0L;
        while (!this.stopped) {
            try {
                this.requestCount.set(0);
                lastMsg = System.currentTimeMillis();
                ZKUtil.setAddressAndWatch(this.zooKeeper, ZKUtil.joinZNode(this.zooKeeper.rsZNode, ZKUtil.getNodeName(this.serverInfo)), this.serverInfo.getServerAddress());
                this.serverInfo.setLoad(this.buildServerLoad());
                LOG.info((Object)("Telling master at " + masterAddress + " that we are up"));
                result = this.hbaseMaster.regionServerStartup(this.serverInfo, EnvironmentEdgeManager.currentTimeMillis());
                break;
            }
            catch (RemoteException e) {
                IOException ioe = e.unwrapRemoteException();
                if (ioe instanceof ClockOutOfSyncException) {
                    LOG.fatal((Object)"Master rejected startup because clock is out of sync", (Throwable)ioe);
                    throw ioe;
                }
                LOG.warn((Object)"remote error telling master we are up", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)"error telling master we are up", (Throwable)e);
            }
            catch (KeeperException e) {
                LOG.warn((Object)"error putting up ephemeral node in zookeeper", (Throwable)e);
            }
            this.sleeper.sleep(lastMsg);
        }
        return result;
    }

    void reportSplit(HRegionInfo oldRegion, HRegionInfo newRegionA, HRegionInfo newRegionB) {
        this.outboundMsgs.add(new HMsg(HMsg.Type.REGION_SPLIT, oldRegion, newRegionA, newRegionB, Bytes.toBytes("Daughters; " + newRegionA.getRegionNameAsString() + ", " + newRegionB.getRegionNameAsString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllRegions(boolean abort) {
        this.closeUserRegions(abort);
        HRegion meta = null;
        HRegion root = null;
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegionInfo hri = e.getValue().getRegionInfo();
                if (hri.isRootRegion()) {
                    root = e.getValue();
                } else if (hri.isMetaRegion()) {
                    meta = e.getValue();
                }
                if (meta == null || root == null) continue;
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (meta != null) {
            this.closeRegion(meta.getRegionInfo(), abort, false);
        }
        if (root != null) {
            this.closeRegion(root.getRegionInfo(), abort, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUserRegions(boolean abort) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegion r = e.getValue();
                if (r.getRegionInfo().isMetaRegion()) continue;
                this.closeRegion(r.getRegionInfo(), abort, false);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    @QosPriority(priority=100)
    public HRegionInfo getRegionInfo(byte[] regionName) throws NotServingRegionException {
        this.requestCount.incrementAndGet();
        return this.getRegion(regionName).getRegionInfo();
    }

    @Override
    public Result getClosestRowBefore(byte[] regionName, byte[] row, byte[] family) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            Result r = region.getClosestRowBefore(row, family);
            return r;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public Result get(byte[] regionName, Get get2) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            return region.get(get2, this.getLockFromId(get2.getLockId()));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public boolean exists(byte[] regionName, Get get2) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            Result r = region.get(get2, this.getLockFromId(get2.getLockId()));
            return r != null && !r.isEmpty();
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void put(byte[] regionName, Put put) throws IOException {
        if (put.getRow() == null) {
            throw new IllegalArgumentException("update has null row");
        }
        this.checkOpen();
        this.requestCount.incrementAndGet();
        HRegion region = this.getRegion(regionName);
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            boolean writeToWAL = put.getWriteToWAL();
            region.put(put, this.getLockFromId(put.getLockId()), writeToWAL);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public int put(byte[] regionName, List<Put> puts) throws IOException {
        this.checkOpen();
        HRegion region = null;
        try {
            region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Pair[] putsWithLocks = new Pair[puts.size()];
            int i = 0;
            for (Put p : puts) {
                Integer lock = this.getLockFromId(p.getLockId());
                putsWithLocks[i++] = new Pair<Put, Integer>(p, lock);
            }
            this.requestCount.addAndGet(puts.size());
            HConstants.OperationStatusCode[] codes = region.put(putsWithLocks);
            for (i = 0; i < codes.length; ++i) {
                if (codes[i] == HConstants.OperationStatusCode.SUCCESS) continue;
                return i;
            }
            return -1;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    private boolean checkAndMutate(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, byte[] value, Writable w, Integer lock) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        HRegion region = this.getRegion(regionName);
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            return region.checkAndMutate(row, family, qualifier, value, w, lock, true);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public boolean checkAndPut(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.checkAndMutate(regionName, row, family, qualifier, value, put, this.getLockFromId(put.getLockId()));
    }

    @Override
    public boolean checkAndDelete(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndMutate(regionName, row, family, qualifier, value, delete, this.getLockFromId(delete.getLockId()));
    }

    @Override
    public long openScanner(byte[] regionName, Scan scan) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (scan == null) {
            npe = new NullPointerException("scan is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to openScanner", npe);
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion r = this.getRegion(regionName);
            return this.addScanner(r.getScanner(scan));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t, "Failed openScanner"));
        }
    }

    protected long addScanner(InternalScanner s) throws Leases.LeaseStillHeldException {
        long scannerId = -1L;
        scannerId = this.rand.nextLong();
        String scannerName = String.valueOf(scannerId);
        this.scanners.put(scannerName, s);
        this.leases.createLease(scannerName, new ScannerListener(scannerName));
        return scannerId;
    }

    @Override
    public Result next(long scannerId) throws IOException {
        Result[] res = this.next(scannerId, 1);
        if (res == null || res.length == 0) {
            return null;
        }
        return res[0];
    }

    @Override
    public Result[] next(long scannerId, int nbRows) throws IOException {
        try {
            String scannerName = String.valueOf(scannerId);
            InternalScanner s = this.scanners.get(scannerName);
            if (s == null) {
                throw new UnknownScannerException("Name: " + scannerName);
            }
            try {
                this.checkOpen();
            }
            catch (IOException e) {
                try {
                    this.leases.cancelLease(scannerName);
                }
                catch (LeaseException le) {
                    LOG.info((Object)("Server shutting down and client tried to access missing scanner " + scannerName));
                }
                throw e;
            }
            this.leases.renewLease(scannerName);
            ArrayList<Result> results = new ArrayList<Result>(nbRows);
            long currentScanResultSize = 0L;
            ArrayList<KeyValue> values = new ArrayList<KeyValue>();
            for (int i = 0; i < nbRows && currentScanResultSize < this.maxScannerResultSize; ++i) {
                this.requestCount.incrementAndGet();
                boolean moreRows = s.next(values);
                if (!values.isEmpty()) {
                    for (KeyValue kv : values) {
                        currentScanResultSize += kv.heapSize();
                    }
                    results.add(new Result(values));
                }
                if (!moreRows) break;
                values.clear();
            }
            return ((HRegion.RegionScanner)s).isFilterDone() && results.isEmpty() ? null : results.toArray(new Result[0]);
        }
        catch (Throwable t) {
            if (t instanceof NotServingRegionException) {
                String scannerName = String.valueOf(scannerId);
                this.scanners.remove(scannerName);
            }
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void close(long scannerId) throws IOException {
        try {
            this.checkOpen();
            this.requestCount.incrementAndGet();
            String scannerName = String.valueOf(scannerId);
            InternalScanner s = this.scanners.remove(scannerName);
            if (s != null) {
                s.close();
                this.leases.cancelLease(scannerName);
            }
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void delete(byte[] regionName, Delete delete) throws IOException {
        this.checkOpen();
        try {
            boolean writeToWAL = true;
            this.requestCount.incrementAndGet();
            HRegion region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Integer lid = this.getLockFromId(delete.getLockId());
            region.delete(delete, lid, writeToWAL);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public int delete(byte[] regionName, List<Delete> deletes) throws IOException {
        int i = 0;
        this.checkOpen();
        HRegion region = null;
        try {
            boolean writeToWAL = true;
            region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            int size = deletes.size();
            Integer[] locks = new Integer[size];
            for (Delete delete : deletes) {
                this.requestCount.incrementAndGet();
                locks[i] = this.getLockFromId(delete.getLockId());
                region.delete(delete, locks[i], writeToWAL);
                ++i;
            }
        }
        catch (WrongRegionException ex) {
            LOG.debug((Object)("Batch deletes: " + i), (Throwable)ex);
            return i;
        }
        catch (NotServingRegionException ex) {
            return i;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
        return -1;
    }

    @Override
    public long lockRow(byte[] regionName, byte[] row) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (row == null) {
            npe = new NullPointerException("row to lock is null");
        }
        if (npe != null) {
            IOException io = new IOException("Invalid arguments to lockRow");
            io.initCause(npe);
            throw io;
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            Integer r = region.obtainRowLock(row);
            long lockId = this.addRowLock(r, region);
            LOG.debug((Object)("Row lock " + lockId + " explicitly acquired by client"));
            return lockId;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t, "Error obtaining row lock (fsOk: " + this.fsOk + ")"));
        }
    }

    protected long addRowLock(Integer r, HRegion region) throws Leases.LeaseStillHeldException {
        long lockId = -1L;
        lockId = this.rand.nextLong();
        String lockName = String.valueOf(lockId);
        this.rowlocks.put(lockName, r);
        this.leases.createLease(lockName, new RowLockListener(lockName, region));
        return lockId;
    }

    Integer getLockFromId(long lockId) throws IOException {
        if (lockId == -1L) {
            return null;
        }
        String lockName = String.valueOf(lockId);
        Integer rl = this.rowlocks.get(lockName);
        if (rl == null) {
            throw new UnknownRowLockException("Invalid row lock");
        }
        this.leases.renewLease(lockName);
        return rl;
    }

    @Override
    @QosPriority(priority=100)
    public void unlockRow(byte[] regionName, long lockId) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (lockId == -1L) {
            npe = new NullPointerException("lockId is null");
        }
        if (npe != null) {
            IOException io = new IOException("Invalid arguments to unlockRow");
            io.initCause(npe);
            throw io;
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            String lockName = String.valueOf(lockId);
            Integer r = this.rowlocks.remove(lockName);
            if (r == null) {
                throw new UnknownRowLockException(lockName);
            }
            region.releaseRowLock(r);
            this.leases.cancelLease(lockName);
            LOG.debug((Object)("Row lock " + lockId + " has been explicitly released by client"));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void bulkLoadHFile(String hfilePath, byte[] regionName, byte[] familyName) throws IOException {
        HRegion region = this.getRegion(regionName);
        region.bulkLoadHFile(hfilePath, familyName);
    }

    @Override
    @QosPriority(priority=100)
    public void openRegion(HRegionInfo region) throws IOException {
        if (this.regionsInTransitionInRS.contains(region.getEncodedNameAsBytes())) {
            throw new RegionAlreadyInTransitionException("open", region.getEncodedName());
        }
        LOG.info((Object)("Received request to open region: " + region.getRegionNameAsString()));
        if (this.stopped) {
            throw new RegionServerStoppedException();
        }
        if (region.isRootRegion()) {
            this.service.submit(new OpenRootHandler(this, this, region));
        } else if (region.isMetaRegion()) {
            this.service.submit(new OpenMetaHandler(this, this, region));
        } else {
            this.service.submit(new OpenRegionHandler(this, this, region));
        }
    }

    @Override
    @QosPriority(priority=100)
    public void openRegions(List<HRegionInfo> regions) throws IOException {
        LOG.info((Object)("Received request to open " + regions.size() + " region(s)"));
        for (HRegionInfo region : regions) {
            this.openRegion(region);
        }
    }

    @Override
    @QosPriority(priority=100)
    public boolean closeRegion(HRegionInfo region) throws IOException {
        return this.closeRegion(region, true);
    }

    @Override
    @QosPriority(priority=100)
    public boolean closeRegion(HRegionInfo region, boolean zk) throws IOException {
        LOG.info((Object)("Received close region: " + region.getRegionNameAsString()));
        boolean hasit = this.onlineRegions.containsKey(region.getEncodedName());
        if (!hasit) {
            LOG.warn((Object)("Received close for region we are not serving; " + region.getEncodedName()));
            throw new NotServingRegionException("Received close for " + region.getRegionNameAsString() + " but we are not serving it");
        }
        if (this.regionsInTransitionInRS.contains(region.getEncodedNameAsBytes())) {
            throw new RegionAlreadyInTransitionException("close", region.getEncodedName());
        }
        return this.closeRegion(region, false, zk);
    }

    protected boolean closeRegion(HRegionInfo region, boolean abort, boolean zk) {
        if (this.regionsInTransitionInRS.contains(region.getEncodedNameAsBytes())) {
            LOG.warn((Object)("Received close for region we are already opening or closing; " + region.getEncodedName()));
            return false;
        }
        CloseRegionHandler crh = null;
        crh = region.isRootRegion() ? new CloseRootHandler(this, this, region, abort, zk) : (region.isMetaRegion() ? new CloseMetaHandler(this, this, region, abort, zk) : new CloseRegionHandler(this, this, region, abort, zk));
        this.service.submit(crh);
        return true;
    }

    @Override
    @QosPriority(priority=100)
    public void flushRegion(HRegionInfo regionInfo) throws NotServingRegionException, IOException {
        LOG.info((Object)("Flushing " + regionInfo.getRegionNameAsString()));
        HRegion region = this.getRegion(regionInfo.getRegionName());
        region.flushcache();
    }

    @Override
    @QosPriority(priority=100)
    public void splitRegion(HRegionInfo regionInfo) throws NotServingRegionException, IOException {
        this.splitRegion(regionInfo, null);
    }

    @Override
    public void splitRegion(HRegionInfo regionInfo, byte[] splitPoint) throws NotServingRegionException, IOException {
        HRegion region = this.getRegion(regionInfo.getRegionName());
        region.flushcache();
        region.forceSplit(splitPoint);
        this.compactSplitThread.requestCompaction(region, "User-triggered split", 1);
    }

    @Override
    @QosPriority(priority=100)
    public void compactRegion(HRegionInfo regionInfo, boolean major) throws NotServingRegionException, IOException {
        HRegion region = this.getRegion(regionInfo.getRegionName());
        this.compactSplitThread.requestCompaction(region, major, "User-triggered " + (major ? "major " : "") + "compaction", 1);
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.lock.writeLock();
    }

    @Override
    @QosPriority(priority=100)
    public List<HRegionInfo> getOnlineRegions() {
        ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>(this.onlineRegions.size());
        for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
            list.add(e.getValue().getRegionInfo());
        }
        Collections.sort(list);
        return list;
    }

    public int getNumberOfOnlineRegions() {
        int size = -1;
        size = this.onlineRegions.size();
        return size;
    }

    boolean isOnlineRegionsEmpty() {
        return this.onlineRegions.isEmpty();
    }

    public Collection<HRegion> getOnlineRegionsLocalContext() {
        Collection<HRegion> regions = this.onlineRegions.values();
        return Collections.unmodifiableCollection(regions);
    }

    @Override
    public void addToOnlineRegions(HRegion region) {
        this.onlineRegions.put(region.getRegionInfo().getEncodedName(), region);
    }

    @Override
    public boolean removeFromOnlineRegions(String encodedName) {
        HRegion toReturn = null;
        toReturn = this.onlineRegions.remove(encodedName);
        return toReturn != null;
    }

    public SortedMap<Long, HRegion> getCopyOfOnlineRegionsSortedBySize() {
        TreeMap<Long, HRegion> sortedRegions = new TreeMap<Long, HRegion>(new Comparator<Long>(){

            @Override
            public int compare(Long a, Long b) {
                return -1 * a.compareTo(b);
            }
        });
        for (HRegion region : this.onlineRegions.values()) {
            sortedRegions.put(region.memstoreSize.get(), region);
        }
        return sortedRegions;
    }

    @Override
    public HRegion getFromOnlineRegions(String encodedRegionName) {
        HRegion r = null;
        r = this.onlineRegions.get(encodedRegionName);
        return r;
    }

    public HRegion getOnlineRegion(byte[] regionName) {
        return this.getFromOnlineRegions(HRegionInfo.encodeRegionName(regionName));
    }

    public AtomicInteger getRequestCount() {
        return this.requestCount;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return this.cacheFlusher;
    }

    protected HRegion getRegion(byte[] regionName) throws NotServingRegionException {
        HRegion region = null;
        region = this.getOnlineRegion(regionName);
        if (region == null) {
            throw new NotServingRegionException("Region is not online: " + Bytes.toStringBinary(regionName));
        }
        return region;
    }

    protected HRegionInfo[] getMostLoadedRegions() {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        for (HRegion r : this.onlineRegions.values()) {
            if (r.isClosed() || r.isClosing()) continue;
            if (regions.size() >= this.numRegionsToReport) break;
            regions.add(r.getRegionInfo());
        }
        return regions.toArray(new HRegionInfo[regions.size()]);
    }

    protected void checkOpen() throws IOException {
        if (this.stopped || this.abortRequested) {
            throw new IOException("Server not running" + (this.abortRequested ? ", aborting" : ""));
        }
        if (!this.fsOk) {
            throw new IOException("File system not available");
        }
    }

    protected Set<HRegion> getRegionsToCheck() {
        HashSet<HRegion> regionsToCheck = new HashSet<HRegion>();
        regionsToCheck.addAll(this.onlineRegions.values());
        Iterator i = regionsToCheck.iterator();
        while (i.hasNext()) {
            HRegion r = (HRegion)i.next();
            if (!r.isClosed()) continue;
            i.remove();
        }
        return regionsToCheck;
    }

    @QosPriority(priority=100)
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(HRegionInterface.class.getName())) {
            return 27L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    protected LinkedBlockingQueue<HMsg> getOutboundMsgs() {
        return this.outboundMsgs;
    }

    public long getGlobalMemStoreSize() {
        long total = 0L;
        for (HRegion region : this.onlineRegions.values()) {
            total += region.memstoreSize.get();
        }
        return total;
    }

    protected Leases getLeases() {
        return this.leases;
    }

    protected Path getRootDir() {
        return this.rootDir;
    }

    protected FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public HServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public Result increment(byte[] regionName, Increment increment) throws IOException {
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to increment regionName is null");
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            return region.increment(increment, this.getLockFromId(increment.getLockId()), increment.getWriteToWAL());
        }
        catch (IOException e) {
            this.checkFileSystem();
            throw e;
        }
    }

    @Override
    public long incrementColumnValue(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to incrementColumnValue regionName is null");
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            long retval = region.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
            return retval;
        }
        catch (IOException e) {
            this.checkFileSystem();
            throw e;
        }
    }

    @Override
    @QosPriority(priority=100)
    public HServerInfo getHServerInfo() throws IOException {
        return this.serverInfo;
    }

    @Override
    public MultiResponse multi(MultiAction multi) throws IOException {
        MultiResponse response = new MultiResponse();
        for (Map.Entry<byte[], List<Action>> e : multi.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List<Action> actionsForRegion = e.getValue();
            Collections.sort(actionsForRegion);
            ArrayList<Action> puts = new ArrayList<Action>();
            for (Action a : actionsForRegion) {
                Row action = a.getAction();
                int originalIndex = a.getOriginalIndex();
                try {
                    if (action instanceof Delete) {
                        this.delete(regionName, (Delete)action);
                        response.add(regionName, originalIndex, new Result());
                        continue;
                    }
                    if (action instanceof Get) {
                        response.add(regionName, originalIndex, this.get(regionName, (Get)action));
                        continue;
                    }
                    if (action instanceof Put) {
                        puts.add(a);
                        continue;
                    }
                    LOG.debug((Object)"Error: invalid Action, row must be a Get, Delete or Put.");
                    throw new DoNotRetryIOException("Invalid Action, row must be a Get, Delete or Put.");
                }
                catch (IOException ex) {
                    response.add(regionName, originalIndex, ex);
                }
            }
            if (puts.isEmpty()) continue;
            try {
                HRegion region = this.getRegion(regionName);
                if (!region.getRegionInfo().isMetaTable()) {
                    this.cacheFlusher.reclaimMemStoreMemory();
                }
                ArrayList putsWithLocks = Lists.newArrayListWithCapacity((int)puts.size());
                for (Action a : puts) {
                    Integer lock;
                    Put p = (Put)a.getAction();
                    try {
                        lock = this.getLockFromId(p.getLockId());
                    }
                    catch (UnknownRowLockException ex) {
                        response.add(regionName, a.getOriginalIndex(), ex);
                        continue;
                    }
                    putsWithLocks.add(new Pair<Put, Integer>(p, lock));
                }
                this.requestCount.addAndGet(puts.size());
                HConstants.OperationStatusCode[] codes = region.put(putsWithLocks.toArray(new Pair[0]));
                for (int i = 0; i < codes.length; ++i) {
                    HConstants.OperationStatusCode code = codes[i];
                    Action theAction = (Action)puts.get(i);
                    Object result = null;
                    if (code == HConstants.OperationStatusCode.SUCCESS) {
                        result = new Result();
                    } else if (code == HConstants.OperationStatusCode.BAD_FAMILY) {
                        result = new NoSuchColumnFamilyException();
                    }
                    response.add(regionName, theAction.getOriginalIndex(), result);
                }
            }
            catch (IOException ioe) {
                for (Action a : puts) {
                    response.add(regionName, a.getOriginalIndex(), ioe);
                }
            }
        }
        return response;
    }

    @Override
    public MultiPutResponse multiPut(MultiPut puts) throws IOException {
        MultiPutResponse resp = new MultiPutResponse();
        for (Map.Entry<byte[], List<Put>> e : puts.puts.entrySet()) {
            int result = this.put(e.getKey(), e.getValue());
            resp.addResult(e.getKey(), result);
            e.getValue().clear();
        }
        return resp;
    }

    public String toString() {
        return this.serverInfo.toString();
    }

    public int getThreadWakeFrequency() {
        return this.threadWakeFrequency;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public String getServerName() {
        return this.serverInfo.getServerName();
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return this.compactSplitThread;
    }

    @Override
    public Set<byte[]> getRegionsInTransitionInRS() {
        return this.regionsInTransitionInRS;
    }

    public static Thread startRegionServer(HRegionServer hrs) throws IOException {
        return HRegionServer.startRegionServer(hrs, REGIONSERVER + hrs.getServerInfo().getServerAddress().getPort());
    }

    public static Thread startRegionServer(HRegionServer hrs, String name) throws IOException {
        Thread t = new Thread(hrs);
        t.setName(name);
        t.start();
        ShutdownHook.install(hrs.getConfiguration(), FileSystem.get((Configuration)hrs.getConfiguration()), hrs, t);
        return t;
    }

    public static HRegionServer constructRegionServer(Class<? extends HRegionServer> regionServerClass, Configuration conf2) {
        try {
            Constructor<? extends HRegionServer> c = regionServerClass.getConstructor(Configuration.class);
            return c.newInstance(conf2);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Regionserver: " + regionServerClass.toString(), e);
        }
    }

    @Override
    public void replicateLogEntries(HLog.Entry[] entries) throws IOException {
        if (this.replicationHandler == null) {
            return;
        }
        this.replicationHandler.replicateLogEntries(entries);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Class regionServerClass = conf.getClass("hbase.regionserver.impl", HRegionServer.class);
        new HRegionServerCommandLine(regionServerClass).doMain(args);
    }

    private class RowLockListener
    implements LeaseListener {
        private final String lockName;
        private final HRegion region;

        RowLockListener(String lockName, HRegion region) {
            this.lockName = lockName;
            this.region = region;
        }

        @Override
        public void leaseExpired() {
            LOG.info((Object)("Row Lock " + this.lockName + " lease expired"));
            Integer r = HRegionServer.this.rowlocks.remove(this.lockName);
            if (r != null) {
                this.region.releaseRowLock(r);
            }
        }
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        @Override
        public void leaseExpired() {
            LOG.info((Object)("Scanner " + this.scannerName + " lease expired"));
            InternalScanner s = HRegionServer.this.scanners.remove(this.scannerName);
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Closing scanner", (Throwable)e);
                }
            }
        }
    }

    private static class MajorCompactionChecker
    extends Chore {
        private final HRegionServer instance;

        MajorCompactionChecker(HRegionServer h, int sleepTime, Stoppable stopper) {
            super("MajorCompactionChecker", sleepTime, h);
            this.instance = h;
            LOG.info((Object)("Runs every " + sleepTime + "ms"));
        }

        @Override
        protected void chore() {
            for (HRegion r : this.instance.onlineRegions.values()) {
                try {
                    if (r == null || !r.isMajorCompaction()) continue;
                    this.instance.compactSplitThread.requestCompaction(r, this.getName() + " requests major compaction");
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed major compaction check on " + r), (Throwable)e);
                }
            }
        }
    }

    class QosFunction
    implements Function<Writable, Integer> {
        private final Map<String, Integer> annotatedQos;

        public QosFunction() {
            HashMap<String, Integer> qosMap = new HashMap<String, Integer>();
            for (Method m : HRegionServer.class.getMethods()) {
                QosPriority p = m.getAnnotation(QosPriority.class);
                if (p == null) continue;
                qosMap.put(m.getName(), p.priority());
            }
            this.annotatedQos = qosMap;
        }

        public boolean isMetaRegion(byte[] regionName) {
            HRegion region;
            try {
                region = HRegionServer.this.getRegion(regionName);
            }
            catch (NotServingRegionException ignored) {
                return false;
            }
            return region.getRegionInfo().isMetaRegion();
        }

        public Integer apply(Writable from) {
            if (!(from instanceof HBaseRPC.Invocation)) {
                return 0;
            }
            HBaseRPC.Invocation inv = (HBaseRPC.Invocation)from;
            String methodName = inv.getMethodName();
            Integer priorityByAnnotation = this.annotatedQos.get(methodName);
            if (priorityByAnnotation != null) {
                return priorityByAnnotation;
            }
            if (methodName.equals("next") || methodName.equals("close")) {
                HRegion.RegionScanner rs;
                HRegionInfo regionName;
                Long scannerId;
                try {
                    scannerId = (Long)inv.getParameters()[0];
                }
                catch (ClassCastException ignored) {
                    return 0;
                }
                String scannerIdString = Long.toString(scannerId);
                InternalScanner scanner = HRegionServer.this.scanners.get(scannerIdString);
                if (scanner instanceof HRegion.RegionScanner && (regionName = (rs = (HRegion.RegionScanner)scanner).getRegionName()).isMetaRegion()) {
                    return 100;
                }
            } else if (inv.getParameterClasses().length != 0) {
                if (inv.getParameterClasses()[0] == byte[].class) {
                    if (this.isMetaRegion((byte[])inv.getParameters()[0])) {
                        return 100;
                    }
                } else if (inv.getParameterClasses()[0] == MultiAction.class) {
                    MultiAction ma = (MultiAction)inv.getParameters()[0];
                    Set<byte[]> regions = ma.getRegions();
                    for (byte[] region : regions) {
                        if (!this.isMetaRegion(region)) continue;
                        return 100;
                    }
                }
            }
            return 0;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface QosPriority {
        public int priority() default 0;
    }
}

