/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.ScannerResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;

public class ScannerInstanceResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(ScannerInstanceResource.class);
    static CacheControl cacheControl = new CacheControl();
    ResultGenerator generator;
    String id;
    int batch = 1;

    public ScannerInstanceResource(String table, String id, ResultGenerator generator, int batch) throws IOException {
        this.id = id;
        this.generator = generator;
        this.batch = batch;
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response get(@Context UriInfo uriInfo, @QueryParam(value="n") int maxRows, @QueryParam(value="c") int maxValues) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        CellSetModel model = new CellSetModel();
        RowModel rowModel = null;
        byte[] rowKey = null;
        int limit = this.batch;
        if (maxValues > 0) {
            limit = maxValues;
        }
        int count = limit;
        do {
            KeyValue value = null;
            try {
                value = (KeyValue)this.generator.next();
            }
            catch (IllegalStateException e) {
                ScannerResource.delete(this.id);
                throw new WebApplicationException(Response.Status.GONE);
            }
            if (value == null) {
                LOG.info((Object)"generator exhausted");
                if (count != limit) break;
                return Response.noContent().build();
            }
            if (rowKey == null) {
                rowKey = value.getRow();
                rowModel = new RowModel(rowKey);
            }
            if (!Bytes.equals(value.getRow(), rowKey)) {
                if (maxRows > 0 && --maxRows == 0) {
                    this.generator.putBack(value);
                    break;
                }
                model.addRow(rowModel);
                rowKey = value.getRow();
                rowModel = new RowModel(rowKey);
            }
            rowModel.addCell(new CellModel(value.getFamily(), value.getQualifier(), value.getTimestamp(), value.getValue()));
        } while (--count > 0);
        model.addRow(rowModel);
        Response.ResponseBuilder response = Response.ok((Object)model);
        response.cacheControl(cacheControl);
        return response.build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getBinary(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            KeyValue value = (KeyValue)this.generator.next();
            if (value == null) {
                LOG.info((Object)"generator exhausted");
                return Response.noContent().build();
            }
            Response.ResponseBuilder response = Response.ok((Object)value.getValue());
            response.cacheControl(cacheControl);
            response.header("X-Row", (Object)Base64.encodeBytes(value.getRow()));
            response.header("X-Column", (Object)Base64.encodeBytes(KeyValue.makeColumn(value.getFamily(), value.getQualifier())));
            response.header("X-Timestamp", (Object)value.getTimestamp());
            return response.build();
        }
        catch (IllegalStateException e) {
            ScannerResource.delete(this.id);
            throw new WebApplicationException(Response.Status.GONE);
        }
    }

    @DELETE
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETE " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ScannerResource.delete(this.id);
        return Response.ok().build();
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

