/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class BatchMutation
implements TBase<_Fields>,
Serializable,
Cloneable,
Comparable<BatchMutation> {
    private static final TStruct STRUCT_DESC = new TStruct("BatchMutation");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField MUTATIONS_FIELD_DESC = new TField("mutations", 15, 2);
    public byte[] row;
    public List<Mutation> mutations;
    public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class){
        {
            this.put(_Fields.ROW, new FieldMetaData("row", 3, new FieldValueMetaData(11)));
            this.put(_Fields.MUTATIONS, new FieldMetaData("mutations", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Mutation.class))));
        }
    });

    public BatchMutation() {
    }

    public BatchMutation(byte[] row, List<Mutation> mutations) {
        this();
        this.row = row;
        this.mutations = mutations;
    }

    public BatchMutation(BatchMutation other) {
        if (other.isSetRow()) {
            this.row = other.row;
        }
        if (other.isSetMutations()) {
            ArrayList<Mutation> __this__mutations = new ArrayList<Mutation>();
            for (Mutation other_element : other.mutations) {
                __this__mutations.add(new Mutation(other_element));
            }
            this.mutations = __this__mutations;
        }
    }

    public BatchMutation deepCopy() {
        return new BatchMutation(this);
    }

    @Deprecated
    public BatchMutation clone() {
        return new BatchMutation(this);
    }

    public byte[] getRow() {
        return this.row;
    }

    public BatchMutation setRow(byte[] row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getMutationsSize() {
        return this.mutations == null ? 0 : this.mutations.size();
    }

    public Iterator<Mutation> getMutationsIterator() {
        return this.mutations == null ? null : this.mutations.iterator();
    }

    public void addToMutations(Mutation elem) {
        if (this.mutations == null) {
            this.mutations = new ArrayList<Mutation>();
        }
        this.mutations.add(elem);
    }

    public List<Mutation> getMutations() {
        return this.mutations;
    }

    public BatchMutation setMutations(List<Mutation> mutations) {
        this.mutations = mutations;
        return this;
    }

    public void unsetMutations() {
        this.mutations = null;
    }

    public boolean isSetMutations() {
        return this.mutations != null;
    }

    public void setMutationsIsSet(boolean value) {
        if (!value) {
            this.mutations = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((byte[])value);
                break;
            }
            case MUTATIONS: {
                if (value == null) {
                    this.unsetMutations();
                    break;
                }
                this.setMutations((List)value);
            }
        }
    }

    public void setFieldValue(int fieldID, Object value) {
        this.setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case MUTATIONS: {
                return this.getMutations();
            }
        }
        throw new IllegalStateException();
    }

    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
    }

    public boolean isSet(_Fields field) {
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case MUTATIONS: {
                return this.isSetMutations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(int fieldID) {
        return this.isSet(_Fields.findByThriftIdOrThrow(fieldID));
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof BatchMutation) {
            return this.equals((BatchMutation)that);
        }
        return false;
    }

    public boolean equals(BatchMutation that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!Arrays.equals(this.row, that.row)) {
                return false;
            }
        }
        boolean this_present_mutations = this.isSetMutations();
        boolean that_present_mutations = that.isSetMutations();
        if (this_present_mutations || that_present_mutations) {
            if (!this_present_mutations || !that_present_mutations) {
                return false;
            }
            if (!((Object)this.mutations).equals(that.mutations)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_row = this.isSetRow();
        builder.append(present_row);
        if (present_row) {
            builder.append(this.row);
        }
        boolean present_mutations = this.isSetMutations();
        builder.append(present_mutations);
        if (present_mutations) {
            builder.append(this.mutations);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(BatchMutation other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        BatchMutation typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(this.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo((byte[])this.row, (byte[])typedOther.row);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMutations()).compareTo(this.isSetMutations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.mutations, typedOther.mutations);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            _Fields fieldId = _Fields.findByThriftId(field.id);
            if (fieldId == null) {
                TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                continue;
            }
            switch (fieldId) {
                case ROW: {
                    if (field.type == 11) {
                        this.row = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case MUTATIONS: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.mutations = new ArrayList<Mutation>(_list0.size);
                        for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                            Mutation _elem2 = new Mutation();
                            _elem2.read(iprot);
                            this.mutations.add(_elem2);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.row != null) {
            oprot.writeFieldBegin(ROW_FIELD_DESC);
            oprot.writeBinary(this.row);
            oprot.writeFieldEnd();
        }
        if (this.mutations != null) {
            oprot.writeFieldBegin(MUTATIONS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.mutations.size()));
            for (Mutation _iter3 : this.mutations) {
                _iter3.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BatchMutation(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            sb.append(this.row);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("mutations:");
        if (this.mutations == null) {
            sb.append("null");
        } else {
            sb.append(this.mutations);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(BatchMutation.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        MUTATIONS(2, "mutations");

        private static final Map<Integer, _Fields> byId;
        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            return byId.get(fieldId);
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byId = new HashMap<Integer, _Fields>();
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byId.put(Integer.valueOf(field._thriftId), field);
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

