/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public abstract class ZooKeeperNodeTracker
extends ZooKeeperListener {
    protected final String node;
    private byte[] data;
    protected final Abortable abortable;
    private boolean stopped = false;

    public ZooKeeperNodeTracker(ZooKeeperWatcher watcher, String node, Abortable abortable) {
        super(watcher);
        this.node = node;
        this.abortable = abortable;
        this.data = null;
    }

    public synchronized void start() {
        this.watcher.registerListener(this);
        try {
            if (ZKUtil.watchAndCheckExists(this.watcher, this.node)) {
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, this.node);
                if (data != null) {
                    this.data = data;
                } else {
                    this.start();
                }
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Unexpected exception during initialization, aborting", e);
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized byte[] blockUntilAvailable() throws InterruptedException {
        return this.blockUntilAvailable(0L);
    }

    public synchronized byte[] blockUntilAvailable(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        boolean notimeout = timeout == 0L;
        long startTime = System.currentTimeMillis();
        long remaining = timeout;
        while (!this.stopped && (notimeout || remaining > 0L) && this.data == null) {
            if (notimeout) {
                this.wait();
                continue;
            }
            this.wait(remaining);
            remaining = timeout - (System.currentTimeMillis() - startTime);
        }
        return this.data;
    }

    public synchronized byte[] getData() {
        return this.data;
    }

    public String getNode() {
        return this.node;
    }

    @Override
    public synchronized void nodeCreated(String path) {
        if (!path.equals(this.node)) {
            return;
        }
        try {
            byte[] data = ZKUtil.getDataAndWatch(this.watcher, this.node);
            if (data != null) {
                this.data = data;
                this.notifyAll();
            } else {
                this.nodeDeleted(path);
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Unexpected exception handling nodeCreated event", e);
        }
    }

    @Override
    public synchronized void nodeDeleted(String path) {
        if (path.equals(this.node)) {
            try {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.node)) {
                    this.nodeCreated(path);
                } else {
                    this.data = null;
                }
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected exception handling nodeDeleted event", e);
            }
        }
    }

    @Override
    public synchronized void nodeDataChanged(String path) {
        if (path.equals(this.node)) {
            this.nodeCreated(path);
        }
    }
}

