/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.htrace;

import java.io.Closeable;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.Tracer;

public class TraceScope
implements Closeable {
    private final Span span;
    private final Span savedSpan;
    private boolean detached = false;

    TraceScope(Span span, Span saved) {
        this.span = span;
        this.savedSpan = saved;
    }

    public Span getSpan() {
        return this.span;
    }

    public Span detach() {
        this.detached = true;
        Span cur = Tracer.getInstance().currentSpan();
        if (cur != this.span) {
            Tracer.LOG.debug((Object)("Closing trace span " + this.span + " but " + cur + " was top-of-stack"));
        } else {
            Tracer.getInstance().setCurrentSpan(this.savedSpan);
        }
        return this.span;
    }

    @Override
    public void close() {
        if (this.span == null) {
            return;
        }
        if (!this.detached) {
            this.span.stop();
            Tracer.getInstance().deliver(this.span);
            this.detach();
        }
    }
}

