/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceFailedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceLocalizedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationCleanupEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStartMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStopMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.SystemClock;

public class ContainerImpl
implements Container {
    private final Lock readLock;
    private final Lock writeLock;
    private final Dispatcher dispatcher;
    private final NMStateStoreService stateStore;
    private final Credentials credentials;
    private final NodeManagerMetrics metrics;
    private final ContainerLaunchContext launchContext;
    private final ContainerTokenIdentifier containerTokenIdentifier;
    private final ContainerId containerId;
    private final Resource resource;
    private final String user;
    private int exitCode = -1000;
    private final StringBuilder diagnostics;
    private boolean wasLaunched;
    private long containerLaunchStartTime;
    private static Clock clock = new SystemClock();
    private final Configuration daemonConf;
    private static final Log LOG = LogFactory.getLog(Container.class);
    private final Map<LocalResourceRequest, List<String>> pendingResources = new HashMap<LocalResourceRequest, List<String>>();
    private final Map<Path, List<String>> localizedResources = new HashMap<Path, List<String>>();
    private final List<LocalResourceRequest> publicRsrcs = new ArrayList<LocalResourceRequest>();
    private final List<LocalResourceRequest> privateRsrcs = new ArrayList<LocalResourceRequest>();
    private final List<LocalResourceRequest> appRsrcs = new ArrayList<LocalResourceRequest>();
    private NMStateStoreService.RecoveredContainerStatus recoveredStatus = NMStateStoreService.RecoveredContainerStatus.REQUESTED;
    private boolean recoveredAsKilled = false;
    private static final ContainerDiagnosticsUpdateTransition UPDATE_DIAGNOSTICS_TRANSITION = new ContainerDiagnosticsUpdateTransition();
    private static StateMachineFactory<ContainerImpl, ContainerState, ContainerEventType, ContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)ContainerState.NEW).addTransition((Enum)ContainerState.NEW, EnumSet.of(ContainerState.LOCALIZING, ContainerState.LOCALIZED, ContainerState.LOCALIZATION_FAILED, ContainerState.DONE), (Enum)ContainerEventType.INIT_CONTAINER, (MultipleArcTransition)new RequestResourcesTransition()).addTransition((Enum)ContainerState.NEW, (Enum)ContainerState.NEW, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.NEW, (Enum)ContainerState.DONE, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillOnNewTransition()).addTransition((Enum)ContainerState.LOCALIZING, EnumSet.of(ContainerState.LOCALIZING, ContainerState.LOCALIZED), (Enum)ContainerEventType.RESOURCE_LOCALIZED, (MultipleArcTransition)new LocalizedTransition()).addTransition((Enum)ContainerState.LOCALIZING, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.RESOURCE_FAILED, (SingleArcTransition)new ResourceFailedTransition()).addTransition((Enum)ContainerState.LOCALIZING, (Enum)ContainerState.LOCALIZING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.LOCALIZING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillDuringLocalizationTransition()).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new LocalizationFailedToDoneTransition()).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.KILL_CONTAINER).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.RESOURCE_LOCALIZED).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.RESOURCE_FAILED).addTransition((Enum)ContainerState.LOCALIZED, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.CONTAINER_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)ContainerState.LOCALIZED, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.LOCALIZED, (Enum)ContainerState.LOCALIZED, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.LOCALIZED, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(true)).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new KilledExternallyTransition()).addTransition((Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new ExitedWithSuccessToDoneTransition()).addTransition((Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.KILL_CONTAINER).addTransition((Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new ExitedWithFailureToDoneTransition()).addTransition((Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.KILL_CONTAINER).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new ContainerKilledTransition()).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition)new LocalizedResourceDuringKillTransition()).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.RESOURCE_FAILED).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(false)).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(false)).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new KillingToDoneTransition()).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.CONTAINER_LAUNCHED).addTransition((Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new ContainerCleanedupAfterKillToDoneTransition()).addTransition((Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, EnumSet.of(ContainerEventType.KILL_CONTAINER, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE)).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.KILL_CONTAINER).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.INIT_CONTAINER).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, EnumSet.of(ContainerEventType.RESOURCE_FAILED, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE)).installTopology();
    private final StateMachine<ContainerState, ContainerEventType, ContainerEvent> stateMachine;

    public ContainerImpl(Configuration conf, Dispatcher dispatcher, NMStateStoreService stateStore, ContainerLaunchContext launchContext, Credentials creds, NodeManagerMetrics metrics, ContainerTokenIdentifier containerTokenIdentifier) {
        this.daemonConf = conf;
        this.dispatcher = dispatcher;
        this.stateStore = stateStore;
        this.launchContext = launchContext;
        this.containerTokenIdentifier = containerTokenIdentifier;
        this.containerId = containerTokenIdentifier.getContainerID();
        this.resource = containerTokenIdentifier.getResource();
        this.diagnostics = new StringBuilder();
        this.credentials = creds;
        this.metrics = metrics;
        this.user = containerTokenIdentifier.getApplicationSubmitter();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    public ContainerImpl(Configuration conf, Dispatcher dispatcher, NMStateStoreService stateStore, ContainerLaunchContext launchContext, Credentials creds, NodeManagerMetrics metrics, ContainerTokenIdentifier containerTokenIdentifier, NMStateStoreService.RecoveredContainerStatus recoveredStatus, int exitCode, String diagnostics, boolean wasKilled) {
        this(conf, dispatcher, stateStore, launchContext, creds, metrics, containerTokenIdentifier);
        this.recoveredStatus = recoveredStatus;
        this.exitCode = exitCode;
        this.recoveredAsKilled = wasKilled;
        this.diagnostics.append(diagnostics);
    }

    public org.apache.hadoop.yarn.api.records.ContainerState getCurrentState() {
        switch ((ContainerState)this.stateMachine.getCurrentState()) {
            case NEW: 
            case LOCALIZING: 
            case LOCALIZATION_FAILED: 
            case LOCALIZED: 
            case RUNNING: 
            case EXITED_WITH_SUCCESS: 
            case EXITED_WITH_FAILURE: 
            case KILLING: 
            case CONTAINER_CLEANEDUP_AFTER_KILL: 
            case CONTAINER_RESOURCES_CLEANINGUP: {
                return org.apache.hadoop.yarn.api.records.ContainerState.RUNNING;
            }
        }
        return org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUser() {
        this.readLock.lock();
        try {
            String string = this.user;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Path, List<String>> getLocalizedResources() {
        this.readLock.lock();
        try {
            if (ContainerState.LOCALIZED == this.getContainerState()) {
                Map<Path, List<String>> map = this.localizedResources;
                return map;
            }
            Map<Path, List<String>> map = null;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials() {
        this.readLock.lock();
        try {
            Credentials credentials = this.credentials;
            return credentials;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerState getContainerState() {
        this.readLock.lock();
        try {
            ContainerState containerState = (ContainerState)this.stateMachine.getCurrentState();
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerLaunchContext getLaunchContext() {
        this.readLock.lock();
        try {
            ContainerLaunchContext containerLaunchContext = this.launchContext;
            return containerLaunchContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerStatus cloneAndGetContainerStatus() {
        this.readLock.lock();
        try {
            ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)this.containerId, (org.apache.hadoop.yarn.api.records.ContainerState)this.getCurrentState(), (String)this.diagnostics.toString(), (int)this.exitCode);
            return containerStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NMContainerStatus getNMContainerStatus() {
        this.readLock.lock();
        try {
            NMContainerStatus nMContainerStatus = NMContainerStatus.newInstance((ContainerId)this.containerId, (org.apache.hadoop.yarn.api.records.ContainerState)this.getCurrentState(), (Resource)this.getResource(), (String)this.diagnostics.toString(), (int)this.exitCode, (Priority)this.containerTokenIdentifier.getPriority(), (long)this.containerTokenIdentifier.getCreationTime());
            return nMContainerStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerTokenIdentifier getContainerTokenIdentifier() {
        this.readLock.lock();
        try {
            ContainerTokenIdentifier containerTokenIdentifier = this.containerTokenIdentifier;
            return containerTokenIdentifier;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void sendFinishedEvents() {
        EventHandler eventHandler = this.dispatcher.getEventHandler();
        eventHandler.handle((Event)new ApplicationContainerFinishedEvent(this.containerId));
        eventHandler.handle((Event)new ContainerStopMonitoringEvent(this.containerId));
        eventHandler.handle((Event)new LogHandlerContainerFinishedEvent(this.containerId, this.exitCode));
    }

    private void sendLaunchEvent() {
        ContainersLauncherEventType launcherEvent = ContainersLauncherEventType.LAUNCH_CONTAINER;
        if (this.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.LAUNCHED) {
            launcherEvent = ContainersLauncherEventType.RECOVER_CONTAINER;
        }
        this.containerLaunchStartTime = clock.getTime();
        this.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(this, launcherEvent));
    }

    private void sendContainerMonitorStartEvent() {
        long pmemBytes = (long)(this.getResource().getMemory() * 1024) * 1024L;
        pmemBytes = Math.max(pmemBytes, 0x500000L);
        float pmemRatio = this.daemonConf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
        long vmemBytes = (long)(pmemRatio * (float)pmemBytes);
        this.dispatcher.getEventHandler().handle((Event)new ContainerStartMonitoringEvent(this.containerId, vmemBytes, pmemBytes));
    }

    private void addDiagnostics(String ... diags) {
        for (String s : diags) {
            this.diagnostics.append(s);
        }
        try {
            this.stateStore.storeContainerDiagnostics(this.containerId, this.diagnostics);
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to update diagnostics in state store for " + this.containerId), (Throwable)e);
        }
    }

    public void cleanup() {
        HashMap<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrc = new HashMap<LocalResourceVisibility, Collection<LocalResourceRequest>>();
        if (!this.publicRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.PUBLIC, this.publicRsrcs);
        }
        if (!this.privateRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.PRIVATE, this.privateRsrcs);
        }
        if (!this.appRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.APPLICATION, this.appRsrcs);
        }
        this.dispatcher.getEventHandler().handle((Event)new ContainerLocalizationCleanupEvent(this, rsrc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ContainerEvent event) {
        try {
            this.writeLock.lock();
            ContainerId containerID = event.getContainerID();
            LOG.debug((Object)("Processing " + containerID + " of type " + event.getType()));
            ContainerState oldState = (ContainerState)this.stateMachine.getCurrentState();
            ContainerState newState = null;
            try {
                newState = (ContainerState)this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.warn((Object)("Can't handle this event at current state: Current: [" + (Object)((Object)oldState) + "], eventType: [" + event.getType() + "]"), (Throwable)e);
            }
            if (oldState != newState) {
                LOG.info((Object)("Container " + containerID + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = ConverterUtils.toString((ContainerId)this.containerId);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean hasDefaultExitCode() {
        return this.exitCode == -1000;
    }

    static /* synthetic */ NMStateStoreService.RecoveredContainerStatus access$000(ContainerImpl x0) {
        return x0.recoveredStatus;
    }

    static /* synthetic */ ContainerLaunchContext access$700(ContainerImpl x0) {
        return x0.launchContext;
    }

    static /* synthetic */ List access$1000(ContainerImpl x0) {
        return x0.publicRsrcs;
    }

    static /* synthetic */ List access$1100(ContainerImpl x0) {
        return x0.privateRsrcs;
    }

    static /* synthetic */ List access$1200(ContainerImpl x0) {
        return x0.appRsrcs;
    }

    static class ContainerDiagnosticsUpdateTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerDiagnosticsUpdateTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerDiagnosticsUpdateEvent updateEvent = (ContainerDiagnosticsUpdateEvent)event;
            container.addDiagnostics(new String[]{updateEvent.getDiagnosticsUpdate(), "\n"});
            try {
                container.stateStore.storeContainerDiagnostics(container.containerId, container.diagnostics);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to update state store diagnostics for " + container.containerId), (Throwable)e);
            }
        }
    }

    static class ContainerCleanedupAfterKillToDoneTransition
    extends ContainerDoneTransition {
        ContainerCleanedupAfterKillToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            if (container.wasLaunched) {
                container.metrics.endRunningContainer();
            }
            container.metrics.killedContainer();
            NMAuditLogger.logSuccess(container.user, "Container Finished - Killed", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class KillingToDoneTransition
    extends ContainerDoneTransition {
        KillingToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.metrics.killedContainer();
            NMAuditLogger.logSuccess(container.user, "Container Finished - Killed", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class ExitedWithFailureToDoneTransition
    extends ContainerDoneTransition {
        ExitedWithFailureToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            if (container.wasLaunched) {
                container.metrics.endRunningContainer();
            }
            container.metrics.failedContainer();
            NMAuditLogger.logFailure(container.user, "Container Finished - Failed", "ContainerImpl", "Container failed with state: " + (Object)((Object)container.getContainerState()), container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class ExitedWithSuccessToDoneTransition
    extends ContainerDoneTransition {
        ExitedWithSuccessToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.metrics.endRunningContainer();
            container.metrics.completedContainer();
            NMAuditLogger.logSuccess(container.user, "Container Finished - Succeeded", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class LocalizationFailedToDoneTransition
    extends ContainerDoneTransition {
        LocalizationFailedToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.metrics.failedContainer();
            NMAuditLogger.logFailure(container.user, "Container Finished - Failed", "ContainerImpl", "Container failed with state: " + (Object)((Object)container.getContainerState()), container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class KillOnNewTransition
    extends ContainerDoneTransition {
        KillOnNewTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.exitCode = killEvent.getContainerExitStatus();
            container.addDiagnostics(new String[]{killEvent.getDiagnostic(), "\n"});
            container.addDiagnostics(new String[]{"Container is killed before being launched.\n"});
            container.metrics.killedContainer();
            NMAuditLogger.logSuccess(container.user, "Container Finished - Killed", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class ContainerDoneTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerDoneTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.metrics.releaseContainer(container.resource);
            container.sendFinishedEvents();
            if (container.getCurrentState() != org.apache.hadoop.yarn.api.records.ContainerState.NEW) {
                container.dispatcher.getEventHandler().handle((Event)new AuxServicesEvent(AuxServicesEventType.CONTAINER_STOP, container));
            }
        }
    }

    static class ContainerKilledTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerKilledTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerExitEvent exitEvent = (ContainerExitEvent)event;
            if (container.hasDefaultExitCode()) {
                container.exitCode = exitEvent.getExitCode();
            }
            if (exitEvent.getDiagnosticInfo() != null) {
                container.addDiagnostics(new String[]{exitEvent.getDiagnosticInfo(), "\n"});
            }
            container.cleanup();
        }
    }

    static class KillTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        KillTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.addDiagnostics(new String[]{killEvent.getDiagnostic(), "\n"});
            container.exitCode = killEvent.getContainerExitStatus();
        }
    }

    static class LocalizedResourceDuringKillTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        LocalizedResourceDuringKillTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            List syms = (List)container.pendingResources.remove(rsrcEvent.getResource());
            if (null == syms) {
                LOG.warn((Object)("Localized unknown resource " + rsrcEvent.getResource() + " for container " + container.containerId));
                assert (false);
                return;
            }
            container.localizedResources.put(rsrcEvent.getLocation(), syms);
        }
    }

    static class KillDuringLocalizationTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        KillDuringLocalizationTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.cleanup();
            container.metrics.endInitingContainer();
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.exitCode = killEvent.getContainerExitStatus();
            container.addDiagnostics(new String[]{killEvent.getDiagnostic(), "\n"});
            container.addDiagnostics(new String[]{"Container is killed before being launched.\n"});
        }
    }

    static class ResourceFailedTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ResourceFailedTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceFailedEvent rsrcFailedEvent = (ContainerResourceFailedEvent)event;
            container.addDiagnostics(new String[]{rsrcFailedEvent.getDiagnosticMessage(), "\n"});
            container.cleanup();
            container.metrics.endInitingContainer();
        }
    }

    static class KilledExternallyTransition
    extends ExitedWithFailureTransition {
        KilledExternallyTransition() {
            super(true);
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            super.transition(container, event);
            container.addDiagnostics(new String[]{"Killed by external signal\n"});
        }
    }

    static class ExitedWithFailureTransition
    extends ContainerTransition {
        boolean clCleanupRequired;

        public ExitedWithFailureTransition(boolean clCleanupRequired) {
            this.clCleanupRequired = clCleanupRequired;
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerExitEvent exitEvent = (ContainerExitEvent)event;
            container.exitCode = exitEvent.getExitCode();
            if (exitEvent.getDiagnosticInfo() != null) {
                container.addDiagnostics(new String[]{exitEvent.getDiagnosticInfo(), "\n"});
            }
            if (this.clCleanupRequired) {
                container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
            container.cleanup();
        }
    }

    static class ExitedWithSuccessTransition
    extends ContainerTransition {
        boolean clCleanupRequired;

        public ExitedWithSuccessTransition(boolean clCleanupRequired) {
            this.clCleanupRequired = clCleanupRequired;
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.exitCode = 0;
            if (this.clCleanupRequired) {
                container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
            container.cleanup();
        }
    }

    static class LaunchTransition
    extends ContainerTransition {
        LaunchTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.sendContainerMonitorStartEvent();
            container.metrics.runningContainer();
            container.wasLaunched = true;
            long duration = clock.getTime() - container.containerLaunchStartTime;
            container.metrics.addContainerLaunchDuration(duration);
            if (container.recoveredAsKilled) {
                LOG.info((Object)("Killing " + container.containerId + " due to recovered as killed"));
                container.addDiagnostics(new String[]{"Container recovered as killed.\n"});
                container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
        }
    }

    static class LocalizedTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        LocalizedTransition() {
        }

        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            List syms = (List)container.pendingResources.remove(rsrcEvent.getResource());
            if (null == syms) {
                LOG.warn((Object)("Localized unknown resource " + rsrcEvent.getResource() + " for container " + container.containerId));
                assert (false);
                return ContainerState.LOCALIZING;
            }
            container.localizedResources.put(rsrcEvent.getLocation(), syms);
            if (!container.pendingResources.isEmpty()) {
                return ContainerState.LOCALIZING;
            }
            container.sendLaunchEvent();
            container.metrics.endInitingContainer();
            return ContainerState.LOCALIZED;
        }
    }

    static class RequestResourcesTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        RequestResourcesTransition() {
        }

        /*
         * Exception decompiling
         */
        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class ContainerTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
        }
    }
}

