/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.DataQueueAttributes;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class DataQueue
extends BaseDataQueue {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;

    public DataQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing DataQueue object.");
        }
    }

    public DataQueue(AS400 aS400, String string) {
        super(aS400, string);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing DataQueue object.");
        }
    }

    public void create(DataQueueAttributes dataQueueAttributes) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (dataQueueAttributes.getKeyLength() > 0) {
            Trace.log(2, "Using DataQueue for keyed data queue.");
            throw new IllegalObjectTypeException(1);
        }
        this.create(dataQueueAttributes.getEntryLength(), dataQueueAttributes.getAuthority(), dataQueueAttributes.isSaveSenderInfo(), dataQueueAttributes.isFIFO(), dataQueueAttributes.isForceToAuxiliaryStorage(), dataQueueAttributes.getDescription());
    }

    public void create(int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        this.create(n, "*LIBCRTAUT", false, true, false, "");
    }

    public void create(int n, String string, boolean bl, boolean bl2, boolean bl3, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating data queue.");
        }
        if (n < 1 || n > 64512) {
            Trace.log(2, "Value of parameter 'maxEntryLength' is not valid:", n);
            throw new ExtendedIllegalArgumentException("maxEntryLength (" + n + ")", 4);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        if (!((string = string.toUpperCase().trim()).equals("*LIBCRTAUT") || string.equals("*ALL") || string.equals("*CHANGE") || string.equals("*EXCLUDE") || string.equals("*USE"))) {
            Trace.log(2, "Value of parameter 'authority' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("authority (" + string + ")", 2);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (string2.length() > 50) {
            Trace.log(2, "Length of parameter 'description' is not valid: " + string2);
            throw new ExtendedIllegalArgumentException("description (" + string2 + ")", 1);
        }
        this.chooseImpl();
        this.attributesRetrieved_ = false;
        this.maxEntryLength_ = n;
        this.saveSenderInformation_ = bl;
        this.FIFO_ = bl2;
        this.forceToAuxiliaryStorage_ = bl3;
        this.description_ = string2;
        this.impl_.create(n, string, bl, bl2, 0, bl3, string2);
        if (this.objectListeners_ != null) {
            this.fireObjectEvent(1);
        }
        this.attributesRetrieved_ = true;
    }

    public DataQueueEntry peek() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.peek(0);
    }

    public DataQueueEntry peek(int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Peeking data queue.");
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", n);
            throw new ExtendedIllegalArgumentException("wait (" + n + ")", 2);
        }
        this.open();
        DQReceiveRecord dQReceiveRecord = this.impl_.read(null, n, true, null);
        if (dQReceiveRecord == null) {
            return null;
        }
        DataQueueEntry dataQueueEntry = new DataQueueEntry(this, dQReceiveRecord.data_, dQReceiveRecord.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(1);
        }
        return dataQueueEntry;
    }

    public DataQueueEntry read() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.read(0);
    }

    public DataQueueEntry read(int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Reading data queue.");
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", n);
            throw new ExtendedIllegalArgumentException("wait (" + n + ")", 2);
        }
        this.open();
        DQReceiveRecord dQReceiveRecord = this.impl_.read(null, n, false, null);
        if (dQReceiveRecord == null) {
            return null;
        }
        DataQueueEntry dataQueueEntry = new DataQueueEntry(this, dQReceiveRecord.data_, dQReceiveRecord.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(2);
        }
        return dataQueueEntry;
    }

    void retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving data queue attributes.");
        }
        DQQueryRecord dQQueryRecord = this.impl_.retrieveAttributes(false);
        this.maxEntryLength_ = dQQueryRecord.maxEntryLength_;
        this.saveSenderInformation_ = dQQueryRecord.saveSenderInformation_;
        this.FIFO_ = dQQueryRecord.FIFO_;
        this.forceToAuxiliaryStorage_ = dQQueryRecord.forceToAuxiliaryStorage_;
        this.description_ = dQQueryRecord.description_;
        this.attributesRetrieved_ = true;
    }

    public String toString() {
        return "DataQueue " + super.toString();
    }

    public void write(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing data queue.");
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        if (byArray.length > 64512) {
            Trace.log(2, "Length of parameter 'data' is not valid:", byArray.length);
            throw new ExtendedIllegalArgumentException("data.length (" + byArray.length + ")", 1);
        }
        this.open();
        this.impl_.write(null, byArray);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(3);
        }
    }

    public void write(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        this.write(this.stringToByteArray(string));
    }
}

