/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import java.awt.Toolkit;
import javax.swing.ProgressMonitor;

class Progress
implements Runnable {
    private ProgressMonitor progressMonitor;
    private String msg;
    private String file;
    private String endmsg;
    private int total;
    private Thread progThread_;
    private static final String CLASS = "Progress";

    public Progress(String string, int n, String string2) {
        this.total = n;
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Progress.Progress() Initializing Progress Dialog");
        }
        this.progressMonitor = new ProgressMonitor(null, string, "", 0, n);
        this.msg = string;
        this.endmsg = "% of " + n + string2;
    }

    public void updateProgress(int n) {
        this.progressMonitor.setProgress(n);
        this.progressMonitor.setNote((int)((long)n * 100L / (long)this.total) + this.endmsg);
    }

    public Thread getThread() {
        return this.progThread_;
    }

    public void setThread(Thread thread) {
        this.progThread_ = thread;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Progress.run() Progress Dialog.getMillisToPopup():" + this.progressMonitor.getMillisToPopup());
        }
        while (this.progThread_ == thread) {
            if (this.progressMonitor.isCanceled()) {
                this.progressMonitor.close();
                this.progThread_ = null;
                Toolkit.getDefaultToolkit().beep();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.progThread_ = null;
        this.progressMonitor.close();
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Progress.run() Closing Progress Dialog");
        }
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }
}

