/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ConfirmedAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;

class QueuedMessageRemoveAction
extends ConfirmedAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String confirmTitleText_ = ResourceLoader.getText("DLG_CONFIRM_REMOVE_TITLE");
    private static final String confirmMessageText_ = ResourceLoader.getText("DLG_CONFIRM_REMOVE");
    private static final String text_ = ResourceLoader.getText("ACTION_REMOVE");
    private QueuedMessage message_ = null;
    private MessageQueue queue_ = null;

    public QueuedMessageRemoveAction(VObject vObject, QueuedMessage queuedMessage, MessageQueue messageQueue) {
        super(vObject, confirmTitleText_, confirmMessageText_);
        this.message_ = queuedMessage;
        this.queue_ = messageQueue;
    }

    public String getText() {
        return text_;
    }

    public void perform2(VActionContext vActionContext) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Removing queued message [" + this.message_.getID() + "] from message queue [" + this.queue_ + "].");
        }
        this.fireStartWorking();
        boolean bl = false;
        try {
            this.queue_.remove(this.message_.getKey());
            bl = true;
        }
        catch (AS400Exception aS400Exception) {
            this.fireError(aS400Exception);
            if (aS400Exception.getAS400Message().getID().equals("CPF2410")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.fireError(exception);
        }
        this.fireStopWorking();
        if (bl) {
            this.fireObjectDeleted();
        }
    }
}

