/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter.converters;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class ResultPassThroughConverter
implements ITypeConverter<Result, Object> {
    @Override
    public boolean canConvert(Class from, Class to) {
        return Result.class.equals((Object)from) && Object.class.equals((Object)to);
    }

    @Override
    public Object convert(ValueMetaInterface meta, Result obj) throws TypeConversionException {
        Result newResult = new Result();
        try {
            if (obj instanceof Writable && newResult instanceof Writable) {
                Writables.copyWritable((Writable)obj, (Writable)newResult);
            } else {
                Method m = newResult.getClass().getMethod("copyFrom", Result.class);
                m.invoke((Object)newResult, obj);
            }
        }
        catch (IOException ex) {
            throw new TypeConversionException("Problem copying result object!", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TypeConversionException("Problem copying result object!", ex);
        }
        catch (SecurityException ex) {
            throw new TypeConversionException("Problem copying result object!", ex);
        }
        catch (IllegalAccessException ex) {
            throw new TypeConversionException("Problem copying result object!", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeConversionException("Problem copying result object!", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TypeConversionException("Problem copying result object!", ex);
        }
        return newResult;
    }
}

