/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthFactory.class);
    private HadoopThriftAuthBridge.Server saslServer = null;
    private String authTypeStr;
    private String transportMode;
    private final HiveConf conf;
    public static final String HS2_PROXY_USER = "hive.server2.proxy.user";
    public static final String HS2_CLIENT_TOKEN = "hiveserver2ClientToken";

    public HiveAuthFactory(HiveConf conf) throws TTransportException {
        this.conf = conf;
        this.transportMode = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        this.authTypeStr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        if (this.transportMode.equalsIgnoreCase("http")) {
            if (this.authTypeStr == null) {
                this.authTypeStr = AuthTypes.NOSASL.getAuthName();
            }
        } else {
            if (this.authTypeStr == null) {
                this.authTypeStr = AuthTypes.NONE.getAuthName();
            }
            if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName()) && ShimLoader.getHadoopShims().isSecureShimImpl()) {
                this.saslServer = ShimLoader.getHadoopThriftAuthBridge().createServer(conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB), conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL));
                try {
                    this.saslServer.startDelegationTokenSecretManager((Configuration)conf, null);
                }
                catch (IOException e) {
                    throw new TTransportException("Failed to start token manager", (Throwable)e);
                }
            }
        }
    }

    public Map<String, String> getSaslProperties() {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        TTransportFactory transportFactory;
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            try {
                transportFactory = this.saslServer.createTransportFactory(this.getSaslProperties());
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NONE.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.LDAP.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.PAM.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NOSASL.getAuthName())) {
            transportFactory = new TTransportFactory();
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.CUSTOM.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else {
            throw new LoginException("Unsupported authentication type " + this.authTypeStr);
        }
        return transportFactory;
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) throws LoginException {
        if (this.transportMode.equalsIgnoreCase("http")) {
            return HttpAuthUtils.getAuthProcFactory(service);
        }
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            return KerberosSaslHelper.getKerberosProcessorFactory(this.saslServer, service);
        }
        return PlainSaslHelper.getPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        if (this.saslServer != null) {
            return this.saslServer.getRemoteUser();
        }
        return null;
    }

    public String getIpAddress() {
        if (this.saslServer != null && this.saslServer.getRemoteAddress() != null) {
            return this.saslServer.getRemoteAddress().getHostAddress();
        }
        return null;
    }

    public static void loginFromKeytab(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 kerberos principal or keytab is not correctly configured");
        }
        ShimLoader.getHadoopShims().loginUserFromKeytab(principal, keyTabFile);
    }

    public static UserGroupInformation loginFromSpnegoKeytabAndReturnUGI(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
        if (!principal.isEmpty() && !keyTabFile.isEmpty()) {
            return ShimLoader.getHadoopShims().loginUserFromKeytabAndReturnUGI(principal, keyTabFile);
        }
        throw new IOException("HiveServer2 SPNego principal or keytab is not correctly configured");
    }

    public static TTransport getSocketTransport(String host, int port, int loginTimeout) throws TTransportException {
        return new TSocket(host, port, loginTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout) throws TTransportException {
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassWord);
        params.requireClientAuth(true);
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
    }

    public static TServerSocket getServerSocket(String hiveHost, int portNum) throws TTransportException {
        InetSocketAddress serverAddress = null;
        serverAddress = hiveHost != null && !hiveHost.isEmpty() ? new InetSocketAddress(hiveHost, portNum) : new InetSocketAddress(portNum);
        return new TServerSocket(serverAddress);
    }

    public static TServerSocket getServerSSLSocket(String hiveHost, int portNum, String keyStorePath, String keyStorePassWord, List<String> sslVersionBlacklist) throws TTransportException, UnknownHostException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(keyStorePath, keyStorePassWord);
        InetAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? InetAddress.getLocalHost() : InetAddress.getByName(hiveHost);
        TServerSocket thriftServerSocket = TSSLTransportFactory.getServerSocket((int)portNum, (int)0, (InetAddress)serverAddress, (TSSLTransportFactory.TSSLTransportParameters)params);
        if (thriftServerSocket.getServerSocket() instanceof SSLServerSocket) {
            ArrayList<String> sslVersionBlacklistLocal = new ArrayList<String>();
            for (String sslVersion : sslVersionBlacklist) {
                sslVersionBlacklistLocal.add(sslVersion.trim().toLowerCase());
            }
            SSLServerSocket sslServerSocket = (SSLServerSocket)thriftServerSocket.getServerSocket();
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String protocol : sslServerSocket.getEnabledProtocols()) {
                if (sslVersionBlacklistLocal.contains(protocol.toLowerCase())) {
                    LOG.debug("Disabling SSL Protocol: " + protocol);
                    continue;
                }
                enabledProtocols.add(protocol);
            }
            sslServerSocket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            LOG.info("SSL Server Socket Enabled Protocols: " + Arrays.toString(sslServerSocket.getEnabledProtocols()));
        }
        return thriftServerSocket;
    }

    public String getDelegationToken(String owner, String renewer) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication");
        }
        try {
            String tokenStr = this.saslServer.getDelegationTokenWithService(owner, renewer, HS2_CLIENT_TOKEN);
            if (tokenStr == null || tokenStr.isEmpty()) {
                throw new HiveSQLException("Received empty retrieving delegation token for user " + owner);
            }
            return tokenStr;
        }
        catch (IOException e) {
            throw new HiveSQLException("Error retrieving delegation token for user " + owner, e);
        }
        catch (InterruptedException e) {
            throw new HiveSQLException("delegation token retrieval interrupted", e);
        }
    }

    public void cancelDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication");
        }
        try {
            this.saslServer.cancelDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error canceling delegation token " + delegationToken, e);
        }
    }

    public void renewDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication");
        }
        try {
            this.saslServer.renewDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error renewing delegation token " + delegationToken, e);
        }
    }

    public String getUserFromToken(String delegationToken) throws HiveSQLException {
        if (this.saslServer == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication");
        }
        try {
            return this.saslServer.getUserFromToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error extracting user from delegation token " + delegationToken, e);
        }
    }

    public static void verifyProxyAccess(String realUser, String proxyUser, String ipAddress, HiveConf hiveConf) throws HiveSQLException {
        try {
            UserGroupInformation sessionUgi = ShimLoader.getHadoopShims().isSecurityEnabled() ? ShimLoader.getHadoopShims().createProxyUser(realUser) : ShimLoader.getHadoopShims().createRemoteUser(realUser, null);
            if (!proxyUser.equalsIgnoreCase(realUser)) {
                ShimLoader.getHadoopShims().authorizeProxyAccess(proxyUser, sessionUgi, ipAddress, (Configuration)hiveConf);
            }
        }
        catch (IOException e) {
            throw new HiveSQLException("Failed to validate proxy privilage of " + realUser + " for " + proxyUser, e);
        }
    }

    public static enum AuthTypes {
        NOSASL("NOSASL"),
        NONE("NONE"),
        LDAP("LDAP"),
        KERBEROS("KERBEROS"),
        CUSTOM("CUSTOM"),
        PAM("PAM");

        private String authType;

        private AuthTypes(String authType) {
            this.authType = authType;
        }

        public String getAuthName() {
            return this.authType;
        }
    }
}

