/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    private int requestTimeout;

    public ThriftBinaryCLIService(CLIService cliService) {
        super(cliService, "ThriftBinaryCLIService");
    }

    @Override
    public void run() {
        try {
            hiveAuthFactory = new HiveAuthFactory(this.hiveConf);
            TTransportFactory transportFactory = hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_PORT");
            this.portNum = portString != null ? Integer.valueOf(portString).intValue() : this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
            String hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
            if (hiveHost == null) {
                hiveHost = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
            }
            this.serverAddress = hiveHost != null && !hiveHost.isEmpty() ? new InetSocketAddress(hiveHost, this.portNum) : new InetSocketAddress(this.portNum);
            this.minWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS);
            this.maxWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS);
            this.workerKeepAliveTime = this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_WORKER_KEEPALIVE_TIME, TimeUnit.SECONDS);
            this.requestTimeout = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_TIMEOUT);
            String threadPoolName = "HiveServer2-Handler-Pool";
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryWithGarbageCleanup(threadPoolName));
            TServerSocket serverSocket = null;
            ArrayList<String> sslVersionBlacklist = new ArrayList<String>();
            for (String sslVersion : this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST).split(",")) {
                sslVersionBlacklist.add(sslVersion);
            }
            if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL)) {
                serverSocket = HiveAuthFactory.getServerSocket(hiveHost, this.portNum);
            } else {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                serverSocket = HiveAuthFactory.getServerSSLSocket(hiveHost, this.portNum, keyStorePath, this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD), sslVersionBlacklist);
            }
            int maxMessageSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_MESSAGE_SIZE);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).inputProtocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true, maxMessageSize))).requestTimeout(this.requestTimeout).executorService((ExecutorService)executorService);
            this.server = new TThreadPoolServer(sargs);
            LOG.info((Object)("ThriftBinaryCLIService listening on " + this.serverAddress));
            this.server.serve();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error: ", t);
        }
    }
}

