/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.ActionStats;
import org.apache.oozie.action.hadoop.ActionType;
import org.apache.oozie.action.hadoop.Credentials;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LauncherMapper;
import org.apache.oozie.action.hadoop.LauncherMapperHelper;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.PrepareActionsDriver;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class JavaActionExecutor
extends ActionExecutor {
    private static final String HADOOP_USER = "user.name";
    public static final String HADOOP_JOB_TRACKER = "mapred.job.tracker";
    public static final String HADOOP_JOB_TRACKER_2 = "mapreduce.jobtracker.address";
    public static final String HADOOP_YARN_RM = "yarn.resourcemanager.address";
    public static final String HADOOP_NAME_NODE = "fs.default.name";
    private static final String HADOOP_JOB_NAME = "mapred.job.name";
    public static final String OOZIE_COMMON_LIBDIR = "oozie";
    public static final int MAX_EXTERNAL_STATS_SIZE_DEFAULT = Integer.MAX_VALUE;
    private static final Set<String> DISALLOWED_PROPERTIES = new HashSet<String>();
    public static final String MAX_EXTERNAL_STATS_SIZE = "oozie.external.stats.max.size";
    public static final String ACL_VIEW_JOB = "mapreduce.job.acl-view-job";
    public static final String ACL_MODIFY_JOB = "mapreduce.job.acl-modify-job";
    private static final String HADOOP_YARN_UBER_MODE = "mapreduce.job.ubertask.enable";
    public static final String OOZIE_ACTION_SHIP_LAUNCHER_JAR = "oozie.action.ship.launcher.jar";
    private boolean useLauncherJar;
    private static int maxActionOutputLen;
    private static int maxExternalStatsSize;
    private static final String SUCCEEDED = "SUCCEEDED";
    private static final String KILLED = "KILLED";
    private static final String FAILED = "FAILED";
    private static final String FAILED_KILLED = "FAILED/KILLED";
    private static final String RUNNING = "RUNNING";
    protected XLog log = XLog.getLog(this.getClass());
    private static final String QUEUE_NAME = "mapred.job.queue.name";
    private static final Set<String> SPECIAL_PROPERTIES;
    private static Set<String> FINAL_STATUS;
    private static final String ACTION_SHARELIB_FOR = "oozie.action.sharelib.for.";

    public JavaActionExecutor() {
        this("java");
    }

    protected JavaActionExecutor(String type) {
        super(type);
        this.requiresNNJT = true;
        this.useLauncherJar = this.getOozieConf().getBoolean(OOZIE_ACTION_SHIP_LAUNCHER_JAR, true);
    }

    protected String getLauncherJarName() {
        return this.getType() + "-launcher.jar";
    }

    protected List<Class> getLauncherClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(LauncherMapper.class);
        classes.add(LauncherSecurityManager.class);
        classes.add(LauncherException.class);
        classes.add(LauncherMainException.class);
        classes.add(PrepareActionsDriver.class);
        classes.addAll(Services.get().get(URIHandlerService.class).getClassesForLauncher());
        classes.add(ActionStats.class);
        classes.add(ActionType.class);
        return classes;
    }

    @Override
    public void initActionType() {
        XLog log = XLog.getLog(this.getClass());
        super.initActionType();
        maxActionOutputLen = this.getOozieConf().getInt("oozie.action.max.output.data", this.getOozieConf().getInt("oozie.servlet.CallbackServlet.max.data.len", 2048));
        maxExternalStatsSize = this.getOozieConf().getInt(MAX_EXTERNAL_STATS_SIZE, Integer.MAX_VALUE);
        maxExternalStatsSize = maxExternalStatsSize == -1 ? Integer.MAX_VALUE : maxExternalStatsSize;
        this.createLauncherJar();
        this.registerError(UnknownHostException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA001");
        this.registerError(AccessControlException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA002");
        this.registerError(DiskChecker.DiskOutOfSpaceException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA003");
        this.registerError(QuotaExceededException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA004");
        this.registerError(SafeModeException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA005");
        this.registerError(ConnectException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "  JA006");
        this.registerError(JDOMException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA007");
        this.registerError(FileNotFoundException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA008");
        this.registerError(IOException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA009");
    }

    public void createLauncherJar() {
        if (this.useLauncherJar) {
            try {
                List<Class> classes = this.getLauncherClasses();
                Class[] launcherClasses = classes.toArray(new Class[classes.size()]);
                IOUtils.createJar(new File(this.getOozieRuntimeDir()), this.getLauncherJarName(), launcherClasses);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoClassDefFoundError err) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                err.printStackTrace(new PrintStream(baos));
                this.log.warn(baos.toString());
            }
        }
    }

    public static int getMaxExternalStatsSize() {
        return maxExternalStatsSize;
    }

    static void checkForDisallowedProps(Configuration conf, String confName) throws ActionExecutorException {
        for (String prop : DISALLOWED_PROPERTIES) {
            if (conf.get(prop) == null) continue;
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA010", "Property [{0}] not allowed in action [{1}] configuration", prop, confName);
        }
    }

    public JobConf createBaseHadoopConf(ActionExecutor.Context context, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        String jobTracker = actionXml.getChild("job-tracker", ns).getTextTrim();
        String nameNode = actionXml.getChild("name-node", ns).getTextTrim();
        JobConf conf = Services.get().get(HadoopAccessorService.class).createJobConf(jobTracker);
        conf.set(HADOOP_USER, context.getProtoActionConf().get(HADOOP_USER));
        conf.set(HADOOP_JOB_TRACKER, jobTracker);
        conf.set(HADOOP_JOB_TRACKER_2, jobTracker);
        conf.set(HADOOP_YARN_RM, jobTracker);
        conf.set(HADOOP_NAME_NODE, nameNode);
        conf.set("mapreduce.fileoutputcommitter.marksuccessfuljobs", "true");
        return conf;
    }

    private void injectLauncherProperties(Configuration srcConf, Configuration launcherConf) {
        for (Map.Entry entry : srcConf) {
            if (!((String)entry.getKey()).startsWith("oozie.launcher.")) continue;
            String name = ((String)entry.getKey()).substring("oozie.launcher.".length());
            String value = (String)entry.getValue();
            launcherConf.set((String)entry.getKey(), value);
            launcherConf.set(name, value);
        }
    }

    Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Namespace ns = actionXml.getNamespace();
            Element e = actionXml.getChild("configuration", ns);
            if (e != null) {
                String strConf = XmlUtils.prettyPrint(e).toString();
                XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
                XConfiguration launcherConf = new XConfiguration();
                HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
                XConfiguration actionDefaultConf = has.createActionDefaultConf(conf.get(HADOOP_JOB_TRACKER), this.getType());
                this.injectLauncherProperties(actionDefaultConf, launcherConf);
                this.injectLauncherProperties(inlineConf, launcherConf);
                this.injectLauncherUseUberMode(launcherConf);
                JavaActionExecutor.checkForDisallowedProps(launcherConf, "launcher configuration");
                XConfiguration.copy(launcherConf, conf);
            }
            return conf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
    }

    void injectLauncherUseUberMode(Configuration launcherConf) {
        if (launcherConf.get(HADOOP_YARN_UBER_MODE) == null && this.getOozieConf().getBoolean("oozie.action.launcher.mapreduce.job.ubertask.enable", false)) {
            launcherConf.setBoolean(HADOOP_YARN_UBER_MODE, true);
        }
    }

    public static void parseJobXmlAndConfiguration(ActionExecutor.Context context, Element element, Path appPath, Configuration conf) throws IOException, ActionExecutorException, HadoopAccessorException, URISyntaxException {
        Element e2;
        Namespace ns = element.getNamespace();
        for (Element e2 : element.getChildren("job-xml", ns)) {
            String jobXml = e2.getTextTrim();
            Path path = new Path(appPath, jobXml);
            FileSystem fs = context.getAppFileSystem();
            XConfiguration jobXmlConf = new XConfiguration((InputStream)fs.open(path));
            JavaActionExecutor.checkForDisallowedProps(jobXmlConf, "job-xml");
            XConfiguration.copy(jobXmlConf, conf);
        }
        e2 = element.getChild("configuration", ns);
        if (e2 != null) {
            String strConf = XmlUtils.prettyPrint(e2).toString();
            XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
            JavaActionExecutor.checkForDisallowedProps(inlineConf, "inline configuration");
            XConfiguration.copy(inlineConf, conf);
        }
    }

    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        try {
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            XConfiguration actionDefaults = has.createActionDefaultConf(actionConf.get(HADOOP_JOB_TRACKER), this.getType());
            XConfiguration.injectDefaults(actionDefaults, actionConf);
            has.checkSupportedFilesystem(appPath.toUri());
            JavaActionExecutor.parseJobXmlAndConfiguration(context, actionXml, appPath, actionConf);
            return actionConf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
        catch (HadoopAccessorException ex) {
            throw this.convertException(ex);
        }
        catch (URISyntaxException ex) {
            throw this.convertException(ex);
        }
    }

    Configuration addToCache(Configuration conf, Path appPath, String filePath, boolean archive) throws ActionExecutorException {
        URI uri = null;
        try {
            uri = new URI(filePath);
            URI baseUri = appPath.toUri();
            if (uri.getScheme() == null) {
                String resolvedPath = uri.getPath();
                if (!resolvedPath.startsWith("/")) {
                    resolvedPath = baseUri.getPath() + "/" + resolvedPath;
                }
                uri = new URI(baseUri.getScheme(), baseUri.getAuthority(), resolvedPath, uri.getQuery(), uri.getFragment());
            }
            if (archive) {
                DistributedCache.addCacheArchive((URI)uri.normalize(), (Configuration)conf);
            } else {
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                if (fileName.endsWith(".so") || fileName.contains(".so.")) {
                    uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), fileName);
                    DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                } else if (fileName.endsWith(".jar")) {
                    if (!fileName.contains("#")) {
                        String user = conf.get(HADOOP_USER);
                        Services.get().get(HadoopAccessorService.class).addFileToClassPath(user, new Path(uri.normalize()), conf);
                    } else {
                        DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
                    }
                } else {
                    if (!fileName.contains("#")) {
                        uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), fileName);
                    }
                    DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                }
            }
            DistributedCache.createSymlink((Configuration)conf);
            return conf;
        }
        catch (Exception ex) {
            XLog.getLog(this.getClass()).debug("Errors when add to DistributedCache. Path=" + uri.toString() + ", archive=" + archive + ", conf=" + XmlUtils.prettyPrint(conf).toString());
            throw this.convertException(ex);
        }
    }

    String getOozieLauncherJar(ActionExecutor.Context context) throws ActionExecutorException {
        try {
            return new Path(context.getActionDir(), this.getLauncherJarName()).toString();
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void prepareActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        block6: {
            try {
                Path actionDir = context.getActionDir();
                Path tempActionDir = new Path(actionDir.getParent(), actionDir.getName() + ".tmp");
                if (actionFs.exists(actionDir)) break block6;
                try {
                    if (this.useLauncherJar) {
                        actionFs.copyFromLocalFile(new Path(this.getOozieRuntimeDir(), this.getLauncherJarName()), new Path(tempActionDir, this.getLauncherJarName()));
                    } else {
                        actionFs.mkdirs(tempActionDir);
                    }
                    actionFs.rename(tempActionDir, actionDir);
                }
                catch (IOException ex) {
                    actionFs.delete(tempActionDir, true);
                    actionFs.delete(actionDir, true);
                    throw ex;
                }
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    void cleanUpActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Path actionDir = context.getActionDir();
            if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false) && actionFs.exists(actionDir)) {
                actionFs.delete(actionDir, true);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    protected void addShareLib(Path appPath, Configuration conf, String[] actionShareLibNames) throws ActionExecutorException {
        if (actionShareLibNames != null) {
            for (String actionShareLibName : actionShareLibNames) {
                try {
                    FileStatus[] files;
                    Path systemLibPath = Services.get().get(WorkflowAppService.class).getSystemLibPath();
                    if (systemLibPath == null) continue;
                    Path actionLibPath = new Path(systemLibPath, actionShareLibName.trim());
                    String user = conf.get(HADOOP_USER);
                    FileSystem fs = actionLibPath.toUri().getScheme() != null && actionLibPath.toUri().getAuthority() != null ? Services.get().get(HadoopAccessorService.class).createFileSystem(user, actionLibPath.toUri(), conf) : Services.get().get(HadoopAccessorService.class).createFileSystem(user, appPath.toUri(), conf);
                    if (!fs.exists(actionLibPath)) continue;
                    for (FileStatus file : files = fs.listStatus(actionLibPath)) {
                        this.addToCache(conf, actionLibPath, file.getPath().toUri().getPath(), false);
                    }
                }
                catch (HadoopAccessorException ex) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, ex.getErrorCode().toString(), ex.getMessage());
                }
                catch (IOException ex) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
                }
            }
        }
    }

    protected void addActionLibs(Path appPath, Configuration conf) throws ActionExecutorException {
        String[] actionLibsStrArr = conf.getStrings("oozie.launcher.oozie.libpath");
        if (actionLibsStrArr != null) {
            try {
                for (String actionLibsStr : actionLibsStrArr) {
                    FileStatus[] files;
                    if ((actionLibsStr = actionLibsStr.trim()).length() <= 0) continue;
                    Path actionLibsPath = new Path(actionLibsStr);
                    String user = conf.get(HADOOP_USER);
                    FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, appPath.toUri(), conf);
                    if (!fs.exists(actionLibsPath)) continue;
                    for (FileStatus file : files = fs.listStatus(actionLibsPath)) {
                        this.addToCache(conf, appPath, file.getPath().toUri().getPath(), false);
                    }
                }
            }
            catch (HadoopAccessorException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, ex.getErrorCode().toString(), ex.getMessage());
            }
            catch (IOException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
            }
        }
    }

    void setLibFilesArchives(ActionExecutor.Context context, Element actionXml, Path appPath, Configuration conf) throws ActionExecutorException {
        String[] paths;
        Configuration proto = context.getProtoActionConf();
        if (this.useLauncherJar) {
            this.addToCache(conf, appPath, this.getOozieLauncherJar(context), false);
        }
        if ((paths = proto.getStrings("oozie.wf.application.lib")) != null) {
            for (String path : paths) {
                this.addToCache(conf, appPath, path, false);
            }
        }
        this.addActionLibs(appPath, conf);
        for (Element eProp : actionXml.getChildren()) {
            String[] archivePaths;
            if (eProp.getName().equals("file")) {
                String[] filePaths;
                for (String path : filePaths = eProp.getTextTrim().split(",")) {
                    this.addToCache(conf, appPath, path.trim(), false);
                }
                continue;
            }
            if (!eProp.getName().equals("archive")) continue;
            for (String path : archivePaths = eProp.getTextTrim().split(",")) {
                this.addToCache(conf, appPath, path.trim(), true);
            }
        }
        this.addAllShareLibs(appPath, conf, context, actionXml);
    }

    private void addAllShareLibs(Path appPath, Configuration conf, ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        this.addActionShareLib(appPath, conf, context, actionXml);
        this.addShareLib(appPath, conf, new String[]{OOZIE_COMMON_LIBDIR});
    }

    private void addActionShareLib(Path appPath, Configuration conf, ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        XConfiguration wfJobConf = null;
        try {
            wfJobConf = new XConfiguration(new StringReader(context.getWorkflow().getConf()));
        }
        catch (IOException ioe) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ioe.getMessage());
        }
        if (wfJobConf.getBoolean("oozie.use.system.libpath", false)) {
            this.addShareLib(appPath, conf, this.getShareLibNames(context, actionXml, conf));
        }
    }

    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        Element e = actionXml.getChild("main-class", ns);
        return e.getTextTrim();
    }

    JobConf createLauncherConf(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action, Element actionXml, Configuration actionConf) throws ActionExecutorException {
        try {
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            JobConf launcherJobConf = this.createBaseHadoopConf(context, actionXml);
            this.setupLauncherConf((Configuration)launcherJobConf, actionXml, appPathRoot, context);
            String actionShareLibProperty = actionConf.get(ACTION_SHARELIB_FOR + this.getType());
            if (actionShareLibProperty != null) {
                launcherJobConf.set(ACTION_SHARELIB_FOR + this.getType(), actionShareLibProperty);
            }
            this.setLibFilesArchives(context, actionXml, appPathRoot, (Configuration)launcherJobConf);
            String jobName = launcherJobConf.get(HADOOP_JOB_NAME);
            if (jobName == null || jobName.isEmpty()) {
                jobName = XLog.format("oozie:launcher:T={0}:W={1}:A={2}:ID={3}", this.getType(), context.getWorkflow().getAppName(), action.getName(), context.getWorkflow().getId());
                launcherJobConf.setJobName(jobName);
            }
            String jobId = context.getWorkflow().getId();
            String actionId = action.getId();
            Path actionDir = context.getActionDir();
            String recoveryId = context.getRecoveryId();
            Namespace ns = actionXml.getNamespace();
            Element prepareElement = actionXml.getChild("prepare", ns);
            String prepareXML = "";
            if (prepareElement != null && prepareElement.getChildren().size() > 0) {
                prepareXML = XmlUtils.prettyPrint(prepareElement).toString().trim();
            }
            LauncherMapperHelper.setupLauncherInfo(launcherJobConf, jobId, actionId, actionDir, recoveryId, actionConf, prepareXML);
            LauncherMapperHelper.setupMainClass((Configuration)launcherJobConf, this.getLauncherMain((Configuration)launcherJobConf, actionXml));
            LauncherMapperHelper.setupLauncherURIHandlerConf((Configuration)launcherJobConf);
            LauncherMapperHelper.setupMaxOutputData((Configuration)launcherJobConf, maxActionOutputLen);
            LauncherMapperHelper.setupMaxExternalStatsSize((Configuration)launcherJobConf, maxExternalStatsSize);
            List list = actionXml.getChildren("arg", ns);
            String[] args = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                args[i] = ((Element)list.get(i)).getTextTrim();
            }
            LauncherMapperHelper.setupMainArguments((Configuration)launcherJobConf, args);
            List javaopts = actionXml.getChildren("java-opt", ns);
            for (Element opt : javaopts) {
                String opts = launcherJobConf.get("mapred.child.java.opts", "");
                opts = opts + " " + opt.getTextTrim();
                opts = opts.trim();
                launcherJobConf.set("mapred.child.java.opts", opts);
            }
            Element opt = actionXml.getChild("java-opts", ns);
            if (opt != null) {
                String opts = launcherJobConf.get("mapred.child.java.opts", "");
                opts = opts + " " + opt.getTextTrim();
                opts = opts.trim();
                launcherJobConf.set("mapred.child.java.opts", opts);
            }
            this.actionConfToLauncherConf(actionConf, launcherJobConf);
            launcherJobConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", false);
            return launcherJobConf;
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private void injectCallback(ActionExecutor.Context context, Configuration conf) {
        String callback = context.getCallbackUrl("$jobStatus");
        if (conf.get("job.end.notification.url") != null) {
            XLog.getLog(this.getClass()).warn("Overriding the action job end notification URI");
        }
        conf.set("job.end.notification.url", callback);
    }

    void injectActionCallback(ActionExecutor.Context context, Configuration actionConf) {
        this.injectCallback(context, actionConf);
    }

    void injectLauncherCallback(ActionExecutor.Context context, Configuration launcherConf) {
        this.injectCallback(context, launcherConf);
    }

    private void actionConfToLauncherConf(Configuration actionConf, JobConf launcherConf) {
        for (String name : SPECIAL_PROPERTIES) {
            if (actionConf.get(name) == null || launcherConf.get("oozie.launcher." + name) != null) continue;
            launcherConf.set(name, actionConf.get(name));
        }
    }

    public void submitLauncher(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            RunningJob runningJob;
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            Element actionXml = XmlUtils.parseXml(action.getConf());
            JobConf actionConf = this.createBaseHadoopConf(context, actionXml);
            this.setupActionConf((Configuration)actionConf, context, actionXml, appPathRoot);
            XLog.getLog(this.getClass()).debug("Setting LibFilesArchives ");
            this.setLibFilesArchives(context, actionXml, appPathRoot, (Configuration)actionConf);
            String jobName = actionConf.get(HADOOP_JOB_NAME);
            if (jobName == null || jobName.isEmpty()) {
                jobName = XLog.format("oozie:action:T={0}:W={1}:A={2}:ID={3}", this.getType(), context.getWorkflow().getAppName(), action.getName(), context.getWorkflow().getId());
                actionConf.set(HADOOP_JOB_NAME, jobName);
            }
            this.injectActionCallback(context, (Configuration)actionConf);
            if ((actionConf.get(ACL_MODIFY_JOB) == null || actionConf.get(ACL_MODIFY_JOB).trim().equals("")) && context.getWorkflow().getAcl() != null) {
                actionConf.set(ACL_MODIFY_JOB, context.getWorkflow().getAcl());
            }
            HashMap<String, CredentialsProperties> credentialsProperties = this.setCredentialPropertyToActionConf(context, action, (Configuration)actionConf);
            JobConf credentialsConf = new JobConf(false);
            XConfiguration.copy((Configuration)actionConf, (Configuration)credentialsConf);
            this.setCredentialTokens(credentialsConf, context, action, credentialsProperties);
            for (Map.Entry entry : credentialsConf) {
                if (actionConf.get((String)entry.getKey()) != null) continue;
                actionConf.set((String)entry.getKey(), (String)entry.getValue());
            }
            JobConf launcherJobConf = this.createLauncherConf(actionFs, context, action, actionXml, (Configuration)actionConf);
            this.injectLauncherCallback(context, (Configuration)launcherJobConf);
            XLog.getLog(this.getClass()).debug("Creating Job Client for action " + action.getId());
            jobClient = this.createJobClient(context, launcherJobConf);
            String launcherId = LauncherMapperHelper.getRecoveryId((Configuration)launcherJobConf, context.getActionDir(), context.getRecoveryId());
            boolean alreadyRunning = launcherId != null;
            boolean isUserRetry = ((WorkflowActionBean)action).isUserRetry();
            if (alreadyRunning && !isUserRetry) {
                runningJob = jobClient.getJob(JobID.forName((String)launcherId));
                if (runningJob == null) {
                    String jobTracker = launcherJobConf.get(HADOOP_JOB_TRACKER);
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA017", "unknown job [{0}@{1}], cannot recover", launcherId, jobTracker);
                }
            } else {
                XLog.getLog(this.getClass()).debug("Submitting the job through Job Client for action " + action.getId());
                HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
                Token mrdt = jobClient.getDelegationToken(has.getMRDelegationTokenRenewer(launcherJobConf));
                launcherJobConf.getCredentials().addToken(HadoopAccessorService.MR_TOKEN_ALIAS, mrdt);
                if (this.needInjectCredentials()) {
                    for (Token tk : credentialsConf.getCredentials().getAllTokens()) {
                        this.log.debug("ADDING TOKEN: " + tk.getKind().toString());
                        launcherJobConf.getCredentials().addToken(tk.getKind(), tk);
                    }
                } else {
                    this.log.info("No need to inject credentials.");
                }
                runningJob = jobClient.submitJob(launcherJobConf);
                if (runningJob == null) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA017", "Error submitting launcher for action [{0}]", action.getId());
                }
                launcherId = runningJob.getID().toString();
                XLog.getLog(this.getClass()).debug("After submission get the launcherId " + launcherId);
            }
            String jobTracker = launcherJobConf.get(HADOOP_JOB_TRACKER);
            String consoleUrl = runningJob.getTrackingURL();
            context.setStartData(launcherId, jobTracker, consoleUrl);
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.log.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    private boolean needInjectCredentials() {
        boolean methodExists = true;
        try {
            Class<?> klass = Class.forName("org.apache.hadoop.mapred.JobConf");
            klass.getMethod("getCredentials", new Class[0]);
        }
        catch (ClassNotFoundException ex) {
            methodExists = false;
        }
        catch (NoSuchMethodException ex) {
            methodExists = false;
        }
        return methodExists;
    }

    protected HashMap<String, CredentialsProperties> setCredentialPropertyToActionConf(ActionExecutor.Context context, WorkflowAction action, Configuration actionConf) throws Exception {
        HashMap<String, CredentialsProperties> credPropertiesMap = null;
        if (context != null && action != null) {
            credPropertiesMap = this.getActionCredentialsProperties(context, action);
            if (credPropertiesMap != null) {
                for (String key : credPropertiesMap.keySet()) {
                    CredentialsProperties prop = credPropertiesMap.get(key);
                    if (prop == null) continue;
                    this.log.debug("Credential Properties set for action : " + action.getId());
                    for (String property : prop.getProperties().keySet()) {
                        actionConf.set(property, prop.getProperties().get(property));
                        this.log.debug("property : '" + property + "', value : '" + prop.getProperties().get(property) + "'");
                    }
                }
            } else {
                this.log.warn("No credential properties found for action : " + action.getId() + ", cred : " + action.getCred());
            }
        } else {
            this.log.warn("context or action is null");
        }
        return credPropertiesMap;
    }

    protected void setCredentialTokens(JobConf jobconf, ActionExecutor.Context context, WorkflowAction action, HashMap<String, CredentialsProperties> credPropertiesMap) throws Exception {
        if (context != null && action != null && credPropertiesMap != null) {
            for (Map.Entry<String, CredentialsProperties> entry : credPropertiesMap.entrySet()) {
                String credName = entry.getKey();
                CredentialsProperties credProps = entry.getValue();
                if (credProps == null) continue;
                CredentialsProvider credProvider = new CredentialsProvider(credProps.getType());
                Credentials credentialObject = credProvider.createCredentialObject();
                if (credentialObject != null) {
                    credentialObject.addtoJobConf(jobconf, credProps, context);
                    this.log.debug("Retrieved Credential '" + credName + "' for action " + action.getId());
                    continue;
                }
                this.log.debug("Credentials object is null for name= " + credName + ", type=" + credProps.getType());
            }
        }
    }

    protected HashMap<String, CredentialsProperties> getActionCredentialsProperties(ActionExecutor.Context context, WorkflowAction action) throws Exception {
        HashMap<String, CredentialsProperties> props = new HashMap<String, CredentialsProperties>();
        if (context != null && action != null) {
            String[] credNames;
            String credsInAction = action.getCred();
            this.log.debug("Get credential '" + credsInAction + "' properties for action : " + action.getId());
            for (String credName : credNames = credsInAction.split(",")) {
                CredentialsProperties credProps = this.getCredProperties(context, credName);
                props.put(credName, credProps);
            }
        } else {
            this.log.warn("context or action is null");
        }
        return props;
    }

    protected CredentialsProperties getCredProperties(ActionExecutor.Context context, String credName) throws Exception {
        CredentialsProperties credProp = null;
        String workflowXml = ((WorkflowJobBean)context.getWorkflow()).getWorkflowInstance().getApp().getDefinition();
        XConfiguration wfjobConf = new XConfiguration(new StringReader(context.getWorkflow().getConf()));
        Element elementJob = XmlUtils.parseXml(workflowXml);
        Element credentials = elementJob.getChild("credentials", elementJob.getNamespace());
        if (credentials != null) {
            for (Element credential : credentials.getChildren("credential", credentials.getNamespace())) {
                String name = credential.getAttributeValue("name");
                String type = credential.getAttributeValue("type");
                this.log.debug("getCredProperties: Name: " + name + ", Type: " + type);
                if (!name.equalsIgnoreCase(credName)) continue;
                credProp = new CredentialsProperties(name, type);
                for (Element property : credential.getChildren("property", credential.getNamespace())) {
                    String propertyName = property.getChildText("name", property.getNamespace());
                    String propertyValue = property.getChildText("value", property.getNamespace());
                    ELEvaluator eval = new ELEvaluator();
                    Iterator i$ = wfjobConf.iterator();
                    while (i$.hasNext()) {
                        Map.Entry entry = (Map.Entry)i$.next();
                        eval.setVariable((String)entry.getKey(), ((String)entry.getValue()).trim());
                    }
                    propertyName = eval.evaluate(propertyName, String.class);
                    propertyValue = eval.evaluate(propertyValue, String.class);
                    credProp.getProperties().put(propertyName, propertyValue);
                    this.log.debug("getCredProperties: Properties name :'" + propertyName + "', Value : '" + propertyValue + "'");
                }
            }
        } else {
            this.log.warn("credentials is null for the action");
        }
        return credProp;
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            XLog.getLog(this.getClass()).debug("Starting action " + action.getId() + " getting Action File System");
            FileSystem actionFs = context.getAppFileSystem();
            XLog.getLog(this.getClass()).debug("Preparing action Dir through copying " + context.getActionDir());
            this.prepareActionDir(actionFs, context);
            XLog.getLog(this.getClass()).debug("Action Dir is ready. Submitting the action ");
            this.submitLauncher(actionFs, context, action);
            XLog.getLog(this.getClass()).debug("Action submit completed. Performing check ");
            this.check(context, action);
            XLog.getLog(this.getClass()).debug("Action check is done after submission");
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            String externalStatus = action.getExternalStatus();
            WorkflowAction.Status status = externalStatus.equals(SUCCEEDED) ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
            context.setEndData(status, this.getActionSignal(status));
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        finally {
            try {
                FileSystem actionFs = context.getAppFileSystem();
                this.cleanUpActionDir(actionFs, context);
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    protected JobClient createJobClient(ActionExecutor.Context context, JobConf jobConf) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        String group = context.getWorkflow().getGroup();
        return Services.get().get(HadoopAccessorService.class).createJobClient(user, jobConf);
    }

    protected RunningJob getRunningJob(ActionExecutor.Context context, WorkflowAction action, JobClient jobClient) throws Exception {
        RunningJob runningJob = jobClient.getJob(JobID.forName((String)action.getExternalId()));
        return runningJob;
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            FileSystem actionFs = context.getAppFileSystem();
            JobConf jobConf = this.createBaseHadoopConf(context, actionXml);
            jobClient = this.createJobClient(context, jobConf);
            RunningJob runningJob = this.getRunningJob(context, action, jobClient);
            if (runningJob == null) {
                context.setExternalStatus(FAILED);
                context.setExecutionData(FAILED, null);
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", action.getExternalId(), action.getId());
            }
            if (runningJob.isComplete()) {
                String group;
                Path actionDir = context.getActionDir();
                String user = context.getWorkflow().getUser();
                if (LauncherMapperHelper.hasIdSwap(runningJob, user, group = context.getWorkflow().getGroup(), actionDir)) {
                    String launcherId = action.getExternalId();
                    Path idSwapPath = LauncherMapperHelper.getIdSwapPath(context.getActionDir());
                    FSDataInputStream is = actionFs.open(idSwapPath);
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
                    Properties props = PropertiesUtils.readProperties(reader, maxActionOutputLen);
                    reader.close();
                    String newId = props.getProperty("id");
                    runningJob = jobClient.getJob(JobID.forName((String)newId));
                    if (runningJob == null) {
                        context.setExternalStatus(FAILED);
                        throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", newId, action.getId());
                    }
                    context.setExternalChildIDs(newId);
                    XLog.getLog(this.getClass()).info(1, "External ID swap, old ID [{0}] new ID [{1}]", launcherId, newId);
                }
                if (runningJob.isComplete()) {
                    XLog.getLog(this.getClass()).info(1, "action completed, external ID [{0}]", action.getExternalId());
                    if (runningJob.isSuccessful() && LauncherMapperHelper.isMainSuccessful(runningJob)) {
                        this.getActionData(actionFs, runningJob, action, context);
                        XLog.getLog(this.getClass()).info(1, "action produced output", new Object[0]);
                    } else {
                        String errorReason;
                        XLog log = XLog.getLog(this.getClass());
                        Path actionError = LauncherMapperHelper.getErrorPath(context.getActionDir());
                        if (actionFs.exists(actionError)) {
                            FSDataInputStream is = actionFs.open(actionError);
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
                            Properties props = PropertiesUtils.readProperties(reader, -1);
                            reader.close();
                            String errorCode = props.getProperty("error.code");
                            if (errorCode.equals("0")) {
                                errorCode = "JA018";
                            }
                            if (errorCode.equals("-1")) {
                                errorCode = "JA019";
                            }
                            errorReason = props.getProperty("error.reason");
                            log.warn("Launcher ERROR, reason: {0}", errorReason);
                            String exMsg = props.getProperty("exception.message");
                            String errorInfo = exMsg != null ? exMsg : errorReason;
                            context.setErrorInfo(errorCode, errorInfo);
                            String exStackTrace = props.getProperty("exception.stacktrace");
                            if (exMsg != null) {
                                log.warn("Launcher exception: {0}{E}{1}", exMsg, exStackTrace);
                            }
                        } else {
                            errorReason = XLog.format("LauncherMapper died, check Hadoop log for job [{0}:{1}]", action.getTrackerUri(), action.getExternalId());
                            log.warn(errorReason);
                        }
                        context.setExecutionData(FAILED_KILLED, null);
                        this.setActionCompletionData(context, actionFs);
                    }
                } else {
                    context.setExternalStatus(RUNNING);
                    XLog.getLog(this.getClass()).info(1, "checking action, external ID [{0}] status [{1}]", action.getExternalId(), action.getExternalStatus());
                }
            } else {
                context.setExternalStatus(RUNNING);
                XLog.getLog(this.getClass()).info(1, "checking action, external ID [{0}] status [{1}]", action.getExternalId(), action.getExternalStatus());
            }
        }
        catch (Exception ex) {
            XLog.getLog(this.getClass()).warn("Exception in check(). Message[{0}]", ex.getMessage(), ex);
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.log.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    protected void getActionData(FileSystem actionFs, RunningJob runningJob, WorkflowAction action, ActionExecutor.Context context) throws HadoopAccessorException, JDOMException, IOException, URISyntaxException {
        Properties props = null;
        if (this.getCaptureOutput(action)) {
            props = new Properties();
            if (LauncherMapperHelper.hasOutputData(runningJob)) {
                Path actionOutput = LauncherMapperHelper.getOutputDataPath(context.getActionDir());
                FSDataInputStream is = actionFs.open(actionOutput);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
                props = PropertiesUtils.readProperties(reader, maxActionOutputLen);
                reader.close();
            }
        }
        context.setExecutionData(SUCCEEDED, props);
    }

    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        Namespace ns;
        Element eConf = XmlUtils.parseXml(action.getConf());
        Element captureOutput = eConf.getChild("capture-output", ns = eConf.getNamespace());
        return captureOutput != null;
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        JobClient jobClient = null;
        boolean exception = false;
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            JobConf jobConf = this.createBaseHadoopConf(context, actionXml);
            jobClient = this.createJobClient(context, jobConf);
            RunningJob runningJob = this.getRunningJob(context, action, jobClient);
            if (runningJob != null) {
                runningJob.killJob();
            }
            context.setExternalStatus(KILLED);
            context.setExecutionData(KILLED, null);
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            try {
                FileSystem actionFs = context.getAppFileSystem();
                this.cleanUpActionDir(actionFs, context);
                if (jobClient != null) {
                    jobClient.close();
                }
            }
            catch (Exception ex) {
                if (exception) {
                    this.log.error((Object)"Error: ", ex);
                }
                throw this.convertException(ex);
            }
        }
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return FINAL_STATUS.contains(externalStatus);
    }

    protected String[] getShareLibNames(ActionExecutor.Context context, Element actionXml, Configuration conf) {
        String[] names = conf.getStrings(ACTION_SHARELIB_FOR + this.getType());
        if (names == null || names.length == 0) {
            try {
                String name;
                XConfiguration jobConf = new XConfiguration(new StringReader(context.getWorkflow().getConf()));
                names = jobConf.getStrings(ACTION_SHARELIB_FOR + this.getType());
                if (!(names != null && names.length != 0 || (names = Services.get().getConf().getStrings(ACTION_SHARELIB_FOR + this.getType())) != null && names.length != 0 || (name = this.getDefaultShareLibName(actionXml)) == null)) {
                    names = new String[]{name};
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("It cannot happen, " + ex.toString(), ex);
            }
        }
        return names;
    }

    protected String getDefaultShareLibName(Element actionXml) {
        return null;
    }

    protected void setActionCompletionData(ActionExecutor.Context context, FileSystem actionFs) throws IOException, HadoopAccessorException, URISyntaxException {
    }

    static {
        DISALLOWED_PROPERTIES.add(HADOOP_USER);
        DISALLOWED_PROPERTIES.add(HADOOP_JOB_TRACKER);
        DISALLOWED_PROPERTIES.add(HADOOP_NAME_NODE);
        DISALLOWED_PROPERTIES.add(HADOOP_JOB_TRACKER_2);
        DISALLOWED_PROPERTIES.add(HADOOP_YARN_RM);
        SPECIAL_PROPERTIES = new HashSet<String>();
        SPECIAL_PROPERTIES.add(QUEUE_NAME);
        SPECIAL_PROPERTIES.add(ACL_VIEW_JOB);
        SPECIAL_PROPERTIES.add(ACL_MODIFY_JOB);
        FINAL_STATUS = new HashSet<String>();
        FINAL_STATUS.add(SUCCEEDED);
        FINAL_STATUS.add(KILLED);
        FINAL_STATUS.add(FAILED);
        FINAL_STATUS.add(FAILED_KILLED);
    }
}

