/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.LauncherMapperHelper;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.ScriptLanguageActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLog;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class PigActionExecutor
extends ScriptLanguageActionExecutor {
    private static final String PIG_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.PigMain";
    private static final String OOZIE_PIG_STATS = "org.apache.oozie.action.hadoop.OoziePigStats";
    static final String PIG_SCRIPT = "oozie.pig.script";
    static final String PIG_PARAMS = "oozie.pig.params";
    static final String PIG_ARGS = "oozie.pig.args";

    public PigActionExecutor() {
        super("pig");
    }

    @Override
    protected List<Class> getLauncherClasses() {
        List<Class> classes = super.getLauncherClasses();
        try {
            classes.add(Class.forName(PIG_MAIN_CLASS_NAME));
            classes.add(Class.forName(OOZIE_PIG_STATS));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", PIG_MAIN_CLASS_NAME);
    }

    @Override
    void injectActionCallback(ActionExecutor.Context context, Configuration launcherConf) {
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        super.setupActionConf(actionConf, context, actionXml, appPath);
        Namespace ns = actionXml.getNamespace();
        String script = actionXml.getChild("script", ns).getTextTrim();
        String pigName = new Path(script).getName();
        List params = actionXml.getChildren("param", ns);
        String[] strParams = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            strParams[i] = ((Element)params.get(i)).getTextTrim();
        }
        String[] strArgs = null;
        List eArgs = actionXml.getChildren("argument", ns);
        if (eArgs != null && eArgs.size() > 0) {
            strArgs = new String[eArgs.size()];
            for (int i = 0; i < eArgs.size(); ++i) {
                strArgs[i] = ((Element)eArgs.get(i)).getTextTrim();
            }
        }
        PigActionExecutor.setPigScript(actionConf, pigName, strParams, strArgs);
        return actionConf;
    }

    public static void setPigScript(Configuration conf, String script, String[] params, String[] args) {
        conf.set(PIG_SCRIPT, script);
        MapReduceMain.setStrings((Configuration)conf, (String)PIG_PARAMS, (String[])params);
        MapReduceMain.setStrings((Configuration)conf, (String)PIG_ARGS, (String[])args);
    }

    @Override
    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        return false;
    }

    @Override
    protected void getActionData(FileSystem actionFs, RunningJob runningJob, WorkflowAction action, ActionExecutor.Context context) throws HadoopAccessorException, JDOMException, IOException, URISyntaxException {
        super.getActionData(actionFs, runningJob, action, context);
        String stats = this.getStats(context, actionFs);
        context.setExecutionStats(stats);
        String externalChildIDs = this.getExternalChildIDs(context, actionFs);
        context.setExternalChildIDs(externalChildIDs);
    }

    private String getStats(ActionExecutor.Context context, FileSystem actionFs) throws IOException, HadoopAccessorException, URISyntaxException {
        Path actionOutput = LauncherMapperHelper.getActionStatsDataPath(context.getActionDir());
        String stats = null;
        if (actionFs.exists(actionOutput)) {
            stats = PigActionExecutor.getDataFromPath(actionOutput, actionFs);
        }
        return stats;
    }

    @Override
    protected void setActionCompletionData(ActionExecutor.Context context, FileSystem fs) throws HadoopAccessorException, IOException, URISyntaxException {
        String data = this.getExternalChildIDs(context, fs);
        context.setExternalChildIDs(data);
    }

    private String getExternalChildIDs(ActionExecutor.Context context, FileSystem actionFs) throws IOException, HadoopAccessorException, URISyntaxException {
        Path actionOutput = LauncherMapperHelper.getExternalChildIDsDataPath(context.getActionDir());
        String externalIDs = null;
        if (actionFs.exists(actionOutput)) {
            externalIDs = PigActionExecutor.getDataFromPath(actionOutput, actionFs);
            XLog.getLog(this.getClass()).info(1, "Hadoop Jobs launched : [{0}]", externalIDs);
        }
        return externalIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataFromPath(Path actionOutput, FileSystem actionFs) throws IOException {
        BufferedReader reader = null;
        String data = null;
        try {
            FSDataInputStream is = actionFs.open(actionOutput);
            reader = new BufferedReader(new InputStreamReader((InputStream)is));
            data = IOUtils.getReaderAsString(reader, -1);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return data;
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return "pig";
    }

    @Override
    protected String getScriptName() {
        return PIG_SCRIPT;
    }
}

