/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.BulkUpdateInsertForCoordActionStatusJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetForCheckJPAExecutor;
import org.apache.oozie.executor.jpa.CoordinatorJobGetForUserAppnameJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetForSLAJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.db.SLADbOperations;

public class CoordActionCheckXCommand
extends CoordinatorXCommand<Void> {
    private String actionId;
    private int actionCheckDelay;
    private CoordinatorActionBean coordAction = null;
    private CoordinatorJobBean coordJob;
    private WorkflowJobBean workflowJob;
    private JPAService jpaService = null;
    private List<JsonBean> updateList = new ArrayList<JsonBean>();
    private List<JsonBean> insertList = new ArrayList<JsonBean>();

    public CoordActionCheckXCommand(String actionId, int actionCheckDelay) {
        super("coord_action_check", "coord_action_check", 0);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
        this.actionCheckDelay = actionCheckDelay;
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            SLAEventBean slaEvent;
            InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
            WorkflowJobBean wf = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.coordAction.getExternalId()));
            SLAEvent.Status slaStatus = null;
            CoordinatorAction.Status initialStatus = this.coordAction.getStatus();
            if (wf.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                this.coordAction.setStatus(CoordinatorAction.Status.SUCCEEDED);
                this.coordAction.setPending(0);
                slaStatus = SLAEvent.Status.SUCCEEDED;
            } else if (wf.getStatus() == WorkflowJob.Status.FAILED) {
                this.coordAction.setStatus(CoordinatorAction.Status.FAILED);
                slaStatus = SLAEvent.Status.FAILED;
                this.coordAction.setPending(0);
            } else if (wf.getStatus() == WorkflowJob.Status.KILLED) {
                this.coordAction.setStatus(CoordinatorAction.Status.KILLED);
                slaStatus = SLAEvent.Status.KILLED;
                this.coordAction.setPending(0);
            } else {
                this.LOG.warn("Unexpected workflow " + wf.getId() + " STATUS " + wf.getStatus());
                this.coordAction.setLastModifiedTime(new Date());
                this.updateList.add(this.coordAction);
                this.jpaService.execute(new BulkUpdateInsertForCoordActionStatusJPAExecutor(this.updateList, null));
                return null;
            }
            this.LOG.debug("Updating Coordintaor actionId :" + this.coordAction.getId() + "status to =" + this.coordAction.getStatus());
            this.coordAction.setLastModifiedTime(new Date());
            this.updateList.add(this.coordAction);
            if (slaStatus != null && (slaEvent = SLADbOperations.createStatusEvent(this.coordAction.getSlaXml(), this.coordAction.getId(), slaStatus, SLAEvent.SlaAppType.COORDINATOR_ACTION, this.LOG)) != null) {
                this.insertList.add(slaEvent);
            }
            this.jpaService.execute(new BulkUpdateInsertForCoordActionStatusJPAExecutor(this.updateList, this.insertList));
            CoordinatorAction.Status endStatus = this.coordAction.getStatus();
            if (endStatus != initialStatus && EventHandlerService.isEnabled()) {
                CoordActionCheckXCommand.generateEvent(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName(), this.workflowJob.getStartTime());
            }
        }
        catch (XException ex) {
            this.LOG.warn((Object)"CoordActionCheckCommand Failed ", ex);
            throw new CommandException(ex);
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.actionId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.coordAction = this.jpaService.execute(new CoordActionGetForCheckJPAExecutor(this.actionId));
            this.coordJob = this.jpaService.execute(new CoordinatorJobGetForUserAppnameJPAExecutor(this.coordAction.getJobId()));
            this.workflowJob = this.jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(this.coordAction.getExternalId()));
            LogUtils.setLogInfo(this.coordAction, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        Timestamp actionCheckTs = new Timestamp(System.currentTimeMillis() - (long)(this.actionCheckDelay * 1000));
        Timestamp cactionLmt = this.coordAction.getLastModifiedTimestamp();
        if (cactionLmt.after(actionCheckTs)) {
            throw new PreconditionException(ErrorCode.E1100, "The coord action :" + this.actionId + " has been udated. Ignore CoordActionCheckCommand!");
        }
        if (this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.SUCCEEDED) || this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.FAILED) || this.coordAction.getStatus().equals((Object)CoordinatorAction.Status.KILLED)) {
            throw new PreconditionException(ErrorCode.E1100, "The coord action [" + this.actionId + "] must not have status " + CoordinatorAction.Status.SUCCEEDED.name() + ", " + CoordinatorAction.Status.FAILED.name() + ", or " + CoordinatorAction.Status.KILLED.name() + " but has status [" + this.coordAction.getStatus().name() + "]");
        }
    }
}

