/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.SubmitHttpXCommand;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class SubmitScriptLanguageXCommand
extends SubmitHttpXCommand {
    public SubmitScriptLanguageXCommand(String name, String type, Configuration conf) {
        super(name, type, conf);
    }

    protected abstract String getLanguageName();

    protected abstract String getOptions();

    protected abstract String getScriptParamters();

    protected Namespace getSectionNamespace() {
        return Namespace.getNamespace((String)"uri:oozie:workflow:0.2");
    }

    private Element generateSection(Configuration conf, Namespace ns) {
        String[] args;
        String name = this.getLanguageName();
        Element ele = new Element(name, ns);
        Element jt = new Element("job-tracker", ns);
        jt.addContent(conf.get("mapred.job.tracker"));
        ele.addContent((Content)jt);
        Element nn = new Element("name-node", ns);
        nn.addContent(conf.get("fs.default.name"));
        ele.addContent((Content)nn);
        ArrayList<String> Dargs = new ArrayList<String>();
        ArrayList<String> otherArgs = new ArrayList<String>();
        for (String arg : args = MapReduceMain.getStrings((Configuration)conf, (String)this.getOptions())) {
            if (arg.startsWith("-D")) {
                Dargs.add(arg);
                continue;
            }
            otherArgs.add(arg);
        }
        String[] params = MapReduceMain.getStrings((Configuration)conf, (String)this.getScriptParamters());
        if (Dargs.size() > 0) {
            Element configuration = this.generateConfigurationSection(Dargs, ns);
            ele.addContent((Content)configuration);
        }
        Element script = new Element("script", ns);
        script.addContent("dummy." + name);
        ele.addContent((Content)script);
        for (String param : params) {
            Element parameter = new Element("param", ns);
            parameter.addContent(param);
            ele.addContent((Content)parameter);
        }
        for (String arg : otherArgs) {
            Element argument = new Element("argument", ns);
            argument.addContent(arg);
            ele.addContent((Content)argument);
        }
        SubmitScriptLanguageXCommand.addFileSection(ele, conf, ns);
        SubmitScriptLanguageXCommand.addArchiveSection(ele, conf, ns);
        return ele;
    }

    private Element generateConfigurationSection(List<String> Dargs, Namespace ns) {
        Element configuration = new Element("configuration", ns);
        for (String arg : Dargs) {
            String name = null;
            String value = null;
            int pos = arg.indexOf("=");
            if (pos == -1) {
                name = arg.substring(2, arg.length());
                value = "";
            } else {
                name = arg.substring(2, pos);
                value = arg.substring(pos + 1, arg.length());
            }
            Element property = new Element("property", ns);
            Element nameElement = new Element("name", ns);
            nameElement.addContent(name);
            property.addContent((Content)nameElement);
            Element valueElement = new Element("value", ns);
            valueElement.addContent(value);
            property.addContent((Content)valueElement);
            configuration.addContent((Content)property);
        }
        return configuration;
    }

    @Override
    protected String getWorkflowXml(Configuration conf) {
        for (String key : MANDATORY_OOZIE_CONFS) {
            String value = conf.get(key);
            if (value != null) continue;
            throw new RuntimeException(key + " is not specified");
        }
        Namespace ns = Namespace.getNamespace((String)"uri:oozie:workflow:0.2");
        Element root = new Element("workflow-app", ns);
        root.setAttribute("name", "oozie-" + this.getLanguageName());
        Element start = new Element("start", ns);
        String name = this.getLanguageName();
        String nodeName = name + "1";
        start.setAttribute("to", nodeName);
        root.addContent((Content)start);
        Element action = new Element("action", ns);
        action.setAttribute("name", nodeName);
        Element ele = this.generateSection(conf, this.getSectionNamespace());
        action.addContent((Content)ele);
        Element ok = new Element("ok", ns);
        ok.setAttribute("to", "end");
        action.addContent((Content)ok);
        Element error = new Element("error", ns);
        error.setAttribute("to", "fail");
        action.addContent((Content)error);
        root.addContent((Content)action);
        Element kill = new Element("kill", ns);
        kill.setAttribute("name", "fail");
        Element message = new Element("message", ns);
        message.addContent(name + " failed, error message[${wf:errorMessage(wf:lastErrorNode())}]");
        kill.addContent((Content)message);
        root.addContent((Content)kill);
        Element end = new Element("end", ns);
        end.setAttribute("name", "end");
        root.addContent((Content)end);
        return XmlUtils.prettyPrint(root).toString();
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() {
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }
}

