/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class BundleJobsGetForPurgeJPAExecutor
implements JPAExecutor<List<String>> {
    private static final long DAY_IN_MS = 86400000L;
    private long olderThanDays;
    private int limit;
    private int offset;

    public BundleJobsGetForPurgeJPAExecutor(long olderThanDays, int limit) {
        this(olderThanDays, 0, limit);
    }

    public BundleJobsGetForPurgeJPAExecutor(long olderThanDays, int offset, int limit) {
        this.olderThanDays = olderThanDays;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "BundleJobsGetForPurgeJPAExecutor";
    }

    @Override
    public List<String> execute(EntityManager em) throws JPAExecutorException {
        List bundleJobs = null;
        try {
            Timestamp lastModTm = new Timestamp(System.currentTimeMillis() - this.olderThanDays * 86400000L);
            Query jobQ = em.createNamedQuery("GET_COMPLETED_BUNDLE_JOBS_OLDER_THAN");
            jobQ.setParameter("lastModTime", (Object)lastModTm);
            jobQ.setMaxResults(this.limit);
            jobQ.setFirstResult(this.offset);
            bundleJobs = jobQ.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return bundleJobs;
    }
}

