/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionUpdateForModifiedTimeJPAExecutor
implements JPAExecutor<Void> {
    private CoordinatorActionBean coordAction = null;

    public CoordActionUpdateForModifiedTimeJPAExecutor(CoordinatorActionBean coordAction) {
        ParamChecker.notNull(coordAction, "coordAction");
        this.coordAction = coordAction;
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("UPDATE_COORD_ACTION_FOR_MODIFIED_DATE");
            q.setParameter("id", (Object)this.coordAction.getId());
            q.setParameter("lastModifiedTime", (Object)new Date());
            q.executeUpdate();
            return null;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
    }

    @Override
    public String getName() {
        return "CoordActionUpdateForModifiedTimeJPAExecutor";
    }
}

