/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class CoordJobsCountNotForPurgeFromParentIdJPAExecutor
implements JPAExecutor<Long> {
    private static final long DAY_IN_MS = 86400000L;
    private long olderThanDays;
    private String parentId;

    public CoordJobsCountNotForPurgeFromParentIdJPAExecutor(long olderThanDays, String parentId) {
        this.olderThanDays = olderThanDays;
        this.parentId = parentId;
    }

    @Override
    public String getName() {
        return "CoordChildrenCountNotForPurgeJPAExecutor";
    }

    @Override
    public Long execute(EntityManager em) throws JPAExecutorException {
        Long count = 0L;
        try {
            Timestamp lastModTm = new Timestamp(System.currentTimeMillis() - this.olderThanDays * 86400000L);
            Query jobQ = em.createNamedQuery("GET_COORD_COUNT_WITH_PARENT_ID_NOT_READY_FOR_PURGE");
            jobQ.setParameter("parentId", (Object)this.parentId);
            jobQ.setParameter("lastModTime", (Object)lastModTm);
            count = (Long)jobQ.getSingleResult();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return count;
    }
}

