/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa.sla;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.ParamChecker;

public class SLASummaryUpdateForSLAStatusActualTimesJPAExecutor
implements JPAExecutor<Void> {
    private SLASummaryBean slaSummaryBean = null;

    public SLASummaryUpdateForSLAStatusActualTimesJPAExecutor(SLASummaryBean slaSummaryBean) {
        ParamChecker.notNull(slaSummaryBean, "slaSummaryBean");
        this.slaSummaryBean = slaSummaryBean;
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES");
            q.setParameter("jobId", (Object)this.slaSummaryBean.getId());
            q.setParameter("slaStatus", (Object)this.slaSummaryBean.getSLAStatusString());
            q.setParameter("lastModifiedTS", (Object)new Date());
            q.setParameter("eventStatus", (Object)this.slaSummaryBean.getEventStatusString());
            q.setParameter("jobStatus", (Object)this.slaSummaryBean.getJobStatus());
            q.setParameter("eventProcessed", (Object)this.slaSummaryBean.getEventProcessed());
            q.setParameter("actualStartTS", (Object)this.slaSummaryBean.getActualStart());
            q.setParameter("actualEndTS", (Object)this.slaSummaryBean.getActualEnd());
            q.setParameter("actualDuration", (Object)this.slaSummaryBean.getActualDuration());
            q.executeUpdate();
            return null;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "SLASummaryUpdateForSLAStatusActualTimesJPAExecutor";
    }
}

