/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.executor.jpa.CoordActionsActiveCountJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsToBeMaterializedJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XLog;

public class CoordMaterializeTriggerService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.CoordMaterializeTriggerService.";
    public static final String CONF_LOOKUP_INTERVAL = "oozie.service.CoordMaterializeTriggerService.lookup.interval";
    public static final String CONF_MATERIALIZATION_WINDOW = "oozie.service.CoordMaterializeTriggerService.materialization.window";
    public static final String CONF_CALLABLE_BATCH_SIZE = "oozie.service.CoordMaterializeTriggerService.callable.batch.size";
    public static final String CONF_MATERIALIZATION_SYSTEM_LIMIT = "oozie.service.CoordMaterializeTriggerService.materialization.system.limit";
    private static final String INSTRUMENTATION_GROUP = "coord_job_mat";
    private static final String INSTR_MAT_JOBS_COUNTER = "jobs";
    private static final int CONF_LOOKUP_INTERVAL_DEFAULT = 300;
    private static final int CONF_MATERIALIZATION_WINDOW_DEFAULT = 3600;
    private static final int CONF_MATERIALIZATION_SYSTEM_LIMIT_DEFAULT = 50;

    @Override
    public void init(Services services) throws ServiceException {
        Configuration conf = services.getConf();
        int materializationWindow = conf.getInt(CONF_MATERIALIZATION_WINDOW, 3600);
        int lookupInterval = Services.get().getConf().getInt(CONF_LOOKUP_INTERVAL, 300);
        CoordMaterializeTriggerRunnable lookupTriggerJobsRunnable = new CoordMaterializeTriggerRunnable(materializationWindow, lookupInterval);
        services.get(SchedulerService.class).schedule(lookupTriggerJobsRunnable, 10L, (long)lookupInterval, SchedulerService.Unit.SEC);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return CoordMaterializeTriggerService.class;
    }

    static class CoordMaterializeTriggerRunnable
    implements Runnable {
        private int materializationWindow;
        private int lookupInterval;
        private long delay = 0L;
        private List<XCallable<Void>> callables;
        private List<XCallable<Void>> delayedCallables;

        public CoordMaterializeTriggerRunnable(int materializationWindow, int lookupInterval) {
            this.materializationWindow = materializationWindow;
            this.lookupInterval = lookupInterval;
        }

        @Override
        public void run() {
            boolean ret;
            this.runCoordJobMatLookup();
            if (null != this.callables) {
                ret = Services.get().get(CallableQueueService.class).queueSerial(this.callables);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the callables commands for CoordMaterializeTriggerRunnable. Most possibly command queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.callables = null;
            }
            if (null != this.delayedCallables) {
                ret = Services.get().get(CallableQueueService.class).queueSerial(this.delayedCallables, this.delay);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the delayedCallables commands for CoordMaterializeTriggerRunnable. Most possibly Callable queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.delayedCallables = null;
                this.delay = 0L;
            }
        }

        private void runCoordJobMatLookup() {
            XLog.Info.get().clear();
            XLog LOG = XLog.getLog(this.getClass());
            JPAService jpaService = Services.get().get(JPAService.class);
            try {
                Date currDate = new Date(new Date().getTime() + (long)(this.lookupInterval * 1000));
                int materializationLimit = Services.get().getConf().getInt(CoordMaterializeTriggerService.CONF_MATERIALIZATION_SYSTEM_LIMIT, 50);
                CoordJobsToBeMaterializedJPAExecutor cmatcmd = new CoordJobsToBeMaterializedJPAExecutor(currDate, materializationLimit);
                List<CoordinatorJobBean> materializeJobs = jpaService.execute(cmatcmd);
                LOG.info("CoordMaterializeTriggerService - Curr Date= " + currDate + ", Num jobs to materialize = " + materializeJobs.size());
                for (CoordinatorJobBean coordJob : materializeJobs) {
                    if (!Services.get().get(JobsConcurrencyService.class).isJobIdForThisServer(coordJob.getId())) continue;
                    Services.get().get(InstrumentationService.class).get().incr(CoordMaterializeTriggerService.INSTRUMENTATION_GROUP, CoordMaterializeTriggerService.INSTR_MAT_JOBS_COUNTER, 1L);
                    int numWaitingActions = jpaService.execute(new CoordActionsActiveCountJPAExecutor(coordJob.getId()));
                    LOG.info("Job :" + coordJob.getId() + "  numWaitingActions : " + numWaitingActions + " MatThrottle : " + coordJob.getMatThrottling());
                    coordJob.setLastModifiedTime(new Date());
                    jpaService.execute(new CoordJobUpdateJPAExecutor(coordJob));
                    if (numWaitingActions >= coordJob.getMatThrottling()) {
                        LOG.info("info for JobID [" + coordJob.getId() + " already waiting " + numWaitingActions + " actions. MatThrottle is : " + coordJob.getMatThrottling());
                        continue;
                    }
                    this.queueCallable(new CoordMaterializeTransitionXCommand(coordJob.getId(), this.materializationWindow));
                }
            }
            catch (JPAExecutorException jex) {
                LOG.warn((Object)"JPAExecutorException while attempting to materialize coordinator jobs", jex);
            }
            catch (Exception ex) {
                LOG.error("Exception while attempting to materialize coordinator jobs, {0}", ex.getMessage(), ex);
            }
        }

        private void queueCallable(XCallable<Void> callable) {
            if (this.callables == null) {
                this.callables = new ArrayList<XCallable<Void>>();
            }
            this.callables.add(callable);
            if (this.callables.size() == Services.get().getConf().getInt(CoordMaterializeTriggerService.CONF_CALLABLE_BATCH_SIZE, 10)) {
                boolean ret = Services.get().get(CallableQueueService.class).queueSerial(this.callables);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the callables commands for CoordMaterializeTriggerRunnable. Most possibly command queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.callables = new ArrayList<XCallable<Void>>();
            }
        }
    }
}

