/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.rest.JsonBundleJob;
import org.apache.oozie.client.rest.JsonCoordinatorAction;
import org.apache.oozie.client.rest.JsonCoordinatorJob;
import org.apache.oozie.client.rest.JsonSLAEvent;
import org.apache.oozie.client.rest.JsonWorkflowAction;
import org.apache.oozie.client.rest.JsonWorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;

public class JPAService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP = "jpa";
    public static final String CONF_DB_SCHEMA = "oozie.db.schema.name";
    public static final String CONF_PREFIX = "oozie.service.JPAService.";
    public static final String CONF_URL = "oozie.service.JPAService.jdbc.url";
    public static final String CONF_DRIVER = "oozie.service.JPAService.jdbc.driver";
    public static final String CONF_USERNAME = "oozie.service.JPAService.jdbc.username";
    public static final String CONF_PASSWORD = "oozie.service.JPAService.jdbc.password";
    public static final String CONF_CONN_DATA_SOURCE = "oozie.service.JPAService.connection.data.source";
    public static final String CONF_MAX_ACTIVE_CONN = "oozie.service.JPAService.pool.max.active.conn";
    public static final String CONF_CREATE_DB_SCHEMA = "oozie.service.JPAService.create.db.schema";
    public static final String CONF_VALIDATE_DB_CONN = "oozie.service.JPAService.validate.db.connection";
    public static final String CONF_VALIDATE_DB_CONN_EVICTION_INTERVAL = "oozie.service.JPAService.validate.db.connection.eviction.interval";
    public static final String CONF_VALIDATE_DB_CONN_EVICTION_NUM = "oozie.service.JPAService.validate.db.connection.eviction.num";
    private EntityManagerFactory factory;
    private Instrumentation instr;
    private static XLog LOG;

    @Override
    public Class<? extends Service> getInterface() {
        return JPAService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        this.instr = instr;
    }

    @Override
    public void init(Services services) throws ServiceException {
        LOG = XLog.getLog(JPAService.class);
        Configuration conf = services.getConf();
        String dbSchema = conf.get(CONF_DB_SCHEMA, "oozie");
        String url = conf.get(CONF_URL, "jdbc:derby:${oozie.home.dir}/${oozie.db.schema.name}-db;create=true");
        String driver = conf.get(CONF_DRIVER, "org.apache.derby.jdbc.EmbeddedDriver");
        String user = conf.get(CONF_USERNAME, "sa");
        String password = conf.get(CONF_PASSWORD, "").trim();
        String maxConn = conf.get(CONF_MAX_ACTIVE_CONN, "10").trim();
        String dataSource = conf.get(CONF_CONN_DATA_SOURCE, "org.apache.commons.dbcp.BasicDataSource");
        boolean autoSchemaCreation = conf.getBoolean(CONF_CREATE_DB_SCHEMA, true);
        boolean validateDbConn = conf.getBoolean(CONF_VALIDATE_DB_CONN, false);
        String evictionInterval = conf.get(CONF_VALIDATE_DB_CONN_EVICTION_INTERVAL, "300000").trim();
        String evictionNum = conf.get(CONF_VALIDATE_DB_CONN_EVICTION_NUM, "10").trim();
        if (!url.startsWith("jdbc:")) {
            throw new ServiceException(ErrorCode.E0608, url, "invalid JDBC URL, must start with 'jdbc:'");
        }
        String dbType = url.substring("jdbc:".length());
        if (dbType.indexOf(":") <= 0) {
            throw new ServiceException(ErrorCode.E0608, url, "invalid JDBC URL, missing vendor 'jdbc:[VENDOR]:...'");
        }
        dbType = dbType.substring(0, dbType.indexOf(":"));
        String persistentUnit = "oozie-" + dbType;
        String ormFile = "META-INF/" + persistentUnit + "-orm.xml";
        try {
            IOUtils.getResourceAsStream(ormFile, -1);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0609, dbType, ormFile);
        }
        String connProps = "DriverClassName={0},Url={1},Username={2},Password={3},MaxActive={4}";
        connProps = MessageFormat.format(connProps, driver, url, user, password, maxConn);
        Properties props = new Properties();
        if (autoSchemaCreation) {
            connProps = connProps + ",TestOnBorrow=false,TestOnReturn=false,TestWhileIdle=false";
            props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        } else if (validateDbConn) {
            String interval = "timeBetweenEvictionRunsMillis=" + evictionInterval;
            String num = "numTestsPerEvictionRun=" + evictionNum;
            connProps = connProps + ",TestOnBorrow=true,TestOnReturn=true,TestWhileIdle=true," + interval + "," + num;
            connProps = connProps + ",ValidationQuery=select count(*) from VALIDATE_CONN";
            connProps = MessageFormat.format(connProps, dbSchema);
        } else {
            connProps = connProps + ",TestOnBorrow=false,TestOnReturn=false,TestWhileIdle=false";
        }
        props.setProperty("openjpa.ConnectionProperties", connProps);
        props.setProperty("openjpa.ConnectionDriverName", dataSource);
        this.factory = Persistence.createEntityManagerFactory((String)persistentUnit, (Map)props);
        EntityManager entityManager = this.getEntityManager();
        entityManager.find(WorkflowActionBean.class, (Object)1);
        entityManager.find(WorkflowJobBean.class, (Object)1);
        entityManager.find(CoordinatorActionBean.class, (Object)1);
        entityManager.find(CoordinatorJobBean.class, (Object)1);
        entityManager.find(JsonWorkflowAction.class, (Object)1);
        entityManager.find(JsonWorkflowJob.class, (Object)1);
        entityManager.find(JsonCoordinatorAction.class, (Object)1);
        entityManager.find(JsonCoordinatorJob.class, (Object)1);
        entityManager.find(SLAEventBean.class, (Object)1);
        entityManager.find(JsonSLAEvent.class, (Object)1);
        entityManager.find(BundleJobBean.class, (Object)1);
        entityManager.find(JsonBundleJob.class, (Object)1);
        entityManager.find(BundleActionBean.class, (Object)1);
        entityManager.find(SLARegistrationBean.class, (Object)1);
        entityManager.find(SLASummaryBean.class, (Object)1);
        LOG.info(1, "All entities initialized", new Object[0]);
        entityManager.getTransaction().begin();
        OpenJPAEntityManagerFactorySPI spi = (OpenJPAEntityManagerFactorySPI)this.factory;
        String logMsg = spi.getConfiguration().getConnectionProperties().replaceAll("Password=.*?,", "Password=***,");
        LOG.info("JPA configuration: {0}", logMsg);
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Override
    public void destroy() {
        if (this.factory != null && this.factory.isOpen()) {
            this.factory.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(JPAExecutor<T> executor) throws JPAExecutorException {
        T t;
        EntityManager em = this.getEntityManager();
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing JPAExecutor [{0}]", executor.getName());
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP, executor.getName(), 1L);
            }
            cron.start();
            em.getTransaction().begin();
            T t2 = executor.execute(em);
            if (em.getTransaction().isActive()) {
                if (FaultInjection.isActive("org.apache.oozie.command.SkipCommitFaultInjection")) {
                    throw new RuntimeException("Skipping Commit for Failover Testing");
                }
                em.getTransaction().commit();
            }
            t = t2;
            cron.stop();
            if (this.instr != null) {
                this.instr.addCron(INSTRUMENTATION_GROUP, executor.getName(), cron);
            }
        }
        catch (PersistenceException e) {
            try {
                throw new JPAExecutorException(ErrorCode.E0603, new Object[]{e});
            }
            catch (Throwable throwable) {
                cron.stop();
                if (this.instr != null) {
                    this.instr.addCron(INSTRUMENTATION_GROUP, executor.getName(), cron);
                }
                try {
                    if (em.getTransaction().isActive()) {
                        LOG.warn("JPAExecutor [{0}] ended with an active transaction, rolling back", executor.getName());
                        em.getTransaction().rollback();
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Could not check/rollback transaction after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
                }
                try {
                    if (em.isOpen()) {
                        em.close();
                        throw throwable;
                    }
                    LOG.warn("JPAExecutor [{0}] closed the EntityManager, it should not!", executor.getName());
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.warn("Could not close EntityManager after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
                }
                throw throwable;
            }
        }
        try {
            if (em.getTransaction().isActive()) {
                LOG.warn("JPAExecutor [{0}] ended with an active transaction, rolling back", executor.getName());
                em.getTransaction().rollback();
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not check/rollback transaction after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
        }
        try {
            if (em.isOpen()) {
                em.close();
                return t;
            }
            LOG.warn("JPAExecutor [{0}] closed the EntityManager, it should not!", executor.getName());
            return t;
        }
        catch (Exception ex) {
            LOG.warn("Could not close EntityManager after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
        }
        return t;
    }

    EntityManager getEntityManager() {
        return this.factory.createEntityManager();
    }
}

