/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.SimpleTimestampedMessageParser;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogStreamer;
import org.apache.oozie.util.ZKUtils;

public class ZKXLogStreamingService
extends XLogStreamingService
implements Service,
Instrumentable {
    private static final String ALL_SERVERS_PARAM = "allservers";
    private ZKUtils zk;
    private XLog log;
    private Class<? extends Authenticator> AuthenticatorClass;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
        this.log = XLog.getLog(this.getClass());
        try {
            this.AuthenticatorClass = this.determineAuthenticatorClassType();
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0100, ex);
        }
    }

    @Override
    public void destroy() {
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        super.instrument(instr);
    }

    @Override
    public void streamLog(XLogStreamer.Filter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.getLogOverWS()) {
            if (params.get(ALL_SERVERS_PARAM) != null && params.get(ALL_SERVERS_PARAM).length > 0 && params.get(ALL_SERVERS_PARAM)[0].equals("false")) {
                new XLogStreamer(filter, xLogService.getOozieLogPath(), xLogService.getOozieLogName(), xLogService.getOozieLogRotation()).streamLog(writer, startTime, endTime);
            } else {
                this.collateLogs(filter, startTime, endTime, writer);
            }
        } else {
            writer.write("Log streaming disabled!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collateLogs(XLogStreamer.Filter filter, Date startTime, Date endTime, Writer writer) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        ArrayList<String> badOozies = new ArrayList<String>();
        List<ServiceInstance<Map>> oozies = null;
        try {
            oozies = this.zk.getAllMetaData();
        }
        catch (Exception ex) {
            throw new IOException("Issue communicating with ZooKeeper: " + ex.getMessage(), ex);
        }
        ArrayList<TimestampedMessageParser> parsers = new ArrayList<TimestampedMessageParser>(oozies.size());
        try {
            for (ServiceInstance<Map> oozie : oozies) {
                Map oozieMeta = (Map)oozie.getPayload();
                String otherId = (String)oozieMeta.get("OOZIE_ID");
                if (otherId.equals(this.zk.getZKId())) {
                    BufferedReader reader = new XLogStreamer(filter, xLogService.getOozieLogPath(), xLogService.getOozieLogName(), xLogService.getOozieLogRotation()).makeReader(startTime, endTime);
                    parsers.add(new TimestampedMessageParser(reader, filter));
                    continue;
                }
                String otherUrl = (String)oozieMeta.get("OOZIE_URL");
                String jobId = filter.getFilterParams().get("JOB");
                try {
                    BufferedReader reader = this.fetchOtherLog(otherUrl, jobId);
                    parsers.add(new SimpleTimestampedMessageParser(reader, filter));
                }
                catch (IOException ioe) {
                    this.log.warn((Object)("Failed to retrieve logs for job [" + jobId + "] from Oozie server with ID [" + otherId + "] at [" + otherUrl + "]; log information may be incomplete"), ioe);
                    badOozies.add(otherId);
                }
            }
            if (!badOozies.isEmpty()) {
                writer.write("Unable to contact the following Oozie Servers for logs (log information may be incomplete):\n");
                for (String badOozie : badOozies) {
                    writer.write("     ");
                    writer.write(badOozie);
                    writer.write("\n");
                }
                writer.write("\n");
                writer.flush();
            }
            if (parsers.size() == 1) {
                TimestampedMessageParser parser = (TimestampedMessageParser)parsers.get(0);
                parser.processRemaining(writer);
            } else {
                TreeMap<String, TimestampedMessageParser> timestampMap = new TreeMap<String, TimestampedMessageParser>();
                for (TimestampedMessageParser parser : parsers) {
                    if (!parser.increment()) continue;
                    timestampMap.put(parser.getLastTimestamp(), parser);
                }
                while (timestampMap.size() > 1) {
                    TimestampedMessageParser earliestParser = (TimestampedMessageParser)timestampMap.pollFirstEntry().getValue();
                    writer.write(earliestParser.getLastMessage());
                    if (!earliestParser.increment()) continue;
                    timestampMap.put(earliestParser.getLastTimestamp(), earliestParser);
                }
                if (timestampMap.size() == 1) {
                    TimestampedMessageParser parser = (TimestampedMessageParser)timestampMap.values().iterator().next();
                    writer.write(parser.getLastMessage());
                    parser.processRemaining(writer);
                }
            }
        }
        finally {
            for (TimestampedMessageParser parser : parsers) {
                parser.closeReader();
            }
            writer.flush();
        }
    }

    private BufferedReader fetchOtherLog(String otherUrl, String jobId) throws IOException {
        final URL url = new URL(otherUrl + "/v" + 2L + "/" + "job" + "/" + jobId + "?" + "show" + "=" + "log" + "&" + ALL_SERVERS_PARAM + "=false");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        this.log.debug("Fetching logs from [{0}]", url);
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BufferedReader>(){

                @Override
                public BufferedReader run() throws IOException {
                    HttpURLConnection conn = ZKXLogStreamingService.this.getConnection(url);
                    BufferedReader reader = null;
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(is));
                    }
                    return reader;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        return reader;
    }

    private HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn;
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        try {
            conn = new AuthenticatedURL(this.AuthenticatorClass.newInstance()).openConnection(url, token);
        }
        catch (AuthenticationException ex) {
            throw new IOException("Could not authenticate, " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new IOException("Could not authenticate, " + ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("Could not authenticate, " + ex.getMessage(), ex);
        }
        if (conn.getResponseCode() != 200) {
            throw new IOException("Unexpected response code [" + conn.getResponseCode() + "], message [" + conn.getResponseMessage() + "]");
        }
        return conn;
    }

    private Class<? extends Authenticator> determineAuthenticatorClassType() throws Exception {
        String authName = Services.get().getConf().get("oozie.authentication.type");
        if (authName == null) {
            throw new IOException("Authentication type must be specified: simple|kerberos|<class>");
        }
        String authClassName = (authName = authName.trim()).equals("simple") ? PseudoAuthenticator.class.getName() : (authName.equals("kerberos") ? KerberosAuthenticator.class.getName() : authName);
        Class<?> authClass = Thread.currentThread().getContextClassLoader().loadClass(authClassName);
        return authClass;
    }
}

