/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.rest.JMSConnectionInfoBean;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.XServletException;

public class V2AdminServlet
extends V1AdminServlet {
    private static final long serialVersionUID = 1L;
    private static final String INSTRUMENTATION_NAME = "v2admin";

    public V2AdminServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected JsonBean getJMSConnectionInfo(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        Configuration conf = Services.get().getConf();
        JMSTopicService jmsTopicService = Services.get().get(JMSTopicService.class);
        String connectionProperties = conf.get("oozie.jms.producer.connection.properties");
        if (connectionProperties == null) {
            throw new XServletException(400, ErrorCode.E1601, "JMS connection property is not defined");
        }
        JMSConnectionInfoBean jmsBean = new JMSConnectionInfoBean();
        JMSConnectionInfo jmsInfo = new JMSConnectionInfo(connectionProperties);
        Properties jmsInfoProps = jmsInfo.getJNDIProperties();
        jmsInfoProps.remove("java.naming.security.principal");
        jmsBean.setJNDIProperties(jmsInfoProps);
        if (jmsTopicService == null) {
            throw new XServletException(400, ErrorCode.E1601, "JMSTopicService is not initialized. JMS notificationmay not be enabled");
        }
        jmsBean.setTopicPrefix(jmsTopicService.getTopicPrefix());
        jmsBean.setTopicPatternProperties(jmsTopicService.getTopicPatternProperties());
        return jmsBean;
    }

    @Override
    protected Map<String, String> getOozieURLs() throws XServletException {
        Map<String, String> serverUrls = null;
        try {
            serverUrls = Services.get().get(JobsConcurrencyService.class).getServerUrls();
        }
        catch (Exception ex) {
            throw new XServletException(400, ErrorCode.E0307, ex.getMessage(), ex);
        }
        return serverUrls;
    }
}

