/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.XServletException;

public class V2JobServlet
extends V1JobServlet {
    private static final String INSTRUMENTATION_NAME = "v2job";

    public V2JobServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected JsonBean getWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean jobBean = super.getWorkflowJobBean(request, response);
        return jobBean;
    }

    @Override
    protected JsonBean getWorkflowAction(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean actionBean = super.getWorkflowActionBean(request, response);
        return actionBean;
    }

    @Override
    protected int getCoordinatorJobLength(int defaultLen, int len) {
        return len < 0 ? defaultLen : len;
    }

    @Override
    protected String getJMSTopicName(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String topicName;
        String jobId = this.getResourceName(request);
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        try {
            topicName = dagEngine.getJMSTopicName(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return topicName;
    }
}

