/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class WritableUtils {
    private static final String NULL = "||";

    public static byte[] toByteArray(Writable writable) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream daos = new DataOutputStream(baos);
            writable.write((DataOutput)daos);
            daos.close();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T extends Writable> T fromByteArray(byte[] array, Class<T> clazz) {
        try {
            Writable o = (Writable)ReflectionUtils.newInstance(clazz, null);
            o.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(array)));
            return (T)o;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeStr(DataOutput dataOutput, String str) throws IOException {
        str = str != null ? str : NULL;
        dataOutput.writeUTF(str);
    }

    public static String readStr(DataInput dataInput) throws IOException {
        String str = dataInput.readUTF();
        return str.equals(NULL) ? null : str;
    }
}

