/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.convert;

import java.util.Map;
import java.util.Properties;
import org.osjava.sj.loader.convert.Converter;

public class MapConverter
implements Converter {
    @Override
    public Object convert(Properties properties, String type) {
        if ("java.util.Map".equals(type)) {
            type = "java.util.HashMap";
        } else if ("java.util.Properties".equals(type)) {
            return properties;
        }
        try {
            Class<?> c = Class.forName(type);
            Map m = (Map)c.newInstance();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                m.put(entry.getKey(), entry.getValue());
            }
            return m;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unable to find class: " + type, cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Unable to instantiate class: " + type, ie);
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException("Unable to access class: " + type, ie);
        }
    }
}

