/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.CallRunner;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class RpcExecutor {
    private static final Log LOG = LogFactory.getLog(RpcExecutor.class);
    private final AtomicInteger activeHandlerCount = new AtomicInteger(0);
    private final List<Thread> handlers;
    private final int handlerCount;
    private final String name;
    private boolean running;
    private static QueueBalancer ONE_QUEUE = new QueueBalancer(){

        @Override
        public int getNextQueue() {
            return 0;
        }
    };

    public RpcExecutor(String name, int handlerCount) {
        this.handlers = new ArrayList<Thread>(handlerCount);
        this.handlerCount = handlerCount;
        this.name = Strings.nullToEmpty((String)name);
    }

    public void start(int port) {
        this.running = true;
        this.startHandlers(port);
    }

    public void stop() {
        this.running = false;
        for (Thread handler : this.handlers) {
            handler.interrupt();
        }
    }

    public int getActiveHandlerCount() {
        return this.activeHandlerCount.get();
    }

    public abstract int getQueueLength();

    public abstract void dispatch(CallRunner var1) throws InterruptedException;

    protected abstract List<BlockingQueue<CallRunner>> getQueues();

    protected void startHandlers(int port) {
        List<BlockingQueue<CallRunner>> callQueues = this.getQueues();
        this.startHandlers(null, this.handlerCount, callQueues, 0, callQueues.size(), port);
    }

    protected void startHandlers(String nameSuffix, int numHandlers, final List<BlockingQueue<CallRunner>> callQueues, int qindex, int qsize, int port) {
        String threadPrefix = this.name + Strings.nullToEmpty((String)nameSuffix);
        for (int i = 0; i < numHandlers; ++i) {
            final int index = qindex + i % qsize;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    RpcExecutor.this.consumerLoop((BlockingQueue)callQueues.get(index));
                }
            });
            t.setDaemon(true);
            t.setName(threadPrefix + "RpcServer.handler=" + this.handlers.size() + ",queue=" + index + ",port=" + port);
            t.start();
            LOG.debug((Object)(threadPrefix + " Start Handler index=" + this.handlers.size() + " queue=" + index));
            this.handlers.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumerLoop(BlockingQueue<CallRunner> myQueue) {
        boolean interrupted = false;
        try {
            while (this.running) {
                try {
                    CallRunner task = myQueue.take();
                    try {
                        this.activeHandlerCount.incrementAndGet();
                        task.run();
                    }
                    finally {
                        this.activeHandlerCount.decrementAndGet();
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static QueueBalancer getBalancer(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0, (Object)"Queue size is <= 0, must be at least 1");
        if (queueSize == 1) {
            return ONE_QUEUE;
        }
        return new RandomQueueBalancer(queueSize);
    }

    private static class RandomQueueBalancer
    extends QueueBalancer {
        private final int queueSize;

        public RandomQueueBalancer(int queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public int getNextQueue() {
            return ThreadLocalRandom.current().nextInt(this.queueSize);
        }
    }

    public static abstract class QueueBalancer {
        public abstract int getNextQueue();
    }
}

