/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.mapreduce.DefaultVisibilityExpressionResolver;
import org.apache.hadoop.hbase.mapreduce.VisibilityExpressionResolver;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CellCreator {
    public static final String VISIBILITY_EXP_RESOLVER_CLASS = "hbase.mapreduce.visibility.expression.resolver.class";
    private VisibilityExpressionResolver visExpResolver;

    public CellCreator(Configuration conf) {
        Class clazz = conf.getClass(VISIBILITY_EXP_RESOLVER_CLASS, DefaultVisibilityExpressionResolver.class, VisibilityExpressionResolver.class);
        this.visExpResolver = (VisibilityExpressionResolver)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        this.visExpResolver.init();
    }

    public Cell create(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, byte[] value, int voffset, int vlength) throws IOException {
        return this.create(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, value, voffset, vlength, null);
    }

    public Cell create(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, byte[] value, int voffset, int vlength, String visExpression) throws IOException {
        List<Tag> visTags = null;
        if (visExpression != null) {
            visTags = this.visExpResolver.createVisibilityExpTags(visExpression);
        }
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, KeyValue.Type.Put, value, voffset, vlength, visTags);
    }
}

